/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

class PSDLayerBlendMode {
    final int mBlendMode;
    final int mOpacity;
    final int mClipping;
    final int mFlags;

    public PSDLayerBlendMode(ImageInputStream pInput) throws IOException {
        int blendModeSig = pInput.readInt();
        if (blendModeSig != 943868237) {
            throw new IIOException("Illegal PSD Blend Mode signature, expected 8BIM: " + PSDUtil.intToStr(blendModeSig));
        }
        this.mBlendMode = pInput.readInt();
        this.mOpacity = pInput.readUnsignedByte();
        this.mClipping = pInput.readUnsignedByte();
        this.mFlags = pInput.readUnsignedByte();
        pInput.readByte();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append("[");
        builder.append("mode: \"").append(PSDUtil.intToStr(this.mBlendMode));
        builder.append("\", opacity: ").append(this.mOpacity);
        builder.append(", clipping: ").append(this.mClipping);
        builder.append(", flags: ").append(PSDLayerBlendMode.byteToBinary(this.mFlags));
        builder.append(" (");
        if ((this.mFlags & 1) != 0) {
            builder.append("Transp. protected ");
        } else {
            builder.append("Transp. open");
        }
        if ((this.mFlags & 2) != 0) {
            builder.append(", Visible");
        } else {
            builder.append(", Hidden");
        }
        if ((this.mFlags & 4) != 0) {
            builder.append(", Obsolete bit");
        }
        if ((this.mFlags & 8) != 0) {
            builder.append(", Photoshop 5 data");
        }
        if ((this.mFlags & 0x10) != 0) {
            builder.append(", Pixel data irrelevant");
        }
        if ((this.mFlags & 0x20) != 0) {
            builder.append(", Unknown bit 5");
        }
        if ((this.mFlags & 0x40) != 0) {
            builder.append(", Unknown bit 6");
        }
        if ((this.mFlags & 0x80) != 0) {
            builder.append(", Unknown bit 7");
        }
        builder.append(")");
        builder.append("]");
        return builder.toString();
    }

    private static String byteToBinary(int pFlags) {
        String flagStr = Integer.toBinaryString(pFlags);
        flagStr = "00000000".substring(flagStr.length()) + flagStr;
        return flagStr;
    }
}

