/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDChannelInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDChannelSourceDestinationRange;
import com.twelvemonkeys.imageio.plugins.psd.PSDLayerBlendMode;
import com.twelvemonkeys.imageio.plugins.psd.PSDLayerMaskData;
import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

class PSDLayerInfo {
    public int mTop;
    public int mLeft;
    public int mBottom;
    public int mRight;
    PSDChannelInfo[] mChannelInfo;
    private PSDLayerBlendMode mBlendMode;
    private PSDLayerMaskData mLayerMaskData;
    private PSDChannelSourceDestinationRange[] mRanges;
    private String mLayerName;

    PSDLayerInfo(ImageInputStream pInput) throws IOException {
        int layerBlendingDataSize;
        this.mTop = pInput.readInt();
        this.mLeft = pInput.readInt();
        this.mBottom = pInput.readInt();
        this.mRight = pInput.readInt();
        int channels = pInput.readUnsignedShort();
        this.mChannelInfo = new PSDChannelInfo[channels];
        for (int i = 0; i < channels; ++i) {
            short channelId = pInput.readShort();
            long length = pInput.readUnsignedInt();
            this.mChannelInfo[i] = new PSDChannelInfo(channelId, length);
        }
        this.mBlendMode = new PSDLayerBlendMode(pInput);
        long extraDataSize = pInput.readUnsignedInt();
        int layerMaskDataSize = pInput.readInt();
        if (layerMaskDataSize != 0) {
            this.mLayerMaskData = new PSDLayerMaskData(pInput, layerMaskDataSize);
        }
        if ((layerBlendingDataSize = pInput.readInt()) % 8 != 0) {
            throw new IIOException("Illegal PSD Layer Blending Data size: " + layerBlendingDataSize + ", expected multiple of 8");
        }
        this.mRanges = new PSDChannelSourceDestinationRange[layerBlendingDataSize / 8];
        for (int i = 0; i < this.mRanges.length; ++i) {
            this.mRanges[i] = new PSDChannelSourceDestinationRange(pInput, i == 0 ? "Gray" : "Channel " + (i - 1));
        }
        this.mLayerName = PSDUtil.readPascalString(pInput);
        int layerNameSize = this.mLayerName.length() + 1;
        if (layerNameSize % 2 != 0) {
            ++layerNameSize;
        }
        if (layerNameSize % 4 != 0) {
            pInput.skipBytes(2);
            layerNameSize += 2;
        }
        pInput.skipBytes(extraDataSize - (long)layerMaskDataSize - 4L - (long)layerBlendingDataSize - 4L - (long)layerNameSize);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append("[");
        builder.append("top: ").append(this.mTop);
        builder.append(", left: ").append(this.mLeft);
        builder.append(", bottom: ").append(this.mBottom);
        builder.append(", right: ").append(this.mRight);
        builder.append(", channels: ").append(Arrays.toString(this.mChannelInfo));
        builder.append(", blend mode: ").append(this.mBlendMode);
        if (this.mLayerMaskData != null) {
            builder.append(", layer mask data: ").append(this.mLayerMaskData);
        }
        builder.append(", ranges: ").append(Arrays.toString(this.mRanges));
        builder.append(", layer name: \"").append(this.mLayerName).append("\"");
        builder.append("]");
        return builder.toString();
    }
}

