/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

class PSDLayerMaskData {
    private int mTop;
    private int mLeft;
    private int mBottom;
    private int mRight;
    private int mDefaultColor;
    private int mFlags;
    private boolean mLarge;
    private int mRealFlags;
    private int mRealUserBackground;
    private int mRealTop;
    private int mRealLeft;
    private int mRealBottom;
    private int mRealRight;

    PSDLayerMaskData(ImageInputStream pInput, int pSize) throws IOException {
        if (pSize != 20 && pSize != 36) {
            throw new IIOException("Illegal PSD Layer Mask data size: " + pSize + " (expeced 20 or 36)");
        }
        this.mTop = pInput.readInt();
        this.mLeft = pInput.readInt();
        this.mBottom = pInput.readInt();
        this.mRight = pInput.readInt();
        this.mDefaultColor = pInput.readUnsignedByte();
        this.mFlags = pInput.readUnsignedByte();
        if (pSize == 20) {
            pInput.readShort();
        } else {
            this.mLarge = true;
            this.mRealFlags = pInput.readUnsignedByte();
            this.mRealUserBackground = pInput.readUnsignedByte();
            this.mRealTop = pInput.readInt();
            this.mRealLeft = pInput.readInt();
            this.mRealBottom = pInput.readInt();
            this.mRealRight = pInput.readInt();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append("[");
        builder.append("top: ").append(this.mTop);
        builder.append(", left: ").append(this.mLeft);
        builder.append(", bottom: ").append(this.mBottom);
        builder.append(", right: ").append(this.mRight);
        builder.append(", default color: ").append(this.mDefaultColor);
        builder.append(", flags: ").append(Integer.toBinaryString(this.mFlags));
        builder.append(" (");
        if ((this.mFlags & 1) != 0) {
            builder.append("Pos. rel. to layer");
        } else {
            builder.append("Pos. abs.");
        }
        if ((this.mFlags & 2) != 0) {
            builder.append(", Mask disabled");
        } else {
            builder.append(", Mask enabled");
        }
        if ((this.mFlags & 4) != 0) {
            builder.append(", Invert mask");
        }
        if ((this.mFlags & 8) != 0) {
            builder.append(", Unknown bit 3");
        }
        if ((this.mFlags & 0x10) != 0) {
            builder.append(", Unknown bit 4");
        }
        if ((this.mFlags & 0x20) != 0) {
            builder.append(", Unknown bit 5");
        }
        if ((this.mFlags & 0x40) != 0) {
            builder.append(", Unknown bit 6");
        }
        if ((this.mFlags & 0x80) != 0) {
            builder.append(", Unknown bit 7");
        }
        builder.append(")");
        builder.append("]");
        return builder.toString();
    }
}

