/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.plugins.psd.PSDChannelInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDColorData;
import com.twelvemonkeys.imageio.plugins.psd.PSDGlobalLayerMask;
import com.twelvemonkeys.imageio.plugins.psd.PSDHeader;
import com.twelvemonkeys.imageio.plugins.psd.PSDImageResource;
import com.twelvemonkeys.imageio.plugins.psd.PSDLayerInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSDLayerReader
extends ImageReaderBase {
    private PSDHeader mHeader;
    private PSDColorData mColorData;
    private List<PSDImageResource> mImageResources;
    private PSDGlobalLayerMask mGlobalLayerMask;
    private List<PSDLayerInfo> mLayerInfo;
    private PSDLayerInfo[] mLayerInfoArray;
    private long mLayerInfoPos;
    private long mLayerInfoLength;
    private int mLayerIndex;

    public PSDLayerReader(ImageReaderSpi pOriginatingProvider) {
        super(pOriginatingProvider);
    }

    protected void resetMembers() {
        this.mHeader = null;
        this.mColorData = null;
        this.mImageResources = null;
        this.mLayerInfoLength = 0L;
        this.mLayerInfoPos = 0L;
    }

    public int getWidth(int pIndex) throws IOException {
        this.checkBounds(pIndex);
        this.readHeader();
        return this.mHeader.mWidth;
    }

    public int getHeight(int pIndex) throws IOException {
        this.checkBounds(pIndex);
        this.readHeader();
        return this.mHeader.mHeight;
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int pIndex) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(ColorSpace cs) throws IOException {
        ArrayList<ImageTypeSpecifier> types = new ArrayList<ImageTypeSpecifier>();
        if (cs == null) {
            cs = ColorSpace.getInstance(1000);
        }
        types.add(ImageTypeSpecifier.createInterleaved(cs, new int[]{2, 1, 0, 3}, 0, true, true));
        return types.iterator();
    }

    public BufferedImage read(int pIndex, ImageReadParam pParam) throws IOException {
        throw new UnsupportedOperationException();
    }

    public PSDLayerInfo[] getLayerInfos() throws IOException {
        this.readHeader();
        this.readImageResources(false);
        this.readLayerInfo(true);
        return this.mLayerInfoArray;
    }

    public BufferedImage nextLayer(ImageReadParam pParam) throws IOException {
        if (this.mLayerIndex >= this.mLayerInfoArray.length) {
            throw new IndexOutOfBoundsException(this.mLayerIndex + " >= " + this.mLayerInfoArray.length);
        }
        PSDLayerInfo layerInfo = this.mLayerInfoArray[this.mLayerIndex++];
        int width = layerInfo.mRight - layerInfo.mLeft;
        int height = layerInfo.mBottom - layerInfo.mTop;
        int channels = layerInfo.mChannelInfo.length;
        BufferedImage image = PSDLayerReader.getDestination((ImageReadParam)pParam, this.getImageTypes(null), (int)width, (int)height);
        ColorModel cm = image.getColorModel();
        boolean isCMYK = cm.getColorSpace().getType() == 9;
        int numColorComponents = cm.getColorSpace().getNumComponents();
        WritableRaster raster = image.getRaster();
        if (!(raster.getDataBuffer() instanceof DataBufferByte)) {
            throw new IIOException("Unsupported raster type: " + raster);
        }
        byte[] data = ((DataBufferByte)raster.getDataBuffer()).getData();
        int bands = raster.getNumBands();
        block8: for (int c = 0; c < channels; ++c) {
            short compression = this.mImageInput.readShort();
            switch (compression) {
                case 0: {
                    int x;
                    for (int y = 0; y < height; ++y) {
                        for (x = 0; x < width; ++x) {
                            int offset = (x + y * width) * bands;
                            byte value = this.mImageInput.readByte();
                            if (isCMYK && c < numColorComponents) {
                                value = (byte)(255 - value & 0xFF);
                            }
                            data[offset + (bands - 1 - c)] = value;
                        }
                    }
                    continue block8;
                }
                case 1: {
                    int[] offsets = new int[channels * height];
                    for (int i = 0; i < offsets.length; ++i) {
                        offsets[i] = this.mImageInput.readUnsignedShort();
                    }
                    int x = 0;
                    int y = 0;
                    try {
                        for (y = 0; y < height; ++y) {
                            int length = offsets[c * height + y];
                            DataInputStream input = PSDUtil.createPackBitsStream(this.mImageInput, length);
                            for (x = 0; x < width; ++x) {
                                int offset = (x + y * width) * bands;
                                byte value = input.readByte();
                                if (isCMYK && c < numColorComponents) {
                                    value = (byte)(255 - value & 0xFF);
                                }
                                data[offset + (bands - 1 - c)] = value;
                            }
                            input.close();
                        }
                        continue block8;
                    }
                    catch (IOException e) {
                        System.err.println("c: " + c);
                        System.err.println("y: " + y);
                        System.err.println("x: " + x);
                        throw e;
                    }
                    catch (IndexOutOfBoundsException e) {
                        e.printStackTrace();
                        System.out.println("data.length: " + data.length);
                        System.err.println("c: " + c);
                        System.err.println("y: " + y);
                        System.err.println("x: " + x);
                        throw e;
                    }
                }
                case 2: 
                case 3: {
                    throw new IIOException("ZIP compression not supported yet");
                }
                default: {
                    throw new IIOException("Unknown compression type: " + compression);
                }
            }
        }
        return image;
    }

    private void readHeader() throws IOException {
        this.assertInput();
        if (this.mHeader == null) {
            this.mHeader = new PSDHeader(this.mImageInput);
            if (this.mHeader.mMode == 2) {
                this.mColorData = new PSDColorData(this.mImageInput);
            } else {
                long length = this.mImageInput.readUnsignedInt();
                this.mImageInput.skipBytes(length);
            }
            this.mImageInput.flushBefore(this.mImageInput.getStreamPosition());
        }
    }

    private void readImageResources(boolean pParseData) throws IOException {
        long pos = this.mImageInput.getFlushedPosition();
        this.mImageInput.seek(pos);
        long length = this.mImageInput.readUnsignedInt();
        if (pParseData && length > 0L && this.mImageResources == null) {
            this.mImageResources = new ArrayList<PSDImageResource>();
            long expectedEnd = this.mImageInput.getStreamPosition() + length;
            while (this.mImageInput.getStreamPosition() < expectedEnd) {
                PSDImageResource resource = PSDImageResource.read(this.mImageInput);
                this.mImageResources.add(resource);
            }
            if (this.mImageInput.getStreamPosition() != expectedEnd) {
                throw new IIOException("Corrupt PSD document");
            }
        }
        this.mImageInput.seek(pos + length + 4L);
    }

    private void readLayerInfo(boolean pParseData) throws IOException {
        long length = this.mImageInput.readUnsignedInt();
        if (pParseData && length > 0L) {
            this.mLayerInfoPos = this.mImageInput.getStreamPosition();
            this.mLayerInfoLength = this.mImageInput.readUnsignedInt();
            short layers = this.mImageInput.readShort();
            this.mLayerInfoArray = new PSDLayerInfo[Math.abs(layers)];
            for (int i = 0; i < this.mLayerInfoArray.length; ++i) {
                this.mLayerInfoArray[i] = new PSDLayerInfo(this.mImageInput);
            }
            this.mLayerInfo = Arrays.asList(this.mLayerInfoArray);
        } else {
            this.mImageInput.skipBytes(length);
        }
    }

    private void readChannelData() throws IOException {
        for (PSDLayerInfo info : this.mLayerInfoArray) {
            for (PSDChannelInfo channelInfo : info.mChannelInfo) {
                int compression = this.mImageInput.readUnsignedShort();
                switch (compression) {
                    case 0: {
                        System.out.println("Compression: None");
                        break;
                    }
                    case 1: {
                        System.out.println("Compression: PackBits RLE");
                        break;
                    }
                    case 2: {
                        System.out.println("Compression: ZIP");
                        break;
                    }
                    case 3: {
                        System.out.println("Compression: ZIP with prediction");
                        break;
                    }
                    default: {
                        throw new IIOException("Unknown PSD compression: " + compression + " (expected 0, 1, 2 or 3)");
                    }
                }
                this.mImageInput.skipBytes(channelInfo.mLength - 2L);
            }
        }
    }

    private void readMaskInfo() throws IOException {
        long read = this.mImageInput.getStreamPosition() - this.mLayerInfoPos;
        long diff = this.mLayerInfoLength - (read - 4L);
        this.mImageInput.skipBytes(diff);
        long layerMaskInfoLength = this.mImageInput.readUnsignedInt();
        if (layerMaskInfoLength > 0L) {
            this.mGlobalLayerMask = new PSDGlobalLayerMask(this.mImageInput);
        }
        read = this.mImageInput.getStreamPosition() - this.mLayerInfoPos;
        long toSkip = this.mLayerInfoLength - read;
        this.mImageInput.skipBytes(toSkip);
    }

    private void readLayerAndMaskInfo(boolean pParseData) throws IOException {
        this.readLayerInfo(pParseData);
        if (pParseData && this.mLayerInfoLength != 0L) {
            this.readChannelData();
            this.readMaskInfo();
        }
    }

    public static void main(String[] pArgs) throws IOException {
        PSDLayerReader layerReader = new PSDLayerReader(null);
        File file = new File(pArgs[0]);
        ImageInputStream stream = ImageIO.createImageInputStream(file);
        layerReader.setInput(stream);
        PSDLayerInfo[] layerInfos = layerReader.getLayerInfos();
        long start = System.currentTimeMillis();
        ImageReadParam param = new ImageReadParam();
        for (int layerIndex = 0; layerIndex < layerInfos.length; ++layerIndex) {
            BufferedImage image = layerReader.nextLayer(param);
            PSDLayerReader.showIt((BufferedImage)image, (String)file.getName());
        }
    }
}

