/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

class PSDReader {
    public static final int STATUS_OK = 0;
    public static final int STATUS_FORMAT_ERROR = 1;
    public static final int STATUS_OPEN_ERROR = 2;
    public static final int STATUS_UNSUPPORTED = 3;
    public static int ImageType = 2;
    protected BufferedInputStream input;
    protected int frameCount;
    protected BufferedImage[] frames;
    protected int status = 0;
    protected int nChan;
    protected int width;
    protected int height;
    protected int nLayers;
    protected int miscLen;
    protected boolean hasLayers;
    protected LayerInfo[] layers;
    protected short[] lineLengths;
    protected int lineIndex;
    protected boolean rleEncoded;

    PSDReader() {
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    protected void setInput(InputStream stream) {
        this.init();
        if (stream == null) {
            this.status = 2;
        } else {
            this.input = stream instanceof BufferedInputStream ? (BufferedInputStream)stream : new BufferedInputStream(stream);
        }
    }

    protected void setInput(String name) {
        this.init();
        try {
            name = name.trim();
            if (name.startsWith("file:")) {
                name = name.substring(5);
                while (name.startsWith("/")) {
                    name = name.substring(1);
                }
            }
            if (name.indexOf("://") > 0) {
                URL url = new URL(name);
                this.input = new BufferedInputStream(url.openStream());
            } else {
                this.input = new BufferedInputStream(new FileInputStream(name));
            }
        }
        catch (IOException e) {
            this.status = 2;
        }
    }

    public int getDelay(int forFrame) {
        return 0;
    }

    public BufferedImage getFrame(int n) {
        BufferedImage im = null;
        if (n >= 0 && n < this.nLayers) {
            im = this.frames[n];
            LayerInfo info = this.layers[n];
            if (info.w != this.width || info.h != this.height) {
                BufferedImage temp = new BufferedImage(this.width, this.height, ImageType);
                Graphics2D gc = temp.createGraphics();
                gc.drawImage((Image)im, info.x, info.y, null);
                gc.dispose();
                this.frames[n] = im = temp;
            }
        }
        return im;
    }

    public Dimension getFrameSize() {
        return new Dimension(this.width, this.height);
    }

    public BufferedImage getImage() {
        return this.getFrame(0);
    }

    public BufferedImage getLayer(int n) {
        BufferedImage im = null;
        if (n >= 0 && n < this.nLayers) {
            im = this.frames[n];
        }
        return im;
    }

    public Point getLayerOffset(int n) {
        Point p = null;
        if (n >= 0 && n < this.nLayers) {
            int x = this.layers[n].x;
            int y = this.layers[n].y;
            p = new Point(x, y);
        }
        if (p == null) {
            p = new Point(0, 0);
        }
        return p;
    }

    public int read(InputStream stream) {
        this.setInput(stream);
        this.process();
        return this.status;
    }

    public int read(String name) {
        this.setInput(name);
        this.process();
        return this.status;
    }

    public void reset() {
        this.init();
    }

    protected void close() {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.input = null;
        }
    }

    protected boolean err() {
        return this.status != 0;
    }

    protected byte[] fillBytes(int size, int value) {
        byte[] b = new byte[size];
        if (value != 0) {
            byte v = (byte)value;
            for (int i = 0; i < size; ++i) {
                b[i] = v;
            }
        }
        return b;
    }

    protected void init() {
        this.close();
        this.frameCount = 0;
        this.frames = null;
        this.layers = null;
        this.hasLayers = true;
        this.status = 0;
    }

    protected void makeDummyLayer() {
        LayerInfo layer;
        this.rleEncoded = this.readShort() == 1;
        this.hasLayers = false;
        this.nLayers = 1;
        this.layers = new LayerInfo[1];
        this.layers[0] = layer = new LayerInfo();
        layer.h = this.height;
        layer.w = this.width;
        int nc = Math.min(this.nChan, 4);
        if (this.rleEncoded) {
            this.readLineLengths(this.height * nc);
        }
        layer.nChan = nc;
        layer.chanID = new int[nc];
        for (int i = 0; i < nc; ++i) {
            int id = i;
            if (i == 3) {
                id = -1;
            }
            layer.chanID[i] = id;
        }
    }

    protected void readLineLengths(int nLines) {
        this.lineLengths = new short[nLines];
        for (int i = 0; i < nLines; ++i) {
            this.lineLengths[i] = this.readShort();
        }
        this.lineIndex = 0;
    }

    protected BufferedImage makeImage(int w, int h, byte[] r, byte[] g, byte[] b, byte[] a) {
        BufferedImage im = new BufferedImage(w, h, 2);
        int[] data = ((DataBufferInt)im.getRaster().getDataBuffer()).getData();
        int n = w * h;
        for (int j = 0; j < n; ++j) {
            try {
                int ac = a[j] & 0xFF;
                int rc = r[j] & 0xFF;
                int gc = g[j] & 0xFF;
                int bc = b[j] & 0xFF;
                data[j] = ((ac << 8 | rc) << 8 | gc) << 8 | bc;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return im;
    }

    protected void process() {
        if (this.err()) {
            return;
        }
        this.readHeader();
        if (this.err()) {
            return;
        }
        this.readLayerInfo();
        if (this.err()) {
            return;
        }
        if (this.nLayers == 0) {
            this.makeDummyLayer();
            if (this.err()) {
                return;
            }
        }
        this.readLayers();
    }

    protected int readByte() {
        int curByte = 0;
        try {
            curByte = this.input.read();
        }
        catch (IOException e) {
            this.status = 1;
        }
        return curByte;
    }

    protected int readBytes(byte[] bytes, int n) {
        if (bytes == null) {
            return 0;
        }
        int r = 0;
        try {
            r = this.input.read(bytes, 0, n);
        }
        catch (IOException e) {
            this.status = 1;
        }
        if (r < n) {
            this.status = 1;
        }
        return r;
    }

    protected void readHeader() {
        String sig = this.readString(4);
        short ver = this.readShort();
        this.skipBytes(6);
        this.nChan = this.readShort();
        this.height = this.readInt();
        this.width = this.readInt();
        short depth = this.readShort();
        short mode = this.readShort();
        int cmLen = this.readInt();
        this.skipBytes(cmLen);
        int imResLen = this.readInt();
        this.skipBytes(imResLen);
        if (!sig.equals("8BPS") || ver != 1) {
            this.status = 1;
        } else if (depth != 8 || mode != 3) {
            this.status = 3;
        }
    }

    protected int readInt() {
        return ((this.readByte() << 8 | this.readByte()) << 8 | this.readByte()) << 8 | this.readByte();
    }

    protected void readLayerInfo() {
        this.miscLen = this.readInt();
        if (this.miscLen == 0) {
            return;
        }
        int layerInfoLen = this.readInt();
        this.nLayers = this.readShort();
        if (this.nLayers > 0) {
            this.layers = new LayerInfo[this.nLayers];
        }
        for (int i = 0; i < this.nLayers; ++i) {
            LayerInfo info;
            this.layers[i] = info = new LayerInfo();
            info.y = this.readInt();
            info.x = this.readInt();
            info.h = this.readInt() - info.y;
            info.w = this.readInt() - info.x;
            info.nChan = this.readShort();
            info.chanID = new int[info.nChan];
            for (int j = 0; j < info.nChan; ++j) {
                short id = this.readShort();
                int size = this.readInt();
                info.chanID[j] = id;
            }
            String s = this.readString(4);
            if (!s.equals("8BIM")) {
                this.status = 1;
                return;
            }
            this.skipBytes(4);
            info.alpha = this.readByte();
            int clipping = this.readByte();
            int flags = this.readByte();
            this.readByte();
            int extraSize = this.readInt();
            this.skipBytes(extraSize);
        }
    }

    protected void readLayers() {
        this.frameCount = this.nLayers;
        this.frames = new BufferedImage[this.nLayers];
        for (int i = 0; i < this.nLayers; ++i) {
            BufferedImage im;
            LayerInfo info = this.layers[i];
            byte[] r = null;
            byte[] g = null;
            byte[] b = null;
            byte[] a = null;
            for (int j = 0; j < info.nChan; ++j) {
                int id = info.chanID[j];
                switch (id) {
                    case 0: {
                        r = this.readPlane(info.w, info.h);
                        break;
                    }
                    case 1: {
                        g = this.readPlane(info.w, info.h);
                        break;
                    }
                    case 2: {
                        b = this.readPlane(info.w, info.h);
                        break;
                    }
                    case -1: {
                        a = this.readPlane(info.w, info.h);
                        break;
                    }
                    default: {
                        this.readPlane(info.w, info.h);
                    }
                }
                if (this.err()) break;
            }
            if (this.err()) break;
            int n = info.w * info.h;
            if (r == null) {
                r = this.fillBytes(n, 0);
            }
            if (g == null) {
                g = this.fillBytes(n, 0);
            }
            if (b == null) {
                b = this.fillBytes(n, 0);
            }
            if (a == null) {
                a = this.fillBytes(n, 255);
            }
            this.frames[i] = im = this.makeImage(info.w, info.h, r, g, b, a);
        }
        this.lineLengths = null;
        if (this.miscLen > 0 && !this.err()) {
            int n = this.readInt();
            this.skipBytes(n);
        }
    }

    protected byte[] readPlane(int w, int h) {
        byte[] b = null;
        int size = w * h;
        if (this.hasLayers) {
            boolean bl = this.rleEncoded = this.readShort() == 1;
            if (this.rleEncoded) {
                this.readLineLengths(h);
            }
        }
        if (this.rleEncoded) {
            b = this.readPlaneCompressed(w, h);
        } else {
            b = new byte[size];
            this.readBytes(b, size);
        }
        return b;
    }

    protected byte[] readPlaneCompressed(int w, int h) {
        byte[] b = new byte[w * h];
        byte[] s = new byte[w * 2];
        int pos = 0;
        for (int i = 0; i < h; ++i) {
            if (this.lineIndex >= this.lineLengths.length) {
                this.status = 1;
                return null;
            }
            short len = this.lineLengths[this.lineIndex++];
            this.readBytes(s, len);
            this.decodeRLE(s, 0, len, b, pos);
            pos += w;
        }
        return b;
    }

    protected void decodeRLE(byte[] src, int sindex, int slen, byte[] dst, int dindex) {
        try {
            int max = sindex + slen;
            while (sindex < max) {
                int b;
                int n;
                if ((n = (b = src[sindex++])) < 0) {
                    n = 1 - n;
                    b = src[sindex++];
                    for (int i = 0; i < n; ++i) {
                        dst[dindex++] = b;
                    }
                    continue;
                }
                System.arraycopy(src, sindex, dst, dindex, ++n);
                dindex += n;
                sindex += n;
            }
        }
        catch (Exception e) {
            this.status = 1;
        }
    }

    protected short readShort() {
        return (short)(this.readByte() << 8 | this.readByte());
    }

    protected String readString(int len) {
        String s = "";
        for (int i = 0; i < len; ++i) {
            s = s + (char)this.readByte();
        }
        return s;
    }

    protected void skipBytes(int n) {
        for (int i = 0; i < n; ++i) {
            this.readByte();
        }
    }

    protected class LayerInfo {
        int x;
        int y;
        int w;
        int h;
        int nChan;
        int[] chanID;
        int alpha;

        protected LayerInfo() {
        }
    }
}

