/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDImageResource;
import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

class PSDResolutionInfo
extends PSDImageResource {
    private float mHRes;
    private short mHResUnit;
    private short mWidthUnit;
    private float mVRes;
    private short mVResUnit;
    private short mHeightUnit;

    PSDResolutionInfo(short pId, ImageInputStream pInput) throws IOException {
        super(pId, pInput);
    }

    protected void readData(ImageInputStream pInput) throws IOException {
        if (this.mSize != 16L) {
            throw new IIOException("Resolution info length expected to be 16: " + this.mSize);
        }
        this.mHRes = PSDUtil.fixedPointToFloat(pInput.readInt());
        this.mHResUnit = pInput.readShort();
        this.mWidthUnit = pInput.readShort();
        this.mVRes = PSDUtil.fixedPointToFloat(pInput.readInt());
        this.mVResUnit = pInput.readShort();
        this.mHeightUnit = pInput.readShort();
    }

    public String toString() {
        StringBuilder builder = this.toStringBuilder();
        builder.append(", hRes: ").append(this.mHRes);
        builder.append(" ");
        builder.append(this.resUnit(this.mHResUnit));
        builder.append(", width unit: ");
        builder.append(this.dimUnit(this.mWidthUnit));
        builder.append(", vRes: ").append(this.mVRes);
        builder.append(" ");
        builder.append(this.resUnit(this.mVResUnit));
        builder.append(", height unit: ");
        builder.append(this.dimUnit(this.mHeightUnit));
        builder.append("]");
        return builder.toString();
    }

    private String resUnit(short pResUnit) {
        switch (pResUnit) {
            case 1: {
                return "pixels/inch";
            }
            case 2: {
                return "pixels/cm";
            }
        }
        return "unknown unit " + pResUnit;
    }

    private String dimUnit(short pUnit) {
        switch (pUnit) {
            case 1: {
                return "in";
            }
            case 2: {
                return "cm";
            }
            case 3: {
                return "pt";
            }
            case 4: {
                return "pica";
            }
            case 5: {
                return "column";
            }
        }
        return "unknown unit " + pUnit;
    }
}

