/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDImageResource;
import com.twelvemonkeys.imageio.util.IIOUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;

class PSDThumbnail
extends PSDImageResource {
    private BufferedImage mThumbnail;
    private int mWidth;
    private int mHeight;

    public PSDThumbnail(short pId, ImageInputStream pInput) throws IOException {
        super(pId, pInput);
    }

    protected void readData(ImageInputStream pInput) throws IOException {
        int format = pInput.readInt();
        switch (format) {
            case 0: {
                throw new IIOException("RAW RGB format thumbnail not supported yet");
            }
            case 1: {
                break;
            }
            default: {
                throw new IIOException(String.format("Unsupported thumbnail format (%s) in PSD document", format));
            }
        }
        this.mWidth = pInput.readInt();
        this.mHeight = pInput.readInt();
        int widthBytes = pInput.readInt();
        int totalSize = pInput.readInt();
        int sizeCompressed = pInput.readInt();
        if ((long)sizeCompressed != this.mSize - 28L) {
            throw new IIOException("Corrupt thumbnail in PSD document");
        }
        int bits = pInput.readUnsignedShort();
        int planes = pInput.readUnsignedShort();
        if (bits == 24 || planes != 1) {
            // empty if block
        }
        this.mThumbnail = ImageIO.read(IIOUtil.createStreamAdapter((ImageInputStream)pInput, (long)sizeCompressed));
    }

    public final int getWidth() {
        return this.mWidth;
    }

    public final int getHeight() {
        return this.mHeight;
    }

    public final BufferedImage getThumbnail() {
        return this.mThumbnail;
    }

    public String toString() {
        StringBuilder builder = this.toStringBuilder();
        builder.append(", ").append(this.mThumbnail);
        builder.append("]");
        return builder.toString();
    }
}

