/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.io.enc.Decoder;
import com.twelvemonkeys.io.enc.DecoderStream;
import com.twelvemonkeys.io.enc.PackBitsDecoder;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipInputStream;
import javax.imageio.stream.ImageInputStream;

final class PSDUtil {
    PSDUtil() {
    }

    static String intToStr(int pChunkId) {
        return new String(new byte[]{(byte)((pChunkId & 0xFF000000) >> 24), (byte)((pChunkId & 0xFF0000) >> 16), (byte)((pChunkId & 0xFF00) >> 8), (byte)(pChunkId & 0xFF)});
    }

    static String readPascalString(ImageInputStream pInput) throws IOException {
        int length = pInput.readUnsignedByte();
        byte[] bytes = new byte[length];
        pInput.readFully(bytes);
        if (length % 2 == 0) {
            pInput.readByte();
        }
        return new String(bytes);
    }

    static String readPascalStringByte(ImageInputStream pInput) throws IOException {
        int length = pInput.readUnsignedByte();
        byte[] bytes = new byte[length];
        pInput.readFully(bytes);
        return new String(bytes);
    }

    static DataInputStream createPackBitsStream(ImageInputStream pInput, long pLength) {
        return new DataInputStream((InputStream)new DecoderStream(IIOUtil.createStreamAdapter((ImageInputStream)pInput, (long)pLength), (Decoder)new PackBitsDecoder()));
    }

    static DataInputStream createZipStream(ImageInputStream pInput, long pLength) {
        return new DataInputStream(new ZipInputStream(IIOUtil.createStreamAdapter((ImageInputStream)pInput, (long)pLength)));
    }

    static DataInputStream createZipPredictorStream(ImageInputStream pInput, long pLength) {
        throw new UnsupportedOperationException("Method createZipPredictonStream not implemented");
    }

    public static float fixedPointToFloat(int pFP) {
        return (float)((pFP & 0xFFFF0000) >> 16) + (float)(pFP & 0xFFFF) / 65535.0f;
    }
}

