/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDImageResource;
import com.twelvemonkeys.lang.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.imageio.stream.ImageInputStream;

final class PSDXMPData
extends PSDImageResource {
    protected byte[] mData;

    PSDXMPData(short pId, ImageInputStream pInput) throws IOException {
        super(pId, pInput);
    }

    protected void readData(ImageInputStream pInput) throws IOException {
        this.mData = new byte[(int)this.mSize];
        pInput.readFully(this.mData);
    }

    public String toString() {
        StringBuilder builder = this.toStringBuilder();
        int length = Math.min(256, this.mData.length);
        String data = StringUtil.decode((byte[])this.mData, (int)0, (int)length, (String)"UTF-8").replace('\n', ' ').replaceAll("\\s+", " ");
        builder.append(", data: \"").append(data);
        if (length < this.mData.length) {
            builder.append("...");
        }
        builder.append("\"]");
        return builder.toString();
    }

    public Reader getData() {
        return new InputStreamReader((InputStream)new ByteArrayInputStream(this.mData), Charset.forName("UTF-8"));
    }
}

