/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common;

import com.day.cq.dam.api.s7dam.config.S7damConfigResolver;
import com.day.cq.dam.s7dam.common.sync.S7damAssetSyncService;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.event.EventUtil;
import org.apache.sling.event.jobs.JobProcessor;
import org.apache.sling.event.jobs.JobUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, immediate=true)
@Service(value={EventHandler.class})
@Property(name="event.topics", value={"com/day/cq/dam/s7dam/update/job"})
public class S7damDamChangeEventHandler
implements JobProcessor,
EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(S7damDamChangeEventHandler.class);
    @Reference
    private S7damAssetSyncService s7damAssetSyncService;
    @Reference
    private S7damConfigResolver s7configResolver;

    public boolean process(Event event) {
        String jobType = (String)event.getProperty("s7dam.eventtype");
        logger.trace("handle S7 dam Job Request [{}]", (Object)jobType);
        if ("s7dam.pv_deleteasset".equals(jobType)) {
            this.processDeleteAsset(event);
        } else if ("s7dam.pv_moveasset".equals(jobType)) {
            this.processMoveAsset(event);
        } else if ("s7dam.pv_movefolder".equals(jobType)) {
            this.processMoveFolder(event);
        } else if ("s7dam.pv_updateoptimzedtiff".equals(jobType)) {
            this.processUpdatePublishedAsset(event);
        } else if ("s7dam.pv_set_addimg".equals(jobType) || "s7dam.pv_set_orderchanged".equals(jobType) || "s7dam.pv_set_removeImage".equals(jobType) || "s7dam.pv_moveset".equals(jobType) || "s7dam.pv_removeset".equals(jobType)) {
            this.processUpdateAsset(event);
        } else {
            logger.warn("Unhandled S7dam Job Request [{}]", (Object)jobType);
        }
        return true;
    }

    private void processMoveAsset(Event event) {
        String srcPath = (String)event.getProperty("s7dam.srcpath");
        String dstPath = (String)event.getProperty("s7dam.dstpath");
        this.s7damAssetSyncService.moveFile(dstPath, srcPath, this.s7configResolver.getS7damConfig(null));
    }

    private void processMoveFolder(Event event) {
        String srcPath = (String)event.getProperty("s7dam.srcpath");
        String dstPath = (String)event.getProperty("s7dam.dstpath");
        this.s7damAssetSyncService.moveFolder(dstPath, srcPath, this.s7configResolver.getS7damConfig(null));
    }

    private void processDeleteAsset(Event event) {
        String assetPath = (String)event.getProperty("s7dam.srcpath");
        this.s7damAssetSyncService.deleteFile(assetPath, this.s7configResolver.getS7damConfig(null));
    }

    private void processUpdatePublishedAsset(Event event) {
        String assetPath = (String)event.getProperty("s7dam.srcpath");
        this.s7damAssetSyncService.updatePublishedAsset(assetPath, this.s7configResolver.getS7damConfig(null));
    }

    private void processUpdateAsset(Event event) {
        String assetPath = (String)event.getProperty("s7dam.srcpath");
        this.s7damAssetSyncService.updateAsset(assetPath, this.s7configResolver.getS7damConfig(null));
    }

    public void handleEvent(Event event) {
        if (EventUtil.isLocal((Event)event)) {
            JobUtil.processJob((Event)event, (JobProcessor)this);
        }
    }

    protected void bindS7damAssetSyncService(S7damAssetSyncService s7damAssetSyncService) {
        this.s7damAssetSyncService = s7damAssetSyncService;
    }

    protected void unbindS7damAssetSyncService(S7damAssetSyncService s7damAssetSyncService) {
        if (this.s7damAssetSyncService == s7damAssetSyncService) {
            this.s7damAssetSyncService = null;
        }
    }

    protected void bindS7configResolver(S7damConfigResolver s7damConfigResolver) {
        this.s7configResolver = s7damConfigResolver;
    }

    protected void unbindS7configResolver(S7damConfigResolver s7damConfigResolver) {
        if (this.s7configResolver == s7damConfigResolver) {
            this.s7configResolver = null;
        }
    }
}

