/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common;

import com.day.cq.dam.api.s7dam.config.S7damConfig;
import com.day.cq.dam.api.s7dam.config.S7damConfigResolver;
import com.day.cq.dam.commons.util.S7SetHelper;
import com.day.cq.dam.s7dam.hosted.model.S7damAssetUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, label="%cq.dam.s7dam.damchangeeventlistener.name", description="%cq.dam.s7dam.damchangeeventlistener.description")
@Properties(value={@Property(name="cq.dam.s7dam.damchangeeventlistener.enabled", boolValue={true}, label="%cq.dam.s7dam.damchangeeventlistener.enabled.label", description="%cq.dam.s7dam.damchangeeventlistener.enabled.description")})
public class S7damDamChangeEventListener
implements EventListener {
    static final String SCR_PROP_NAME_ENABLED = "cq.dam.s7dam.damchangeeventlistener.enabled";
    static final boolean SCR_PROP_DEFAULT_ENABLED = true;
    private static final String TARGET_RENDITION_REMOVED = "TARGET_RENDITION_REMOVED";
    private static final String TARGET_RENDITION_UPDATED = "TARGET_RENDITION_UPDATED";
    private static final String PATH_PROP = "_path";
    private static final String TYPE_PROP = "_type";
    private static final Logger LOG = LoggerFactory.getLogger(S7damDamChangeEventListener.class);
    public static final String JOB_TOPIC = "com/day/cq/dam/s7dam/update/job";
    public static final String JOB_EVENT_TYPE = "s7dam.eventtype";
    public static final String JOB_SRC_PATH = "s7dam.srcpath";
    public static final String JOB_DST_PATH = "s7dam.dstpath";
    public static final String JOB_DELETE_ASSET = "s7dam.pv_deleteasset";
    public static final String JOB_MOVE_ASSET = "s7dam.pv_moveasset";
    public static final String JOB_MOVE_FOLDER = "s7dam.pv_movefolder";
    public static final String JOB_SET_ADDED = "s7dam.pv_addset";
    public static final String JOB_SET_MOVED = "s7dam.pv_moveset";
    public static final String JOB_SET_REMOVED = "s7dam.pv_removeset";
    public static final String JOB_SET_IMG_ADDED = "s7dam.pv_set_addimg";
    public static final String JOB_SET_IMG_REMOVED = "s7dam.pv_set_removeImage";
    public static final String JOB_SET_IMG_ORDERED = "s7dam.pv_set_orderchanged";
    public static final String JOB_UPDATE_OPTIMIZED_PTIFF = "s7dam.pv_updateoptimzedtiff";
    @Reference
    private EventAdmin eventAdmin;
    @Reference(policy=ReferencePolicy.STATIC)
    private ResourceResolverFactory resolverFactory;
    @Reference
    protected SlingSettingsService settingsService;
    @Reference
    private S7damConfigResolver s7configResolver;
    private ResourceResolver resolver;
    private ObservationManager observationManager;
    private String cqRunMode = "author";
    private String s7RunMode = "onprem";

    public void onEvent(EventIterator eventIterator) {
        S7damConfig s7config = this.s7configResolver.getS7damConfig(null);
        if (s7config == null || !s7config.isValid()) {
            return;
        }
        HashMap<String, ArrayList<String>> targetRenditionsModified = new HashMap<String, ArrayList<String>>();
        int setCount = -1;
        HashMap<String, Object> setProps = new HashMap<String, Object>();
        int setModifiedCount = -1;
        HashMap<String, Object> setModifiedProps = new HashMap<String, Object>();
        while (eventIterator.hasNext()) {
            try {
                Event event = eventIterator.nextEvent();
                String eventPath = event.getPath();
                int eventType = event.getType();
                LOG.trace("processing event with path [{}].", (Object)eventPath);
                PathInfo pathInfo = new PathInfo(event);
                String assetPath = pathInfo.getAssetPath();
                if (!this.acceptAssetPath(assetPath)) {
                    LOG.trace("ignoring asset path [{}].", (Object)assetPath);
                    continue;
                }
                if (eventPath.equals(assetPath)) {
                    if (32 == eventType && !this.isSet(assetPath, this.resolver)) {
                        this.processMove(assetPath, pathInfo, this.resolver);
                        LOG.trace("Process Node_Moved [{}] for asset [{}].", (Object)assetPath);
                        continue;
                    }
                    if (eventType == 2 || !this.isSet(assetPath, this.resolver)) continue;
                    if (setProps.get(assetPath) == null) {
                        setProps.put(assetPath, new Integer(++setCount));
                    } else {
                        setCount = (Integer)setProps.get(assetPath);
                    }
                    setProps.put(setCount + PATH_PROP, assetPath);
                    setProps.put(setCount + TYPE_PROP, eventType);
                    if (eventType != 32) continue;
                    setProps.put(setCount + "_old" + PATH_PROP, pathInfo.srcAbsPath);
                    setProps.put(pathInfo.srcAbsPath + "_process", false);
                    continue;
                }
                if (pathInfo.concernsTargetRendition(this.s7RunMode)) {
                    if (2 == eventType) {
                        this.addModified(pathInfo.assetPath, TARGET_RENDITION_REMOVED, targetRenditionsModified);
                        continue;
                    }
                    this.addModified(pathInfo.assetPath, TARGET_RENDITION_UPDATED, targetRenditionsModified);
                    continue;
                }
                if (!this.isSetMember(eventPath)) continue;
                if (setModifiedProps.get(assetPath) == null) {
                    setModifiedProps.put(assetPath, new Integer(++setModifiedCount));
                } else {
                    setModifiedCount = (Integer)setModifiedProps.get(assetPath);
                }
                if (eventType != 2 && this.isSet(assetPath, this.resolver)) {
                    setModifiedProps.put(setModifiedCount + PATH_PROP, assetPath);
                    setModifiedProps.put(setModifiedCount + TYPE_PROP, eventType);
                    continue;
                }
                if (eventType != 2) continue;
                setModifiedProps.put(setModifiedCount + PATH_PROP, assetPath);
                setModifiedProps.put(setModifiedCount + TYPE_PROP, eventType);
            }
            catch (RepositoryException e) {
                LOG.error("error processing event: ", (Throwable)e);
            }
        }
        if (targetRenditionsModified.size() > 0) {
            LOG.debug("collected [{}] asset update(s), sending events...", (Object)targetRenditionsModified.size());
            for (Map.Entry entry : targetRenditionsModified.entrySet()) {
                for (String entryType : (ArrayList)entry.getValue()) {
                    if (TARGET_RENDITION_REMOVED.equals(entryType)) {
                        this.processDeleteAsset((String)entry.getKey());
                    } else if (TARGET_RENDITION_UPDATED.equals(entryType)) {
                        this.processUpdatePublishedAsset((String)entry.getKey());
                    }
                    LOG.trace("Process operation [{}] for asset [{}].", (Object)entryType, entry.getKey());
                }
            }
        }
        try {
            this.processSetEvents(setProps, targetRenditionsModified, setCount);
            this.processSetModifiedEvents(setModifiedProps, setProps, setModifiedCount);
        }
        catch (Exception e) {
            LOG.error("Failed Processing ImageSet Events / ImageSet Modifier Events [{}]", (Object)e.getMessage());
        }
    }

    private void processSetModifiedEvents(Map<String, Object> setModifiedProps, Map<String, Object> setProps, int setModifiedCount) {
        for (int i = 0; i <= setModifiedCount; ++i) {
            String path = (String)setModifiedProps.get(i + PATH_PROP);
            if (setProps.containsKey(path)) continue;
            Hashtable<String, Object> eventProps = new Hashtable<String, Object>();
            ((Dictionary)eventProps).put("event.job.topic", JOB_TOPIC);
            switch ((Integer)setModifiedProps.get(i + TYPE_PROP)) {
                case 1: {
                    ((Dictionary)eventProps).put(JOB_EVENT_TYPE, JOB_SET_IMG_ADDED);
                    ((Dictionary)eventProps).put(JOB_SRC_PATH, path);
                    break;
                }
                case 2: {
                    ((Dictionary)eventProps).put(JOB_SRC_PATH, path);
                    ((Dictionary)eventProps).put(JOB_EVENT_TYPE, JOB_SET_IMG_REMOVED);
                    break;
                }
                case 32: {
                    ((Dictionary)eventProps).put(JOB_EVENT_TYPE, JOB_SET_IMG_ORDERED);
                    ((Dictionary)eventProps).put(JOB_SRC_PATH, path);
                }
            }
            this.postEvent(eventProps);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processSetEvents(Map<String, Object> setProps, Map<String, ?> removedRenditions, int setCount) {
        int i = 0;
        while (true) {
            block8: {
                if (i > setCount) {
                    return;
                }
                Hashtable<String, Object> eventProps = new Hashtable<String, Object>();
                ((Dictionary)eventProps).put("event.job.topic", JOB_TOPIC);
                String path = (String)setProps.get(i + PATH_PROP);
                switch ((Integer)setProps.get(i + TYPE_PROP)) {
                    case 1: {
                        ((Dictionary)eventProps).put(JOB_EVENT_TYPE, JOB_SET_ADDED);
                        ((Dictionary)eventProps).put(JOB_SRC_PATH, path);
                        break;
                    }
                    case 2: {
                        if (!(setProps.get(path + "_process") != null || removedRenditions.get(path) != null && ((List)removedRenditions.get(path)).contains(TARGET_RENDITION_REMOVED))) {
                            ((Dictionary)eventProps).put(JOB_SRC_PATH, path);
                            ((Dictionary)eventProps).put(JOB_EVENT_TYPE, JOB_SET_REMOVED);
                            break;
                        }
                        break block8;
                    }
                    case 32: {
                        ((Dictionary)eventProps).put(JOB_EVENT_TYPE, JOB_SET_MOVED);
                        ((Dictionary)eventProps).put(JOB_DST_PATH, path);
                        ((Dictionary)eventProps).put(JOB_SRC_PATH, setProps.get(i + "_old" + PATH_PROP));
                    }
                }
                this.postEvent(eventProps);
            }
            ++i;
        }
    }

    private void addModified(String assetPath, String operation, Map<String, ArrayList<String>> modified) {
        ArrayList<Object> events;
        if (modified.containsKey(assetPath)) {
            events = modified.get(assetPath);
        } else {
            events = new ArrayList();
            modified.put(assetPath, events);
        }
        events.add(operation);
    }

    private void processDeleteAsset(String assetPath) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("event.job.topic", JOB_TOPIC);
        ((Dictionary)props).put(JOB_EVENT_TYPE, JOB_DELETE_ASSET);
        ((Dictionary)props).put(JOB_SRC_PATH, assetPath);
        this.postEvent(props);
    }

    private void processUpdatePublishedAsset(String assetPath) {
        if (!"publish".equals(this.cqRunMode)) {
            LOG.debug("Attempting to update publish target [{}] in author mode", (Object)assetPath);
            return;
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("event.job.topic", JOB_TOPIC);
        ((Dictionary)props).put(JOB_EVENT_TYPE, JOB_UPDATE_OPTIMIZED_PTIFF);
        ((Dictionary)props).put(JOB_SRC_PATH, assetPath);
        this.postEvent(props);
    }

    private void processMove(String assetPath, PathInfo pathInfo, ResourceResolver resolver) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("event.job.topic", JOB_TOPIC);
        if (StringUtils.isEmpty((String)assetPath)) {
            LOG.warn("Unable to process Move - assetPath is empty");
            return;
        }
        if (StringUtils.isEmpty((String)pathInfo.getSrcAbsPath())) {
            LOG.warn("Unable to process Move - Src Path is empty");
            return;
        }
        if (StringUtils.isEmpty((String)pathInfo.getDstAbsPath())) {
            LOG.warn("Unable to process Move - Dst Path is empty");
            return;
        }
        ((Dictionary)props).put(JOB_SRC_PATH, pathInfo.getSrcAbsPath());
        ((Dictionary)props).put(JOB_DST_PATH, pathInfo.getDstAbsPath());
        if (this.isAsset(assetPath, resolver)) {
            ((Dictionary)props).put(JOB_EVENT_TYPE, JOB_MOVE_ASSET);
        } else if (this.isFolder(assetPath, resolver)) {
            ((Dictionary)props).put(JOB_EVENT_TYPE, JOB_MOVE_FOLDER);
        }
        this.postEvent(props);
    }

    private void postEvent(Dictionary<String, Object> props) {
        org.osgi.service.event.Event jobEvent = new org.osgi.service.event.Event("org/apache/sling/event/job", props);
        this.eventAdmin.sendEvent(jobEvent);
    }

    private boolean acceptAssetPath(String assetPath) {
        return !Text.getName((String)assetPath).startsWith("._");
    }

    @Activate
    private void activate(ComponentContext context) throws RepositoryException, LoginException {
        Boolean enabled = OsgiUtil.toBoolean(context.getProperties().get(SCR_PROP_NAME_ENABLED), (boolean)true);
        if (!enabled.booleanValue()) {
            return;
        }
        this.establishRunModes();
        this.resolver = this.resolverFactory.getAdministrativeResourceResolver(Collections.emptyMap());
        Session session = (Session)this.resolver.adaptTo(Session.class);
        this.observationManager = session.getWorkspace().getObservationManager();
        int eventTypes = 35;
        this.observationManager.addEventListener((EventListener)this, eventTypes, "/content/dam", true, null, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate(ComponentContext context) {
        try {
            if (this.observationManager != null) {
                this.observationManager.removeEventListener((EventListener)this);
            }
        }
        catch (RepositoryException re) {
            LOG.error("error removing the JCR event listener", (Throwable)re);
        }
        finally {
            if (this.resolver != null && this.resolver.isLive()) {
                this.resolver.close();
                this.resolver = null;
            }
        }
    }

    private void establishRunModes() {
        if (this.settingsService == null) {
            LOG.error("Unable to retrieve run modes runModes");
            return;
        }
        this.cqRunMode = this.settingsService.getRunModes().contains("publish") ? "publish" : "author";
        this.s7RunMode = this.settingsService.getRunModes().contains("onprem") ? "onprem" : "hosted";
        LOG.debug("RunMode set to [{}] - [{}]", (Object)this.cqRunMode, (Object)this.s7RunMode);
    }

    private boolean isAsset(String assetPath, ResourceResolver resolver) {
        try {
            Node node = (Node)resolver.getResource(assetPath).adaptTo(Node.class);
            return S7damAssetUtils.isAssetNode(node);
        }
        catch (Exception e) {
            LOG.warn("checking - isAsset [{}]", (Object)e.getMessage());
            return false;
        }
    }

    private boolean isSet(String assetPath, ResourceResolver resolver) {
        try {
            return S7SetHelper.isS7Set((Resource)resolver.getResource(assetPath));
        }
        catch (Exception e) {
            LOG.warn("checking - isSet [{}]", (Object)e.getMessage());
            return false;
        }
    }

    private boolean isFolder(String path, ResourceResolver resolver) {
        try {
            Node node = (Node)resolver.getResource(path).adaptTo(Node.class);
            return S7damAssetUtils.isFolderNode(node);
        }
        catch (Exception e) {
            LOG.warn("checking - isFolder [{}]", (Object)e.getMessage());
            return false;
        }
    }

    private boolean isSetMember(String path) {
        return path.indexOf("related/s7Set/sling:members/") != -1;
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindS7configResolver(S7damConfigResolver s7damConfigResolver) {
        this.s7configResolver = s7damConfigResolver;
    }

    protected void unbindS7configResolver(S7damConfigResolver s7damConfigResolver) {
        if (this.s7configResolver == s7damConfigResolver) {
            this.s7configResolver = null;
        }
    }

    private class PathInfo {
        private final String assetPath;
        private final String relativePath;
        private final String dstAbsPath;
        private final String srcAbsPath;
        private final boolean concernsPtiffRendition;
        private final boolean concernsOriginalRendition;

        public PathInfo(Event event) throws RepositoryException {
            String path = event.getPath();
            this.assetPath = StringUtils.substringBefore((String)path, (String)"/jcr:content");
            this.relativePath = path.length() > this.assetPath.length() ? path.substring(this.assetPath.length() + 1) : "";
            this.dstAbsPath = event.getType() == 32 ? (String)event.getInfo().get("destAbsPath") : "";
            this.srcAbsPath = event.getType() == 32 ? (String)event.getInfo().get("srcAbsPath") : "";
            this.concernsOriginalRendition = this.relativePath.startsWith("jcr:content/renditions/original") && !this.relativePath.endsWith("jcr:content");
            this.concernsPtiffRendition = this.relativePath.startsWith("jcr:content/renditions/Dynamic Media ptiff") && !this.relativePath.endsWith("jcr:content");
        }

        public boolean concernsTargetRendition(String runMode) {
            if ("onprem".equals(runMode)) {
                return this.concernsPtiffRendition;
            }
            return this.concernsOriginalRendition;
        }

        public String getAssetPath() {
            return this.assetPath;
        }

        public String getDstAbsPath() {
            return this.dstAbsPath;
        }

        public String getSrcAbsPath() {
            return this.srcAbsPath;
        }
    }
}

