/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.config;

import com.day.cq.dam.s7dam.common.config.S7damConfigService;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.commons.threads.ThreadPool;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, label="%cq.dam.s7dam.configurationeventlistener.name", description="%cq.dam.s7dam.configurationeventlistener.description")
@Properties(value={@Property(name="cq.dam.s7dam.configurationeventlistener.enabled", boolValue={true}, label="%cq.dam.s7dam.configurationeventlistener.enabled.label", description="%cq.dam.s7dam.configurationeventlistener.enabled.description")})
public class S7damConfigurationEventListener
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(S7damConfigurationEventListener.class);
    private static final String S7_CONFIG_PATH = "/etc/cloudservices/s7dam/*";
    private static final String S7_CONFIG_RESOURCE_TYPE = "dam/components/s7dam/s7damPage";
    private static final String[] TOPICS = new String[]{"org/apache/sling/api/resource/Resource/ADDED", "org/apache/sling/api/resource/Resource/CHANGED"};
    static final String SCR_PROP_NAME_ENABLED = "cq.dam.s7dam.configurationeventlistener.enabled";
    static final boolean SCR_PROP_DEFAULT_ENABLED = true;
    private ServiceRegistration eventHandlerRegistration;
    private ThreadPool threadPool;
    private ResourceResolver rr;
    private boolean enabled;
    @Reference
    private ThreadPoolManager threadPoolManager;
    @Reference
    private ResourceResolverFactory rrf;
    @Reference
    private S7damConfigService configService;

    public void handleEvent(Event event) {
        if (this.enabled && !this.isVersioningRelatedChangeEvent(event)) {
            this.processEvent(event);
        }
    }

    private boolean isVersioningRelatedChangeEvent(Event event) {
        String[] resourcesAdded = (String[])event.getProperty("resourceAddedAttributes");
        if (resourcesAdded != null) {
            for (String resource : resourcesAdded) {
                if (!"jcr:versionHistory".equals(resource)) continue;
                return true;
            }
        }
        return false;
    }

    private void processEvent(Event event) {
        String path = (String)event.getProperty("path");
        final Resource resource = this.rr.getResource(path);
        LOG.info("Processing s7dam event create / update Service confgi for " + path + " for target path");
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    S7damConfigurationEventListener.this.configService.initialize(resource, S7damConfigurationEventListener.this.rr);
                }
                catch (Throwable e) {
                    LOG.error(e.getMessage());
                }
            }
        };
        this.threadPool.execute(task);
    }

    protected void activate(ComponentContext componentContext) {
        this.enabled = OsgiUtil.toBoolean(componentContext.getProperties().get(SCR_PROP_NAME_ENABLED), (boolean)true);
        Hashtable<String, Object> listenEventsDictionary = new Hashtable<String, Object>();
        ((Dictionary)listenEventsDictionary).put("event.topics", TOPICS);
        String filter = "(&(path=/etc/cloudservices/s7dam/*))";
        ((Dictionary)listenEventsDictionary).put("event.filter", "(&(path=/etc/cloudservices/s7dam/*))");
        this.eventHandlerRegistration = componentContext.getBundleContext().registerService(EventHandler.class.getName(), (Object)this, listenEventsDictionary);
        LOG.info("Registered for OSGi events: topics={}, filter={}", (Object)TOPICS, (Object)"(&(path=/etc/cloudservices/s7dam/*))");
        this.threadPool = this.threadPoolManager.get("S7damConfigurationEventListener");
        try {
            this.rr = this.rrf.getAdministrativeResourceResolver(null);
        }
        catch (LoginException e) {
            LOG.error("Unable to retrieve a resource resolver", (Throwable)e);
        }
    }

    protected void deactivate() {
        if (this.eventHandlerRegistration != null) {
            this.eventHandlerRegistration.unregister();
            this.eventHandlerRegistration = null;
        }
        if (this.threadPool != null) {
            this.threadPoolManager.release(this.threadPool);
        }
        if (this.rr != null) {
            this.rr.close();
        }
    }

    protected void bindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        this.threadPoolManager = threadPoolManager;
    }

    protected void unbindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        if (this.threadPoolManager == threadPoolManager) {
            this.threadPoolManager = null;
        }
    }

    protected void bindRrf(ResourceResolverFactory resourceResolverFactory) {
        this.rrf = resourceResolverFactory;
    }

    protected void unbindRrf(ResourceResolverFactory resourceResolverFactory) {
        if (this.rrf == resourceResolverFactory) {
            this.rrf = null;
        }
    }

    protected void bindConfigService(S7damConfigService s7damConfigService) {
        this.configService = s7damConfigService;
    }

    protected void unbindConfigService(S7damConfigService s7damConfigService) {
        if (this.configService == s7damConfigService) {
            this.configService = null;
        }
    }
}

