/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.config.impl;

import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.s7dam.config.S7damConfig;
import com.day.cq.dam.api.s7dam.config.S7damConfigHosted;
import com.day.cq.dam.api.s7dam.config.S7damConfigOnPrem;
import com.day.cq.dam.api.s7dam.config.S7damConfigResolver;
import com.day.cq.dam.s7dam.common.config.impl.S7damConfigImpl;
import com.day.cq.dam.s7dam.hosted.config.impl.S7damConfigHostedImpl;
import com.day.cq.dam.s7dam.onprem.config.impl.S7damConfigOnPremImpl;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class S7damConfigResolverImpl
implements S7damConfigResolver {
    private static final Logger LOG = LoggerFactory.getLogger(S7damConfigResolverImpl.class);
    @Reference
    private ConfigurationManager cfgManager;
    @Reference
    private CryptoSupport cryptoSupport;
    @Reference
    protected SlingSettingsService settingsService;

    public S7damConfigHosted getS7damConfigHosted(String email, String password, String userRegion) {
        String encryptedPassword = password;
        S7damConfigHostedImpl s7Config = null;
        try {
            if (!this.cryptoSupport.isProtected(encryptedPassword)) {
                encryptedPassword = this.cryptoSupport.protect(encryptedPassword);
            }
            Iterator cfgIterator = this.cfgManager.getConfigurations("/etc/cloudservices/s7dam");
            while (cfgIterator.hasNext()) {
                Configuration configuration = (Configuration)cfgIterator.next();
                if (configuration == null) continue;
                InheritanceValueMap configProp = configuration.getProperties();
                String emailProp = (String)configProp.get("email", String.class);
                String passwordProp = (String)configProp.get("password", String.class);
                String regionProp = (String)configProp.get("region", String.class);
                if (emailProp == null || !emailProp.equals(email) || passwordProp == null || !passwordProp.equals(encryptedPassword) || regionProp == null || !regionProp.equals(userRegion)) continue;
                s7Config = new S7damConfigHostedImpl(configuration);
                break;
            }
            if (s7Config == null) {
                s7Config = new S7damConfigHostedImpl(email, encryptedPassword, userRegion);
            }
        }
        catch (InvalidObjectException e) {
            LOG.error("Error obtaining a valid S7damConfigHosted object", (Throwable)e);
        }
        catch (CryptoException e) {
            LOG.error("Error encrypting password", (Throwable)e);
        }
        return s7Config;
    }

    public S7damConfig getS7damConfig(String configPath) {
        S7damConfig s7Config = null;
        if (configPath != null) {
            Configuration cfg = this.cfgManager.getConfiguration(configPath);
            if (cfg == null) {
                return null;
            }
            try {
                String runMode = this.getRunMode();
                if (runMode.equals("hosted")) {
                    s7Config = new S7damConfigHostedImpl(cfg);
                } else if (runMode.equals("onprem")) {
                    s7Config = new S7damConfigOnPremImpl(cfg);
                } else if (runMode.equals("")) {
                    LOG.error("Could not create S7damConfig: The AEM run mode might have not been configured correctly for Dynamic Media.");
                    s7Config = null;
                }
                if (s7Config != null && !s7Config.isValid()) {
                    LOG.error("Could not create S7damConfig: the config set based on the runmode " + runMode + " for Dynamic Media is invalid.");
                    s7Config = null;
                }
            }
            catch (InvalidObjectException e) {
                LOG.error("Invalid S7damConfig object due to invalid constructor parameters", (Throwable)e);
            }
        } else {
            List<S7damConfig> s7Configs = this.getS7damConfigurations("/etc/cloudservices/s7dam");
            if (s7Configs.size() > 0) {
                s7Config = s7Configs.get(0);
            }
        }
        return s7Config;
    }

    public S7damConfigHosted getS7damConfigHosted(String configPath) {
        S7damConfigHosted s7Config;
        block8: {
            s7Config = null;
            if (configPath != null) {
                Configuration cfg = this.cfgManager.getConfiguration(configPath);
                if (cfg == null) {
                    return null;
                }
                try {
                    if (this.getRunMode().equals("hosted")) {
                        s7Config = new S7damConfigHostedImpl(cfg);
                        if (!s7Config.isValid()) {
                            LOG.error("Could not create S7damConfig");
                            s7Config = null;
                        }
                        break block8;
                    }
                    LOG.error("Could not create S7damConfig: The AEM run mode has not been configured correctly for Dynamic Media.");
                }
                catch (InvalidObjectException e) {
                    LOG.error("Invalid S7damConfig object due to invalid constructor parameters", (Throwable)e);
                }
            } else {
                List<S7damConfig> s7Configs = this.getS7damConfigurations("/etc/cloudservices/s7dam");
                if (s7Configs.size() > 0) {
                    s7Config = (S7damConfigHosted)s7Configs.get(0);
                }
            }
        }
        return s7Config;
    }

    public S7damConfigOnPrem getS7damConfigOnPrem(String configPath) {
        S7damConfigOnPrem s7Config;
        block8: {
            s7Config = null;
            if (configPath != null) {
                Configuration cfg = this.cfgManager.getConfiguration(configPath);
                if (cfg == null) {
                    return null;
                }
                try {
                    if (this.getRunMode().equals("onprem")) {
                        s7Config = new S7damConfigOnPremImpl(cfg);
                        if (!s7Config.isValid()) {
                            LOG.error("Could not create S7damConfig");
                            s7Config = null;
                        }
                        break block8;
                    }
                    LOG.error("Could not create S7damConfig: The AEM run mode has not been configured correctly for Dynamic Media.");
                }
                catch (InvalidObjectException e) {
                    LOG.error("Invalid S7damConfig object due to invalid constructor parameters", (Throwable)e);
                }
            } else {
                List<S7damConfig> s7Configs = this.getS7damConfigurations("/etc/cloudservices/s7dam");
                if (s7Configs.size() > 0) {
                    s7Config = (S7damConfigOnPrem)s7Configs.get(0);
                }
            }
        }
        return s7Config;
    }

    private List<S7damConfig> getS7damConfigurations(String configRootPath) {
        ArrayList<S7damConfig> s7Configurations = new ArrayList<S7damConfig>();
        if (StringUtils.isNotEmpty((String)configRootPath)) {
            Iterator cfgIterator = this.cfgManager.getConfigurations(configRootPath);
            while (cfgIterator.hasNext()) {
                Configuration cfg = (Configuration)cfgIterator.next();
                try {
                    S7damConfigImpl s7Config = null;
                    String runMode = this.getRunMode();
                    if (runMode.equals("hosted")) {
                        s7Config = new S7damConfigHostedImpl(cfg);
                    } else if (runMode.equals("onprem")) {
                        s7Config = new S7damConfigOnPremImpl(cfg);
                    } else if (runMode.equals("")) {
                        LOG.error("Could not create S7damConfig: The AEM run mode might have not been configured correctly for Dynamic Media.");
                        s7Config = null;
                    }
                    if (s7Config != null && !s7Config.isValid()) {
                        LOG.error("Could not create S7damConfig: the config set based on the runmode " + runMode + " for Dynamic Media is invalid.");
                        s7Config = null;
                    }
                    s7Configurations.add(s7Config);
                }
                catch (InvalidObjectException e) {
                    LOG.error("Invalid S7damConfig object due to invalid constructor parameters", (Throwable)e);
                }
            }
        }
        return s7Configurations;
    }

    private String getConfigFromMetaData(Resource resource) {
        Resource metaData;
        String s7damConfigurationPath = null;
        Asset asset = (Asset)resource.adaptTo(Asset.class);
        if (asset != null && (metaData = resource.getChild("jcr:content")) != null) {
            s7damConfigurationPath = (String)((ValueMap)metaData.adaptTo(ValueMap.class)).get("dam:s7damCloudConfigPath", String.class);
        }
        return s7damConfigurationPath;
    }

    public String getRunMode() {
        String runMode = "";
        for (String mode : this.settingsService.getRunModes()) {
            if (!mode.equals("hosted") && !mode.equals("onprem")) continue;
            runMode = mode;
            break;
        }
        return runMode;
    }

    protected void bindCfgManager(ConfigurationManager configurationManager) {
        this.cfgManager = configurationManager;
    }

    protected void unbindCfgManager(ConfigurationManager configurationManager) {
        if (this.cfgManager == configurationManager) {
            this.cfgManager = null;
        }
    }

    protected void bindCryptoSupport(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    protected void unbindCryptoSupport(CryptoSupport cryptoSupport) {
        if (this.cryptoSupport == cryptoSupport) {
            this.cryptoSupport = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }
}

