/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.model;

import com.day.cq.dam.s7dam.common.constants.S7damDefaultUploadOptionVals;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.JcrResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S7damFolderUploadOptions {
    private static final Logger LOG = LoggerFactory.getLogger(S7damFolderUploadOptions.class);
    private ResourceResolver resolver;

    public S7damFolderUploadOptions(ResourceResolver resolver) {
        this.resolver = resolver;
    }

    public Map<String, String> getUploadOptions(String nodePath) throws RepositoryException {
        String folderPath = nodePath;
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        if (!nodePath.endsWith("jcr:content/") || !nodePath.endsWith("jcr:content")) {
            folderPath = nodePath + "/jcr:content/";
        }
        Map<String, String> folderOptions = this.getFolderUploadOptions(folderPath);
        String defaultPath = "/etc/cloudservices/s7dam/defaultUploadOptions";
        Map<String, String> defaultOptions = this.getFolderUploadOptions(defaultPath);
        options.putAll(defaultOptions);
        options.putAll(folderOptions);
        LOG.info("UploadOptions for " + nodePath + "=" + ((Object)options).toString());
        return options;
    }

    public boolean isEqualTo(String dir1, String dir2) throws RepositoryException {
        Map<String, String> diff = this.getDifferences(dir1, dir2);
        boolean isDifferent = false;
        if (diff.size() > 0) {
            isDifferent = true;
        }
        return isDifferent;
    }

    public Map<String, String> getDifferences(String dir1, String dir2) throws RepositoryException {
        String key;
        HashMap<String, String> differences = new HashMap<String, String>();
        Map<String, String> opts1 = this.getUploadOptions(dir1);
        Map<String, String> opts2 = this.getUploadOptions(dir2);
        for (Map.Entry<String, String> entry : opts1.entrySet()) {
            key = entry.getKey();
            if (opts1.get(key).equals(opts2.get(key))) continue;
            differences.put(key, opts1.get(key));
        }
        for (Map.Entry<String, String> entry : opts2.entrySet()) {
            key = entry.getKey();
            if (opts2.get(key).equals(opts1.get(key))) continue;
            differences.put(key, opts2.get(key));
        }
        return differences;
    }

    private String getVideoEncodingPresetVal(Node folderNode) throws RepositoryException {
        String[] propVals;
        String videoEncodingPresets = "";
        Property propVideoPreset = folderNode.getProperty("videoEncodingPresets");
        for (String val : propVals = propVideoPreset.getString().split(",")) {
            Node presetNode = (Node)this.resolver.getResource("/etc/cloudservices/s7dam/presets/encoding/" + val).adaptTo(Node.class);
            if (presetNode == null) continue;
            PropertyIterator itr = presetNode.getProperties();
            while (itr.hasNext()) {
                Property obj = itr.nextProperty();
                String name = obj.getName();
                if (name == null || !"handle".equals(name)) continue;
                videoEncodingPresets = videoEncodingPresets + obj.getValue().getString() + ",";
            }
        }
        if (videoEncodingPresets.endsWith(",")) {
            videoEncodingPresets = videoEncodingPresets.substring(0, videoEncodingPresets.length() - 1);
        }
        return videoEncodingPresets;
    }

    public void createDefaultUploadOptionsNode() throws RepositoryException {
        Session session = (Session)this.resolver.adaptTo(Session.class);
        String path = "/etc/cloudservices/s7dam/defaultUploadOptions";
        Node optionsNode = JcrResourceUtil.createPath((String)path, (String)"nt:unstructured", (String)"nt:unstructured", (Session)session, (boolean)false);
        Map<String, String> defaultVals = S7damDefaultUploadOptionVals.getAll();
        for (String key : defaultVals.keySet()) {
            String val = defaultVals.get(key);
            if (optionsNode.hasProperty(key)) continue;
            optionsNode.setProperty(key, val);
        }
        session.save();
    }

    private Map<String, String> getFolderUploadOptions(String path) throws RepositoryException {
        Node jcrNode = (Node)this.resolver.getResource(path).adaptTo(Node.class);
        LinkedHashMap<String, String> nodeVals = new LinkedHashMap<String, String>();
        if (jcrNode != null) {
            PropertyIterator ptr = jcrNode.getProperties();
            while (ptr.hasNext()) {
                Property prop = (Property)ptr.next();
                String propName = prop.getName();
                String propVal = "";
                if (propName.startsWith("jcr:")) continue;
                propVal = propName.equals("videoEncodingPresets") ? this.getVideoEncodingPresetVal(jcrNode) : prop.getString();
                nodeVals.put(propName, propVal);
            }
        }
        return nodeVals;
    }
}

