/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.presets.impl;

import com.day.cq.dam.api.s7dam.config.S7damConfig;
import com.day.cq.dam.api.s7dam.config.S7damConfigHosted;
import com.day.cq.dam.api.s7dam.config.S7damConfigResolver;
import com.day.cq.dam.s7dam.common.model.S7damImagePreset;
import com.day.cq.dam.s7dam.common.presets.S7damGenericPresetService;
import com.day.cq.dam.s7dam.common.presets.S7damImagePresetsService;
import com.day.cq.dam.s7dam.common.protocol.Command;
import com.day.cq.dam.s7dam.hosted.ips.S7damAPIClient;
import com.day.cq.dam.s7dam.hosted.ips.S7damService;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.jcr.resource.JcrResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Component(metatype=false, label="%cq.dam.s7dam.imagepresetsservice.name", description="%cq.dam.s7dam.imagepresetsservice.description")
@Service
public class S7damImagePresetsServiceImpl
extends S7damGenericPresetService
implements S7damImagePresetsService {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    @Reference
    private S7damConfigResolver s7configResolver;
    @Reference
    private S7damService s7damService;
    @Reference
    private S7damAPIClient s7damApiClient;

    @Override
    public boolean presetsExist(Resource configResource) {
        return configResource.getChild("presets/image") != null;
    }

    @Override
    public Iterator<Resource> getImagePresets(Resource configResource) {
        return this.getPresets(configResource, "presets/image");
    }

    @Override
    public boolean updateImagePresets(Resource configResource) {
        try {
            S7damConfig s7Config = this.s7configResolver.getS7damConfig(null);
            if (s7Config.isHosted()) {
                this.updateImagePresets(configResource, (S7damConfigHosted)s7Config);
                Session session = (Session)configResource.getResourceResolver().adaptTo(Session.class);
                session.save();
            }
            return true;
        }
        catch (RepositoryException e) {
            this.LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private void updateImagePresets(Resource configResource, S7damConfigHosted s7Config) throws RepositoryException {
        List<S7damImagePreset> presets = this.s7damService.getImagePresets(s7Config);
        if (presets.size() > 0) {
            String path = configResource.getPath() + "/" + "presets/image";
            Node node = this.prepNode(configResource.getResourceResolver(), path);
            for (S7damImagePreset preset : presets) {
                Node presetNode = node.addNode(preset.getName());
                presetNode.setProperty("handle", preset.getHandle());
                presetNode.setProperty("config", s7Config.getCloudConfigPath() + "/" + preset.getName());
                Command settings = preset.getSettings();
                List<Command> children = settings.getChildren();
                presetNode = presetNode.addNode("settings");
                for (Command nv : children) {
                    presetNode.setProperty(nv.getName(), nv.getValue());
                }
            }
        }
    }

    @Override
    public boolean createImagePreset(Resource configResource, S7damImagePreset preset) {
        S7damConfig s7Config = this.s7configResolver.getS7damConfig(null);
        String newHandle = "";
        if (s7Config.isHosted()) {
            Document document = this.s7damApiClient.saveImagePreset(preset, (S7damConfigHosted)s7Config);
            if (document != null) {
                NodeList elementList = document.getElementsByTagName("imageFormatHandle");
                if (elementList.getLength() > 0) {
                    Element element = (Element)elementList.item(0);
                    newHandle = element.getTextContent();
                }
                if (newHandle != "") {
                    return this.savePresetDefinitionLocally(configResource, preset, newHandle);
                }
            }
        } else {
            return this.savePresetDefinitionLocally(configResource, preset, null);
        }
        return false;
    }

    private boolean savePresetDefinitionLocally(Resource configResource, S7damImagePreset preset, String newHandle) {
        try {
            Session session = (Session)configResource.getResourceResolver().adaptTo(Session.class);
            String path = configResource.getPath() + "/" + "presets/image";
            if (!session.nodeExists(path)) {
                Node targetNode = JcrResourceUtil.createPath((String)path, (String)"nt:unstructured", (String)"nt:unstructured", (Session)session, (boolean)false);
            }
            Node root = session.getNode(path);
            Node presetNode = root.addNode(preset.getName());
            presetNode.setProperty("config", path + "/" + preset.getName());
            if (newHandle != null) {
                presetNode.setProperty("handle", newHandle);
            }
            Command settings = preset.getSettings();
            List<Command> children = settings.getChildren();
            presetNode = presetNode.addNode("settings");
            for (Command nv : children) {
                if (nv.getValue() == null) continue;
                String name = nv.getName().toString();
                String value = nv.getValue().toString();
                presetNode.setProperty(nv.getName(), nv.getValue());
            }
            presetNode.setProperty("extramodifiers", preset.getOverrideModifiers());
            session.save();
        }
        catch (RepositoryException e) {
            this.LOG.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    @Override
    public boolean updateImagePreset(Resource configResource, S7damImagePreset preset, String existingName) {
        try {
            String path = configResource.getPath() + "/" + "presets/image";
            Session session = (Session)configResource.getResourceResolver().adaptTo(Session.class);
            Node root = session.getNode(path);
            Node currentNode = root.getNode(existingName);
            if (currentNode != null) {
                currentNode.setProperty("config", path + "/" + preset.getName());
                Command settings = preset.getSettings();
                List<Command> children = settings.getChildren();
                Node existingSettingsNode = currentNode.getNode("settings");
                existingSettingsNode.remove();
                Node presetNode = currentNode.addNode("settings");
                for (Command nv : children) {
                    presetNode.setProperty(nv.getName(), nv.getValue());
                }
                presetNode.setProperty("extramodifiers", preset.getOverrideModifiers());
                currentNode.getSession().move(currentNode.getPath(), currentNode.getParent().getPath() + "/" + preset.getName());
                session.save();
                return true;
            }
        }
        catch (RepositoryException e) {
            this.LOG.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean deleteImagePreset(Resource configResource, String existingName) {
        try {
            S7damConfig s7Config = this.s7configResolver.getS7damConfig(null);
            String path = configResource.getPath() + "/" + "presets/image";
            Session session = (Session)configResource.getResourceResolver().adaptTo(Session.class);
            Node root = session.getNode(path);
            Node currentNode = root.getNode(existingName);
            if (currentNode != null) {
                if (s7Config.isHosted()) {
                    this.s7damApiClient.deleteImagePreset(currentNode.getProperty("handle").getValue().toString(), (S7damConfigHosted)s7Config);
                }
                currentNode.remove();
                session.save();
            }
        }
        catch (RepositoryException e) {
            this.LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    protected void bindS7configResolver(S7damConfigResolver s7damConfigResolver) {
        this.s7configResolver = s7damConfigResolver;
    }

    protected void unbindS7configResolver(S7damConfigResolver s7damConfigResolver) {
        if (this.s7configResolver == s7damConfigResolver) {
            this.s7configResolver = null;
        }
    }

    protected void bindS7damService(S7damService s7damService) {
        this.s7damService = s7damService;
    }

    protected void unbindS7damService(S7damService s7damService) {
        if (this.s7damService == s7damService) {
            this.s7damService = null;
        }
    }

    protected void bindS7damApiClient(S7damAPIClient s7damAPIClient) {
        this.s7damApiClient = s7damAPIClient;
    }

    protected void unbindS7damApiClient(S7damAPIClient s7damAPIClient) {
        if (this.s7damApiClient == s7damAPIClient) {
            this.s7damApiClient = null;
        }
    }
}

