/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.s7dam.config.S7damConfig;
import com.day.cq.dam.api.s7dam.config.S7damConfigResolver;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.workflow.PayloadMap;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.metadata.MetaDataMap;
import com.day.cq.workflow.model.WorkflowModel;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Property(name="process.label", value={"S7Dam Update Dam Content"})
public class S7damUpdateProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger LOG = LoggerFactory.getLogger(S7damUpdateProcess.class);
    @Reference(policy=ReferencePolicy.STATIC)
    private PayloadMap payloadMap;
    @Reference
    private S7damConfigResolver ccResolver;

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData) throws WorkflowException {
        try {
            Asset asset = this.getAssetFromPayload(workItem, workflowSession.getSession());
            ResourceResolver rr = this.getResourceResolver(workflowSession.getSession());
            if (asset == null) {
                LOG.warn("Failed to publish, no asset in payload");
                return;
            }
            Session session = workflowSession.getSession();
            Node node = (Node)rr.getResource(asset.getPath()).adaptTo(Node.class);
            this.launchSubWorkflow(node, workflowSession);
            if (session.hasPendingChanges()) {
                session.save();
            }
        }
        catch (RepositoryException e) {
            LOG.error("execute: error while syncing structure; work item [{}]: ", (Object)workItem.getId(), (Object)e);
        }
    }

    private void launchSubWorkflow(Node node, WorkflowSession wfSession) throws RepositoryException {
        S7damConfig cc = this.ccResolver.getS7damConfig(null);
        if (cc == null || !cc.isValid()) {
            return;
        }
        String wfModelId = null;
        wfModelId = cc.getAssetUpdateWorkflowId();
        if (!this.isAlreadyInSameWorkflow(node, wfModelId)) {
            this.startWorkflow(node.getPath(), cc.getCloudConfigPath(), wfModelId, wfSession);
            LOG.debug("sync: asset for [{}] does not exist, syncing with destination [{}]...", (Object)this.safeGetPath(node), (Object)node.getPath());
        } else {
            LOG.warn("Already in workflow skipping s7dam publish for [{}].", (Object)node.getPath());
        }
    }

    private boolean isAlreadyInSameWorkflow(Node node, String wfModelId) throws RepositoryException {
        if (this.payloadMap.isInWorkflow(node.getPath(), true)) {
            List wfs = this.payloadMap.getWorkflowInstances(node.getPath(), true);
            for (Workflow wf : wfs) {
                if (!wf.getWorkflowModel().getId().equals(wfModelId)) continue;
                return true;
            }
        }
        return false;
    }

    private void startWorkflow(String assetPath, String cloudConfigPath, String workflowId, WorkflowSession wfSession) {
        try {
            if (assetPath == null || cloudConfigPath == null) {
                LOG.error("startWorkflow failed payload or Cloud configuration is undefined");
                return;
            }
            HashMap<String, String> metaData = new HashMap<String, String>();
            metaData.put("dam:s7damCloudConfigPath", cloudConfigPath);
            WorkflowModel model = wfSession.getModel(workflowId);
            WorkflowData wfData = wfSession.newWorkflowData("JCR_PATH", (Object)assetPath);
            wfSession.startWorkflow(model, wfData, metaData);
        }
        catch (Exception e) {
            LOG.warn("startWorkflow: cannot start workflow for [{}]: ", (Object)assetPath, (Object)e);
        }
    }

    protected void bindPayloadMap(PayloadMap payloadMap) {
        this.payloadMap = payloadMap;
    }

    protected void unbindPayloadMap(PayloadMap payloadMap) {
        if (this.payloadMap == payloadMap) {
            this.payloadMap = null;
        }
    }

    protected void bindCcResolver(S7damConfigResolver s7damConfigResolver) {
        this.ccResolver = s7damConfigResolver;
    }

    protected void unbindCcResolver(S7damConfigResolver s7damConfigResolver) {
        if (this.ccResolver == s7damConfigResolver) {
            this.ccResolver = null;
        }
    }
}

