/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.protocol.impl;

import com.day.cq.dam.s7dam.common.protocol.BooleanCommand;
import com.day.cq.dam.s7dam.common.protocol.ParamUtils;
import com.day.cq.dam.s7dam.common.protocol.impl.ParamableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanCommandImpl
extends ParamableImpl
implements BooleanCommand {
    private static final Logger log = LoggerFactory.getLogger(BooleanCommandImpl.class);
    private boolean boolValue = false;
    private boolean defaultValue = false;
    private BooleanCommand.BooleanFormat format;

    public BooleanCommandImpl(String name, String value, boolean defaultValue, BooleanCommand.BooleanFormat format) {
        super(name, value);
        this.defaultValue = defaultValue;
        this.format = format;
        if (!ParamUtils.isParamRef(value)) {
            this.setValue(value != null ? value : BooleanCommandImpl.getStringValue(defaultValue, format));
        }
    }

    @Override
    public String getValue() {
        return BooleanCommandImpl.getStringValue(this.boolValue, this.format);
    }

    @Override
    public String getCheckedValue() {
        if (this.boolValue == this.defaultValue) {
            return null;
        }
        return this.getValue();
    }

    @Override
    public void setValue(String value) {
        if (value != null && value.length() > 0) {
            if ((value = value.toLowerCase()).equalsIgnoreCase("true") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("1")) {
                this.setBooleanValue(true);
            } else if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("off") || value.equalsIgnoreCase("no") || value.equalsIgnoreCase("0")) {
                this.setBooleanValue(false);
            } else {
                String msg = "BooleanCommand.setValue, Illegal value: " + value;
                log.warn(msg);
                throw new IllegalArgumentException(msg);
            }
        }
    }

    @Override
    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean getBooleanValue() {
        return this.boolValue;
    }

    @Override
    public void setBooleanValue(boolean value) {
        this.boolValue = value;
        this.valueChanged();
    }

    @Override
    public BooleanCommand.BooleanFormat getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(BooleanCommand.BooleanFormat format) {
        this.format = format;
        this.valueChanged();
    }

    private static String getStringValue(boolean value, BooleanCommand.BooleanFormat format) {
        if (format == BooleanCommand.BooleanFormat.TRUE_FALSE_FORMAT) {
            return value ? "true" : "false";
        }
        if (format == BooleanCommand.BooleanFormat.ON_OFF_FORMAT) {
            return value ? "on" : "off";
        }
        if (format == BooleanCommand.BooleanFormat.YES_NO_FORMAT) {
            return value ? "yes" : "no";
        }
        if (format == BooleanCommand.BooleanFormat.ONE_ZERO_FORMAT) {
            return value ? "1" : "0";
        }
        return value ? "true" : "false";
    }
}

