/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.protocol.impl;

import com.day.cq.dam.s7dam.common.protocol.ColorCommand;
import com.day.cq.dam.s7dam.common.protocol.ParamUtils;
import com.day.cq.dam.s7dam.common.protocol.impl.ParamableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorCommandImpl
extends ParamableImpl
implements ColorCommand {
    private static final Logger log = LoggerFactory.getLogger(ColorCommandImpl.class);
    private int red;
    private int green;
    private int blue;
    private String defaultValue;

    public ColorCommandImpl(String name, String value, String defaultValue) {
        super(name, value);
        this.defaultValue = defaultValue;
        if (!ParamUtils.isParamRef(value)) {
            this.setValue(value != null ? value : defaultValue);
        }
    }

    @Override
    public String getColorValue(ColorCommand.ColorFormat format) {
        if (format == ColorCommand.ColorFormat.HEX) {
            String redStr = Integer.toHexString(this.red);
            String greenStr = Integer.toHexString(this.green);
            String blueStr = Integer.toHexString(this.blue);
            if (redStr.length() == 1) {
                redStr = "0" + redStr;
            }
            if (greenStr.length() == 1) {
                greenStr = "0" + greenStr;
            }
            if (blueStr.length() == 1) {
                blueStr = "0" + blueStr;
            }
            return redStr + greenStr + blueStr;
        }
        return Integer.toString(this.red) + "," + Integer.toString(this.green) + "," + Integer.toString(this.blue);
    }

    @Override
    public String getValue() {
        return this.getColorValue(ColorCommand.ColorFormat.HEX);
    }

    @Override
    public void setValue(String value) {
        if (value != null && value.length() > 0) {
            String[] arr = value.split(",");
            String msg = "ColorCommandImpl, Invalid color: " + value;
            if (arr.length == 1) {
                int blueVal;
                int greenVal;
                int redVal;
                if (value.startsWith("0x")) {
                    value = value.substring(2);
                }
                if (value.length() > 6) {
                    log.warn(msg);
                    throw new IllegalArgumentException(msg);
                }
                while (value.length() < 6) {
                    value = "0" + value;
                }
                try {
                    redVal = Integer.parseInt("0x" + value.charAt(0) + value.charAt(1), 16);
                    greenVal = Integer.parseInt("0x" + value.charAt(2) + value.charAt(3), 16);
                    blueVal = Integer.parseInt("0x" + value.charAt(4) + value.charAt(5), 16);
                }
                catch (Exception e) {
                    log.warn(msg);
                    throw new IllegalArgumentException(msg);
                }
                this.setRed(redVal);
                this.setGreen(greenVal);
                this.setBlue(blueVal);
            } else if (arr.length == 3 || arr.length == 4) {
                int blueVal;
                int greenVal;
                int redVal;
                try {
                    redVal = Integer.parseInt(arr[0]);
                    greenVal = Integer.parseInt(arr[1]);
                    blueVal = Integer.parseInt(arr[2]);
                }
                catch (Exception e) {
                    log.warn(msg);
                    throw new IllegalArgumentException(msg);
                }
                this.setRed(redVal);
                this.setGreen(greenVal);
                this.setBlue(blueVal);
            } else {
                log.warn(msg);
                throw new IllegalArgumentException(msg);
            }
        }
    }

    @Override
    public String getCheckedValue() {
        String value = this.getValue();
        if (this.defaultValue.equalsIgnoreCase(value)) {
            return null;
        }
        return value;
    }

    @Override
    public int getRed() {
        return this.red;
    }

    @Override
    public void setRed(int value) {
        if (value < 0 || value > 255) {
            String msg = "ColorCommandImpl, Invalid red value: " + value;
            log.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        this.red = value;
        this.valueChanged();
    }

    @Override
    public int getGreen() {
        return this.green;
    }

    @Override
    public void setGreen(int value) {
        if (value < 0 || value > 255) {
            String msg = "ColorCommandImpl, Invalid green value: " + value;
            log.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        this.green = value;
        this.valueChanged();
    }

    @Override
    public int getBlue() {
        return this.blue;
    }

    @Override
    public void setBlue(int value) {
        if (value < 0 || value > 255) {
            String msg = "ColorCommandImpl, Invalid green value: " + value;
            log.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        this.blue = value;
        this.valueChanged();
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }
}

