/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.protocol.impl;

import com.day.cq.dam.s7dam.common.protocol.Command;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.util.Text;

public class CommandImpl
implements Command {
    private String name = null;
    private String value = null;
    private Command parent = null;
    private boolean enabled = true;
    private List<Command> children = new ArrayList<Command>();

    public CommandImpl(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public CommandImpl(String name) {
        this(name, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String val) {
        this.name = val;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String val) {
        this.value = val;
    }

    @Override
    public String getCheckedValue() {
        return this.getValue();
    }

    @Override
    public Command getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Command parent) {
        this.parent = parent;
    }

    @Override
    public Command getRoot() {
        Command root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean val) {
        this.enabled = val;
    }

    @Override
    public void add(Command command) {
        this.addAt(command, this.children.size());
    }

    @Override
    public void addAt(Command command, int idx) {
        this.children.add(idx < 0 ? 0 : (idx > this.children.size() ? this.children.size() : idx), command);
        command.setParent(this);
    }

    @Override
    public Command remove(String name, String value) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.get(i).getName().equals(name) || value != null && !this.children.get(i).getValue().equals(value)) continue;
            Command ret = this.children.get(i);
            this.children.remove(i);
            ret.setParent(null);
            return ret;
        }
        return null;
    }

    @Override
    public Command remove(String name) {
        return this.remove(name, null);
    }

    @Override
    public void removeAll() {
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).setParent(null);
        }
        this.children = new ArrayList<Command>();
    }

    @Override
    public Command get(String name, String value) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.get(i).getName().equals(name) || value != null && !this.children.get(i).getValue().equals(value)) continue;
            return this.children.get(i);
        }
        return null;
    }

    @Override
    public Command get(String name) {
        return this.get(name, null);
    }

    @Override
    public List<Command> getAll(String name, String value, boolean includeDisabled) {
        ArrayList<Command> ret = new ArrayList<Command>();
        for (int i = 0; i < this.children.size(); ++i) {
            if (name != null && !name.equals(this.children.get(i).getName()) || value != null && !value.equals(this.children.get(i).getValue()) || !includeDisabled && !this.children.get(i).isEnabled()) continue;
            ret.add(this.children.get(i));
        }
        return ret;
    }

    @Override
    public void search(List<Command> arr, String name, String value, boolean includeDisabled) {
        if ((name == null || name.equals(this.getName())) && (value == null || value.equals(this.getValue())) && (includeDisabled || this.isEnabled())) {
            arr.add(this);
        }
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).search(arr, name, value, includeDisabled);
        }
    }

    @Override
    public void search(List<Command> arr) {
        this.search(arr, null, null, true);
    }

    @Override
    public String thisString(boolean checked, boolean encode) {
        String locValue;
        String string = locValue = checked ? this.getCheckedValue() : this.getValue();
        if (this.getName() != null && this.getName().length() > 0 && locValue != null) {
            String locName = this.getName();
            if (encode && locName != null) {
                locName = Text.escape((String)locName);
            }
            if (encode && locValue != null) {
                locValue = Text.escape((String)locValue);
            }
            return "&" + locName + "=" + locValue;
        }
        return "";
    }

    @Override
    public String childString(boolean checked, boolean encode) {
        String childStr = "";
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.get(i).isEnabled()) continue;
            childStr = childStr + this.children.get(i).thisString(checked, encode) + this.children.get(i).childString(checked, encode);
        }
        return childStr;
    }

    @Override
    public String toString(boolean checked, boolean encode) {
        String ret = this.thisString(checked, encode) + this.childString(checked, encode);
        if (ret.length() > 0 && ret.charAt(0) == '&') {
            return ret.substring(1);
        }
        return ret;
    }

    @Override
    public String toString() {
        return this.toString(true, false);
    }

    @Override
    public List<Command> getChildren() {
        return this.children;
    }
}

