/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.protocol.impl;

import com.day.cq.dam.s7dam.common.protocol.EnumCommand;
import com.day.cq.dam.s7dam.common.protocol.ParamUtils;
import com.day.cq.dam.s7dam.common.protocol.impl.StringCommandImpl;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumCommandImpl
extends StringCommandImpl
implements EnumCommand {
    private static final Logger log = LoggerFactory.getLogger(EnumCommandImpl.class);
    private List<String> enums;

    public EnumCommandImpl(String name, String value, String defaultValue, List<String> enums) {
        super(name, value, defaultValue);
        this.enums = enums;
        if (value != null && !ParamUtils.isParamRef(value)) {
            this.setValue(value);
        }
    }

    @Override
    public void setValue(String value) {
        if (!this.enums.contains(value)) {
            String msg = "EnumCommandImpl, invalid value: " + value;
            log.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        super.setValue(value);
    }

    @Override
    public int getNumEnums() {
        return this.enums.size();
    }
}

