/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.protocol.impl;

import com.day.cq.dam.s7dam.common.protocol.FloatCommand;
import com.day.cq.dam.s7dam.common.protocol.ParamUtils;
import com.day.cq.dam.s7dam.common.protocol.impl.ParamableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FloatCommandImpl
extends ParamableImpl
implements FloatCommand {
    private static final Logger log = LoggerFactory.getLogger(FloatCommandImpl.class);
    private static final float TOL = 1.0E-6f;
    private float floatValue = 0.0f;
    private float defaultValue = 0.0f;
    private float minValue = Float.MIN_VALUE;
    private float maxValue = Float.MAX_VALUE;

    public FloatCommandImpl(String name, String value, float defaultValue, float minValue, float maxValue) {
        super(name, value);
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        if (!ParamUtils.isParamRef(value)) {
            this.setValue(value != null ? value : Float.toString(defaultValue));
        }
    }

    @Override
    public String getValue() {
        return Float.toString(this.floatValue);
    }

    @Override
    public void setValue(String value) {
        if (value != null && value.length() > 0) {
            float floatVal;
            try {
                floatVal = Float.parseFloat(value);
            }
            catch (Exception e) {
                String msg = "FloatCommandImpl, Invalid float modifier: " + value;
                log.warn(msg);
                throw new IllegalArgumentException(msg);
            }
            this.setFloatValue(floatVal);
        }
    }

    @Override
    public String getCheckedValue() {
        if (Math.abs(this.floatValue - this.defaultValue) < 1.0E-6f) {
            return null;
        }
        return this.getValue();
    }

    @Override
    public float getFloatValue() {
        return this.floatValue;
    }

    @Override
    public void setFloatValue(float value) {
        if (value < this.minValue - 1.0E-6f) {
            String msg = "FloatCommandImpl, value too small: " + value;
            log.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (value > this.maxValue + 1.0E-6f) {
            String msg = "FloatCommandImpl, value too large: " + value;
            log.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        this.floatValue = value;
        this.valueChanged();
    }

    @Override
    public float getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public float getMinValue() {
        return this.minValue;
    }

    @Override
    public float getMaxValue() {
        return this.maxValue;
    }
}

