/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.protocol.impl;

import com.day.cq.dam.s7dam.common.protocol.IntCommand;
import com.day.cq.dam.s7dam.common.protocol.ParamUtils;
import com.day.cq.dam.s7dam.common.protocol.impl.ParamableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntCommandImpl
extends ParamableImpl
implements IntCommand {
    private static final Logger log = LoggerFactory.getLogger(IntCommandImpl.class);
    private int intValue = 0;
    private int defaultValue = 0;
    private int minValue = Integer.MIN_VALUE;
    private int maxValue = Integer.MAX_VALUE;

    public IntCommandImpl(String name, String value, int defaultValue, int minValue, int maxValue) {
        super(name, value);
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        if (!ParamUtils.isParamRef(value)) {
            this.setValue(value != null ? value : Integer.toString(defaultValue));
        }
    }

    @Override
    public String getValue() {
        return Integer.toString(this.intValue);
    }

    @Override
    public void setValue(String value) {
        if (value != null && value.length() > 0) {
            int intVal;
            try {
                intVal = Integer.parseInt(value);
            }
            catch (Exception e) {
                String msg = "IntCommandImpl, Invalid int modifier: " + value;
                log.warn(msg);
                throw new IllegalArgumentException(msg);
            }
            this.setIntValue(intVal);
        }
    }

    @Override
    public String getCheckedValue() {
        if (this.intValue == this.defaultValue) {
            return null;
        }
        return this.getValue();
    }

    @Override
    public int getIntValue() {
        return this.intValue;
    }

    @Override
    public void setIntValue(int value) {
        if (value < this.minValue) {
            String msg = "IntCommandImpl, value too small: " + value;
            log.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (value > this.maxValue) {
            String msg = "IntCommandImpl, value too large: " + value;
            log.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        this.intValue = value;
        this.valueChanged();
    }

    @Override
    public int getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public int getMinValue() {
        return this.minValue;
    }

    @Override
    public int getMaxValue() {
        return this.maxValue;
    }
}

