/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.protocol.impl;

import com.day.cq.dam.s7dam.common.protocol.Command;
import com.day.cq.dam.s7dam.common.protocol.ListCommand;
import com.day.cq.dam.s7dam.common.protocol.ListDescriptor;
import com.day.cq.dam.s7dam.common.protocol.ParamUtils;
import com.day.cq.dam.s7dam.common.protocol.impl.AssetRefCommandImpl;
import com.day.cq.dam.s7dam.common.protocol.impl.BooleanCommandImpl;
import com.day.cq.dam.s7dam.common.protocol.impl.ColorCommandImpl;
import com.day.cq.dam.s7dam.common.protocol.impl.EnumCommandImpl;
import com.day.cq.dam.s7dam.common.protocol.impl.FloatCommandImpl;
import com.day.cq.dam.s7dam.common.protocol.impl.IntCommandImpl;
import com.day.cq.dam.s7dam.common.protocol.impl.ParamableImpl;
import com.day.cq.dam.s7dam.common.protocol.impl.StringCommandImpl;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListCommandImpl
extends ParamableImpl
implements ListCommand {
    private static final Logger log = LoggerFactory.getLogger(ListCommandImpl.class);
    private List<Command> cmds = new ArrayList<Command>();
    private List<ListDescriptor> descArray;
    private boolean bounded = false;

    public ListCommandImpl(String name, String value, List<ListDescriptor> descArray) {
        super(name, value);
        this.descArray = descArray;
        boolean bl = this.bounded = descArray.size() > 1;
        if (!ParamUtils.isParamRef(value)) {
            this.setValue(value);
        }
    }

    @Override
    public String getValue() {
        String ret = "";
        String potential = "";
        boolean potentialUsed = false;
        for (int i = 0; i < this.cmds.size(); ++i) {
            Command cmd = this.cmds.get(i);
            String modValue = cmd.getValue();
            if (this.descArray.get(i).isRequired() || potentialUsed) {
                ret = ret + (modValue != null ? modValue : "") + ",";
                continue;
            }
            potential = potential + (modValue != null ? modValue : "") + ",";
            if (cmd.getCheckedValue() == null) continue;
            ret = ret + potential;
            potentialUsed = true;
        }
        if (ret.length() > 0) {
            return ret.substring(0, ret.length() - 1);
        }
        return "";
    }

    @Override
    public String getCheckedValue() {
        int i;
        for (i = 0; i < this.cmds.size() && this.cmds.get(i).getCheckedValue() == null; ++i) {
        }
        if (i == this.cmds.size()) {
            return null;
        }
        return this.getValue();
    }

    @Override
    public void setValue(String value) {
        this.cmds = new ArrayList<Command>();
        if (value != null && value.length() > 0) {
            int i;
            String[] arr = value.split(",");
            for (i = 0; i < arr.length; ++i) {
                this.cmds.add(this.modFactory(arr[i], this.bounded ? this.descArray.get(i) : this.descArray.get(0), i));
            }
            if (this.bounded && i < this.descArray.size()) {
                while (i < this.descArray.size()) {
                    ListDescriptor desc = this.descArray.get(i);
                    if (desc.isRequired()) {
                        String msg = "ListCommandImpl, setValue: required argument not supplied: " + value;
                        log.warn(msg);
                        throw new IllegalArgumentException(msg);
                    }
                    this.cmds.add(this.modFactory(null, desc, i));
                    ++i;
                }
            }
        } else if (this.bounded) {
            for (int i = 0; i < this.descArray.size(); ++i) {
                this.cmds.add(this.modFactory(this.descArray.get(i).getDefaultValue().toString(), this.descArray.get(i), i));
            }
        }
        this.valueChanged();
    }

    @Override
    public void addItem(String value) {
        if (this.bounded) {
            String msg = "ListCommandImpl, cannot add item to a bounded list";
            log.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        this.cmds.add(this.modFactory(value, this.descArray.get(0), this.cmds.size()));
    }

    @Override
    public Command removeItemAt(int idx) {
        return this.cmds.remove(idx);
    }

    @Override
    public Command getItemAt(int idx) {
        return this.cmds.get(idx);
    }

    @Override
    public List<Command> getItems() {
        return this.cmds;
    }

    @Override
    public int numItems() {
        return this.cmds.size();
    }

    @Override
    public ListDescriptor.ItemType getItemTypeAt(int idx) {
        return this.descArray.get(idx).getType();
    }

    @Override
    public ListDescriptor getDescriptorAt(int idx) {
        return this.descArray.get(idx);
    }

    @Override
    public String getItemValueAt(int idx) {
        return this.cmds.get(idx).getValue();
    }

    @Override
    public void setItemValueAt(int idx, String value) {
        this.cmds.get(idx).setValue(value);
        this.valueChanged();
    }

    @Override
    public boolean isBounded() {
        return this.bounded;
    }

    private Command modFactory(String value, ListDescriptor desc, int idx) {
        String name = "mod" + idx;
        switch (desc.getType()) {
            case INT_TYPE: {
                return new IntCommandImpl(name, value, (Integer)desc.getDefaultValue(), (Integer)desc.getMinValue(), (Integer)desc.getMaxValue());
            }
            case FLOAT_TYPE: {
                return new FloatCommandImpl(name, value, ((Float)desc.getDefaultValue()).floatValue(), ((Float)desc.getMinValue()).floatValue(), ((Float)desc.getMaxValue()).floatValue());
            }
            case ENUM_TYPE: {
                return new EnumCommandImpl(name, value, desc.getDefaultValue().toString(), desc.getEnums());
            }
            case STRING_TYPE: {
                return new StringCommandImpl(name, value, desc.getDefaultValue().toString());
            }
            case COLOR_TYPE: {
                return new ColorCommandImpl(name, value, desc.getDefaultValue().toString());
            }
            case ASSET_TYPE: {
                return new AssetRefCommandImpl(name, value, desc.getDefaultValue().toString(), true);
            }
            case BOOLEAN_TYPE: {
                return new BooleanCommandImpl(name, value, (Boolean)desc.getDefaultValue(), desc.getBooleanFormat());
            }
        }
        String msg = "ListCommandImpl, unknown data type: " + (Object)((Object)desc.getType());
        log.warn(msg);
        throw new IllegalArgumentException(msg);
    }
}

