/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.protocol.impl;

import com.day.cq.dam.s7dam.common.protocol.Command;
import com.day.cq.dam.s7dam.common.protocol.ParamCommand;
import com.day.cq.dam.s7dam.common.protocol.ParamUtils;
import com.day.cq.dam.s7dam.common.protocol.Paramable;
import com.day.cq.dam.s7dam.common.protocol.impl.CommandImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamCommandImpl
extends CommandImpl
implements ParamCommand {
    private static final Logger log = LoggerFactory.getLogger(ParamCommandImpl.class);
    private List<Paramable> refs = new ArrayList<Paramable>();
    private boolean lock = false;
    private String staticType = null;

    public ParamCommandImpl(String name, String value) {
        super(name, value);
    }

    @Override
    public void setParent(Command parent) {
        super.setParent(parent);
        String newValue = this.getValue();
        if (newValue != null) {
            try {
                newValue = URLDecoder.decode(newValue, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
            this.setValue(newValue);
        }
    }

    @Override
    public void setName(String val) {
        if (val.equals(super.getName())) {
            return;
        }
        List<Command> arr = ParamUtils.getParameters(this.getRoot());
        for (int i = 0; i < arr.size(); ++i) {
            if (!val.equals(arr.get(i).getName())) continue;
            log.debug("Duplicate parameter name: " + val);
            return;
        }
        super.setName(val);
    }

    @Override
    public String getValue() {
        return this.getRef() != null ? this.getRef().getDefaultParameterValue() : super.getValue();
    }

    @Override
    public String thisString(boolean checked, boolean encode) {
        if (super.thisString(checked, encode).length() == 0) {
            return "";
        }
        String locValue = this.getValue();
        if (encode && locValue != null) {
            locValue = Text.escape((String)locValue);
        }
        return "&" + this.getName() + "=" + locValue;
    }

    @Override
    public String getType() {
        return this.getRef() != null ? this.getRef().getName() : this.staticType;
    }

    @Override
    public String getDisplayName() {
        return this.getName().substring(1);
    }

    private Paramable getRef() {
        return this.refs.size() > 0 ? this.refs.get(0) : null;
    }

    @Override
    public void addRef(Paramable inRef) {
        for (int i = 0; i < this.refs.size(); ++i) {
            if (this.refs.get(i) != inRef) continue;
            return;
        }
        this.refs.add(inRef);
        if (this.getParent() == null) {
            inRef.getRoot().addAt(this, 0);
        }
    }

    @Override
    public void removeRef(Command inRef) {
        int idx = this.refs.indexOf(inRef);
        if (idx == -1) {
            return;
        }
        this.refs.remove(idx);
        if (this.refs.size() == 0) {
            this.getParent().remove(this.getName());
        }
    }

    @Override
    public void updateRefs(String newValue, Command caller) {
        if (this.lock) {
            return;
        }
        this.lock = true;
        for (int i = 0; i < this.refs.size(); ++i) {
            if (caller != null && caller == this.refs.get(i)) continue;
            this.refs.get(i).setValue(newValue);
        }
        this.lock = false;
    }

    @Override
    public List<Paramable> getRefs() {
        return this.refs;
    }

    @Override
    public void clearRefs() {
        this.staticType = this.getType();
        this.refs = new ArrayList<Paramable>();
    }

    private void dumpRefs() {
        if (this.refs.size() == 0) {
            log.debug("No refs left");
            return;
        }
        log.debug("Param refs: ");
        for (int i = 0; i < this.refs.size(); ++i) {
            log.debug(this.refs.get(i).toString());
        }
    }

    public static boolean validateName(String name) {
        return name.matches("[^a-zA-Z0-9-_.]");
    }
}

