/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.protocol.impl;

import com.day.cq.dam.s7dam.common.protocol.Command;
import com.day.cq.dam.s7dam.common.protocol.ParamCommand;
import com.day.cq.dam.s7dam.common.protocol.ParamUtils;
import com.day.cq.dam.s7dam.common.protocol.Paramable;
import com.day.cq.dam.s7dam.common.protocol.impl.CommandImpl;
import java.util.List;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamableImpl
extends CommandImpl
implements Paramable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ParamCommand paramCmd;

    public ParamableImpl(String name, String value) {
        super(name, value);
    }

    @Override
    public void setParent(Command parent) {
        super.setParent(parent);
        if (parent == null) {
            this.setParamCmd(null);
        } else if (ParamUtils.isParamRef(super.getValue())) {
            this.parameterize(super.getValue());
        }
    }

    @Override
    public void setValue(String inValue) {
        super.setValue(inValue);
        this.valueChanged();
    }

    @Override
    public String thisString(boolean checked, boolean encode) {
        if (this.isVariable()) {
            String locName = this.getName();
            if (encode && locName != null) {
                locName = Text.escape((String)locName);
            }
            String locValue = this.getParameterizedValue();
            if (encode && locValue != null) {
                locValue = Text.escape((String)locValue);
            }
            return "&" + locName + "=" + locValue;
        }
        return super.thisString(checked, encode);
    }

    @Override
    public ParamCommand getParamCmd() {
        return this.paramCmd;
    }

    @Override
    public void setParamCmd(ParamCommand cmd) {
        if (this.paramCmd == cmd) {
            return;
        }
        this.paramCmd = cmd;
        if (this.paramCmd != null) {
            this.paramCmd.addRef(this);
        }
    }

    @Override
    public boolean isVariable() {
        return this.paramCmd != null;
    }

    @Override
    public String getDefaultParameterValue() {
        return this.getValue();
    }

    @Override
    public String makeParamName() {
        String paramName = "";
        Command locCmd = this.getParent();
        while (locCmd.getParent() != null) {
            paramName = locCmd.getName() + "_" + locCmd.getValue() + "_" + paramName;
            locCmd = locCmd.getParent();
        }
        paramName = "$" + paramName + this.getName();
        return paramName;
    }

    protected void parameterize(String paramRef) {
        List<String> refs = ParamUtils.getParamRefs(paramRef);
        for (int i = 0; i < refs.size(); ++i) {
            String paramName = refs.get(i);
            ParamCommand locParamCmd = (ParamCommand)this.getRoot().get(paramName.substring(0, paramName.length() - 1));
            if (locParamCmd != null) {
                this.setValue(locParamCmd.getValue());
                this.setParamCmd(locParamCmd);
                continue;
            }
            this.log.warn("Could not locate parameter for " + this.getName() + ": " + paramRef);
        }
    }

    protected String getParameterizedValue() {
        return this.paramCmd.getName() + "$";
    }

    protected void valueChanged() {
        if (this.isVariable() && this.getParent() != null) {
            this.paramCmd.updateRefs(this.getValue(), this);
        }
    }
}

