/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.protocol.is;

import com.day.cq.dam.s7dam.common.protocol.Command;
import com.day.cq.dam.s7dam.common.protocol.impl.CommandImpl;
import com.day.cq.dam.s7dam.common.protocol.is.ISProtocolFactory;
import java.net.URLDecoder;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISProtocolParser {
    private static final Logger log = LoggerFactory.getLogger(ISProtocolParser.class);

    public static Command parse(String parseStr, boolean validate) {
        if (parseStr == null || parseStr.length() == 0) {
            return null;
        }
        try {
            Command ret;
            parseStr = URLDecoder.decode(parseStr, "utf-8");
            String[] prefixArr = new String[]{"=is{", "}", "=is(", ")", "=ir{", "}", "=ir(", ")"};
            String prefix = null;
            String matchStr = null;
            int idx1 = -1;
            int idx2 = -1;
            for (int cnt = 0; cnt < prefixArr.length; cnt += 2) {
                idx1 = 0;
                prefix = prefixArr[cnt];
                matchStr = prefixArr[cnt + 1];
                while ((idx1 = parseStr.indexOf(prefix, idx1)) != -1) {
                    idx2 = parseStr.indexOf(matchStr, idx1);
                    if (idx2 != -1) {
                        parseStr = parseStr.substring(0, idx1) + prefix + Text.escape((String)parseStr.substring(idx1 + prefix.length(), idx2)) + parseStr.substring(idx2);
                    }
                    ++idx1;
                }
            }
            String[] arr = parseStr.split("&");
            String name = null;
            String value = null;
            Command currNode = ret = ISProtocolFactory.make("root", null);
            Command currLayer = null;
            Command subLayer = null;
            int idx = -1;
            for (int i = 0; i < arr.length; ++i) {
                idx = arr[i].indexOf("=");
                if (idx != -1) {
                    name = URLDecoder.decode(arr[i].substring(0, idx), "utf-8");
                    value = URLDecoder.decode(arr[i].substring(idx + 1), "utf-8");
                } else {
                    name = URLDecoder.decode(arr[i], "utf-8");
                    value = "";
                }
                try {
                    if (name.equals("layer") || name.equals(".sl") || name.equals("effect")) {
                        subLayer = ISProtocolFactory.make(name, value);
                        if (name.equals("layer") || name.equals(".sl")) {
                            ret.add(subLayer);
                            currLayer = subLayer;
                        } else if (currLayer != null) {
                            currLayer.add(subLayer);
                        } else {
                            ret.add(subLayer);
                        }
                        currNode = subLayer;
                        continue;
                    }
                    if (name.charAt(0) == '$') {
                        ret.add(ISProtocolFactory.make(name, value));
                        continue;
                    }
                    currNode.add(ISProtocolFactory.make(name, value));
                    continue;
                }
                catch (Exception e) {
                    if (validate) {
                        throw new Exception(name + "=" + value);
                    }
                    currNode.remove(name);
                    currNode.add(new CommandImpl(name, value));
                    ret.remove("parseerror");
                    ret.add(ISProtocolFactory.make("parseerror", null));
                }
            }
            return ret;
        }
        catch (Exception e) {
            log.error("ISProtocolParserImpl, Unable to parse input string: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

