/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.service.impl;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.s7dam.S7damDAMService;
import com.day.cq.dam.api.s7dam.config.S7damConfig;
import com.day.cq.dam.api.s7dam.config.S7damConfigHosted;
import com.day.cq.dam.api.s7dam.config.S7damConfigResolver;
import com.day.cq.dam.s7dam.common.utils.RequestUtils;
import com.day.cq.dam.s7dam.hosted.constants.S7damAssetType;
import java.net.URISyntaxException;
import org.apache.commons.io.FilenameUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class S7damDAMServiceImpl
implements S7damDAMService {
    private static final Logger LOG = LoggerFactory.getLogger(S7damDAMServiceImpl.class);
    private static final String VIDEO_FOLDER = "e2/";
    private static final String IMAGE_SERVING_FOLDER = "is/image/";
    @Reference
    private S7damConfigResolver s7damConfigResolver;

    public String getS7FileReference(Asset asset, boolean isPreview) {
        String fileReference = null;
        if (asset != null) {
            Resource assetResource = (Resource)asset.adaptTo(Resource.class);
            Resource metadataResource = assetResource.getChild("jcr:content");
            ValueMap metadata = (ValueMap)metadataResource.adaptTo(ValueMap.class);
            S7damConfig s7damConfig = this.s7damConfigResolver.getS7damConfig(null);
            String imageServingRoot = null;
            String flashTemplateServer = null;
            String basePath = null;
            imageServingRoot = isPreview ? s7damConfig.getPreviewImageServer() : s7damConfig.getProductionImageServer();
            if (imageServingRoot == null) {
                imageServingRoot = "";
            }
            imageServingRoot = imageServingRoot.replace(IMAGE_SERVING_FOLDER, "");
            if (s7damConfig.isHosted()) {
                S7damConfigHosted s7damConfigHosted = (S7damConfigHosted)s7damConfig;
                basePath = s7damConfigHosted.getBasePath();
                flashTemplateServer = s7damConfigHosted.getFlashTemplatesServer();
            } else {
                basePath = s7damConfig.getCompanyName() + "/";
                flashTemplateServer = "";
            }
            String assetType = (String)metadata.get("dam:s7damType", String.class);
            if (s7damConfig != null && assetType != null) {
                String originalPath = (String)metadata.get("dam:s7damOriginalPath", String.class);
                String originalFile = (String)metadata.get("dam:s7damOriginalFile", String.class);
                String assetName = ResourceUtil.getName((String)asset.getPath());
                try {
                    StringBuilder frSB = new StringBuilder();
                    if (S7damAssetType.VIDEO.getValue().equals(assetType) || S7damAssetType.MASTER_VIDEO.getValue().equals(assetType)) {
                        String scene7File = (String)metadata.get("dam:s7damFile", (Object)"");
                        String extension = FilenameUtils.getExtension((String)originalFile);
                        scene7File = scene7File + "." + extension;
                        frSB.append(imageServingRoot).append(VIDEO_FOLDER);
                        fileReference = RequestUtils.buildURL(frSB.toString(), scene7File, null);
                    } else if (S7damAssetType.FLASH.getValue().equals(assetType)) {
                        frSB.append(flashTemplateServer);
                        fileReference = RequestUtils.buildURL(frSB.toString(), originalPath + originalFile, null);
                    } else {
                        frSB.append(imageServingRoot).append(IMAGE_SERVING_FOLDER).append(basePath);
                        fileReference = RequestUtils.buildURL(frSB.toString(), FilenameUtils.removeExtension((String)assetName), null);
                    }
                }
                catch (URISyntaxException e) {
                    LOG.error("Unable to obtain Scene7 file reference for " + asset.getPath(), (Throwable)e);
                }
            }
        }
        return fileReference;
    }

    protected void bindS7damConfigResolver(S7damConfigResolver s7damConfigResolver) {
        this.s7damConfigResolver = s7damConfigResolver;
    }

    protected void unbindS7damConfigResolver(S7damConfigResolver s7damConfigResolver) {
        if (this.s7damConfigResolver == s7damConfigResolver) {
            this.s7damConfigResolver = null;
        }
    }
}

