/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.servlets;

import com.day.cq.commons.TidyJSONWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.util.TraversingItemVisitor;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"sling/servlet/default"}, methods={"GET"}, selectors={"children"}, extensions={"json"})
public class S7damChildServlet
extends SlingAllMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String PROPS = "props";
    private String exceptionMsg;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        int level;
        boolean tidy;
        block8: {
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            String[] selectors = request.getRequestPathInfo().getSelectors();
            ArrayList<String> selectorList = selectors != null ? new ArrayList<String>(Arrays.asList(selectors)) : null;
            tidy = false;
            level = 1;
            if (selectorList != null && selectorList.size() > 0) {
                tidy = selectorList.contains("tidy");
                String levelStr = selectorList.get(selectorList.size() - 1);
                try {
                    level = Integer.parseInt(levelStr);
                    if (level <= 0) {
                        level = -1;
                    }
                }
                catch (Exception e) {
                    if (!levelStr.equalsIgnoreCase("infinity")) break block8;
                    level = -1;
                }
            }
        }
        final TidyJSONWriter out = new TidyJSONWriter((Writer)response.getWriter());
        out.setTidy(tidy);
        String propsParam = request.getParameter(PROPS);
        String[] props = propsParam != null && propsParam.length() > 0 ? propsParam.split(",") : null;
        final ArrayList<String> propList = props != null ? new ArrayList<String>(Arrays.asList(props)) : null;
        try {
            int levelLimit;
            out.array();
            Resource res = request.getResource();
            Node rootNode = res != null ? (Node)res.adaptTo(Node.class) : null;
            final S7damChildServlet self = this;
            int n = levelLimit = level > 0 ? level + 1 : level;
            if (rootNode != null) {
                TraversingItemVisitor.Default visitor = new TraversingItemVisitor.Default(false, levelLimit){
                    int objCnt;
                    {
                        super(x0, x1);
                        this.objCnt = 0;
                    }

                    protected void entering(Node node, int level) throws RepositoryException {
                        if (level == 0) {
                            return;
                        }
                        if (level == levelLimit) {
                            return;
                        }
                        try {
                            if (this.objCnt > 0) {
                                out.key(node.getName());
                            }
                            ++this.objCnt;
                            out.object();
                            out.key("id").value((Object)node.getName());
                            out.key("uri").value((Object)node.getPath());
                        }
                        catch (Exception e) {
                            self.saveException(e, (Item)node);
                        }
                    }

                    protected void entering(Property prop, int level) {
                        try {
                            if (level == 1) {
                                return;
                            }
                            if (propList != null && propList.size() > 0 && !propList.contains(prop.getName())) {
                                return;
                            }
                            try {
                                Object valObj = S7damChildServlet.this.getValue(prop.getValue());
                                out.key(prop.getName()).value(valObj);
                            }
                            catch (ValueFormatException e) {
                                Value[] currValues = prop.getValues();
                                JSONArray jarr = new JSONArray();
                                for (int i = 0; i < currValues.length; ++i) {
                                    jarr.put(S7damChildServlet.this.getValue(currValues[i]));
                                }
                                out.key(prop.getName()).value((Object)jarr);
                            }
                        }
                        catch (Exception e) {
                            self.saveException(e, (Item)prop);
                        }
                    }

                    protected void leaving(Node node, int level) {
                        if (level == 0) {
                            return;
                        }
                        if (level == levelLimit) {
                            return;
                        }
                        try {
                            --this.objCnt;
                            out.endObject();
                        }
                        catch (Exception e) {
                            self.saveException(e, (Item)node);
                        }
                    }
                };
                visitor.visit(rootNode);
                if (this.exceptionMsg != null) {
                    this.processException(response, this.exceptionMsg);
                }
            }
            out.endArray();
        }
        catch (Exception e) {
            this.processException(response, e.getMessage());
        }
    }

    public void saveException(Exception e, Item i) {
        if (this.exceptionMsg == null) {
            try {
                this.exceptionMsg = i.getName() + ": " + e.getMessage();
            }
            catch (Exception e2) {
                this.exceptionMsg = e.getMessage();
            }
        }
    }

    private void processException(SlingHttpServletResponse response, String message) throws IOException {
        this.log.error(message);
        response.sendError(500);
    }

    private Object getValue(Value val) throws RepositoryException {
        switch (val.getType()) {
            case 2: {
                return val.getBinary().getSize();
            }
            case 6: {
                return val.getBoolean();
            }
            case 12: {
                return Float.valueOf(val.getDecimal().floatValue());
            }
            case 4: {
                return val.getDouble();
            }
            case 3: {
                return val.getLong();
            }
        }
        return val.getString();
    }
}

