/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.servlets;

import com.day.cq.dam.s7dam.common.presets.S7damImagePresetsService;
import com.day.cq.dam.s7dam.common.presets.impl.S7damImagePresetImpl;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"dam/components/s7dam/s7damPage"}, methods={"POST"}, selectors={"imagepreset.create", "imagepreset.update", "imagepreset.delete"})
public class S7damImagePresetServlet
extends SlingAllMethodsServlet {
    @Reference
    private S7damImagePresetsService presetsService;
    private static final Logger LOG = LoggerFactory.getLogger(S7damImagePresetServlet.class);

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        boolean isCreate = false;
        boolean isUpdate = false;
        boolean isDelete = false;
        String selector = request.getRequestPathInfo().getSelectorString();
        if (StringUtils.isNotBlank((String)selector)) {
            isCreate = selector.equals("imagepreset.create");
            isUpdate = selector.equals("imagepreset.update");
            isDelete = selector.equals("imagepreset.delete");
        }
        Resource configResource = request.getResource().getParent();
        boolean ok = true;
        if (isDelete) {
            ok = this.presetsService.deleteImagePreset(configResource, request.getRequestParameter("oldName").getString());
        } else {
            String modifier = request.getRequestParameter("modifier").getString();
            String extramodifiers = request.getRequestParameter("extramodifiers").getString();
            S7damImagePresetImpl newPreset = new S7damImagePresetImpl(request.getRequestParameter("name").getString(), null, modifier, extramodifiers);
            if (isCreate) {
                ok = this.presetsService.createImagePreset(configResource, newPreset);
            } else if (isUpdate) {
                ok = this.presetsService.updateImagePreset(configResource, newPreset, request.getRequestParameter("oldName").getString());
            }
        }
        if (ok) {
            out.write("\n\nPreset created or updated");
        } else {
            response.setStatus(500);
            LOG.error("Failed to create or update preset");
        }
    }

    protected void bindPresetsService(S7damImagePresetsService s7damImagePresetsService) {
        this.presetsService = s7damImagePresetsService;
    }

    protected void unbindPresetsService(S7damImagePresetsService s7damImagePresetsService) {
        if (this.presetsService == s7damImagePresetsService) {
            this.presetsService = null;
        }
    }
}

