/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.servlets;

import com.day.cq.commons.TidyJSONWriter;
import com.day.cq.dam.api.s7dam.config.S7damConfig;
import com.day.cq.dam.api.s7dam.config.S7damConfigResolver;
import com.day.cq.dam.s7dam.common.jobs.S7damJobsService;
import com.day.cq.dam.s7dam.hosted.constants.S7damJobType;
import com.day.cq.dam.s7dam.hosted.jobs.model.S7damGetJobSettings;
import com.day.cq.dam.s7dam.hosted.jobs.model.S7damJob;
import com.day.cq.dam.s7dam.hosted.jobs.model.S7damJobSettings;
import com.day.cq.dam.s7dam.hosted.jobs.model.S7damSubmitExportJobSettings;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"dam/components/s7dam/s7damPage"}, extensions={"json"}, methods={"GET", "POST"}, selectors={"jobs.historical", "jobs.scheduled", "jobs.active", "jobs.details", "jobs.submit"})
public class S7damJobsServlet
extends SlingAllMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(S7damJobsServlet.class);
    @Reference
    private S7damConfigResolver s7configResolver;
    @Reference
    private S7damJobsService jobsSvc;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        S7damConfig s7Config = this.s7configResolver.getS7damConfig(null);
        String svcType = null;
        try {
            if (s7Config != null) {
                String[] selectors = request.getRequestPathInfo().getSelectors();
                ArrayList<String> selectorList = new ArrayList<String>(Arrays.asList(selectors));
                svcType = selectors[1];
                TidyJSONWriter tout = new TidyJSONWriter((Writer)response.getWriter());
                boolean tidy = false;
                tidy = selectorList.contains("tidy");
                tout.setTidy(tidy);
                S7damJobSettings jobSettings = null;
                jobSettings = this.setJobSettings(request, S7damJobType.JOB_GET);
                Resource configResource = request.getResource();
                List<S7damJob> jobs = this.jobsSvc.getJobs(svcType, jobSettings, configResource, s7Config);
                if (jobs != null) {
                    tout.array();
                    for (int i = 0; i < jobs.size(); ++i) {
                        tout.object();
                        for (Map.Entry<Object, Object> entry : jobs.get(i).getJobProperties().entrySet()) {
                            tout.key(entry.getKey().toString()).value(entry.getValue());
                        }
                        tout.endObject();
                    }
                    tout.endArray();
                }
            }
        }
        catch (Exception e) {
            LOG.error("get Jobs (" + svcType + "), failed to get s7dam jobs" + e.getMessage());
        }
    }

    private S7damJobSettings setJobSettings(SlingHttpServletRequest req, S7damJobType jobType) {
        S7damJobSettings jobSettings = null;
        switch (jobType) {
            case EXPORT_JOB: {
                S7damSubmitExportJobSettings exportJobSettings = new S7damSubmitExportJobSettings();
                exportJobSettings.setJobName(req.getParameter(S7damJobType.JOB_JOBNAME.getValue()) + new Date().toString());
                exportJobSettings.setEmailTo(req.getParameter(S7damJobType.JOB_EXPORT_EMAILTO.getValue()));
                exportJobSettings.setExecTime(req.getParameter(S7damJobType.JOB_EXECTIME.getValue()));
                exportJobSettings.setExecSchedule(req.getParameter(S7damJobType.JOB_EXECSCHEDULE.getValue()));
                exportJobSettings.setFmt(req.getParameter(S7damJobType.JOB_EXPORT_FMT.getValue()));
                exportJobSettings.setMacro(req.getParameter(S7damJobType.JOB_EXPORT_MACRO.getValue()));
                exportJobSettings.setISModifier(req.getParameter(S7damJobType.JOB_EXPORT_ISMODIFIER.getValue()));
                exportJobSettings.setEmailSetting(req.getParameter(S7damJobType.SUBMIT_JOB_EMAILSETTING.getValue()));
                String[] assethandles = req.getParameter(S7damJobType.JOB_EXPORT_ASSETHANDLEARRAY.getValue()).split(",");
                exportJobSettings.setAssetHandles(assethandles);
                jobSettings = exportJobSettings;
                break;
            }
            case JOB_GET: {
                S7damGetJobSettings getJobSettings = new S7damGetJobSettings();
                getJobSettings.setEndDate(req.getParameter(S7damJobType.JOB_GET_ENDDATE.getValue()));
                getJobSettings.setJobHandle(req.getParameter(S7damJobType.JOB_JOBHANDLE.getValue()));
                getJobSettings.setNumrows(req.getParameter(S7damJobType.JOB_GET_NUMROWS.getValue()));
                getJobSettings.setOrigName(req.getParameter(S7damJobType.JOB_ORIGNAME.getValue()));
                getJobSettings.setOwner(req.getParameter(S7damJobType.JOB_GET_OWNER.getValue()));
                getJobSettings.setSortBy(req.getParameter(S7damJobType.JOB_GET_SORTBY.getValue()));
                getJobSettings.setSortDirection(req.getParameter(S7damJobType.JOB_GET_SORTDIRECTION.getValue()));
                getJobSettings.setStartDate(req.getParameter(S7damJobType.JOB_GET_STARTDATE.getValue()));
                getJobSettings.setType(req.getParameter(S7damJobType.JOB_GET_TYPE.getValue()));
                jobSettings = getJobSettings;
            }
        }
        return jobSettings;
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        S7damConfig s7Config = this.s7configResolver.getS7damConfig(null);
        String svcType = null;
        try {
            if (s7Config != null) {
                String[] selectors = request.getRequestPathInfo().getSelectors();
                ArrayList<String> selectorList = new ArrayList<String>(Arrays.asList(selectors));
                svcType = selectors[1];
                TidyJSONWriter tout = new TidyJSONWriter((Writer)response.getWriter());
                boolean tidy = false;
                tidy = selectorList.contains("tidy");
                tout.setTidy(tidy);
                S7damJobSettings jobSettings = null;
                if (svcType.equals("submit")) {
                    S7damJob job = null;
                    if (request.getParameter(S7damJobType.JOB_GET_TYPE.getValue()).equals(S7damJobType.EXPORT_JOB.getValue())) {
                        jobSettings = this.setJobSettings(request, S7damJobType.EXPORT_JOB);
                        Resource configResource = request.getResource();
                        job = this.jobsSvc.submitJob(S7damJobType.EXPORT_JOB.getValue(), jobSettings, configResource, s7Config);
                    }
                    tout.object();
                    for (Map.Entry<Object, Object> entry : job.getJobProperties().entrySet()) {
                        tout.key(entry.getKey().toString()).value(entry.getValue());
                    }
                    tout.endObject();
                }
            }
        }
        catch (Exception e) {
            LOG.error("get Jobs (" + svcType + "), failed to get s7dam jobs" + e.getMessage());
        }
    }

    protected void bindS7configResolver(S7damConfigResolver s7damConfigResolver) {
        this.s7configResolver = s7damConfigResolver;
    }

    protected void unbindS7configResolver(S7damConfigResolver s7damConfigResolver) {
        if (this.s7configResolver == s7damConfigResolver) {
            this.s7configResolver = null;
        }
    }

    protected void bindJobsSvc(S7damJobsService s7damJobsService) {
        this.jobsSvc = s7damJobsService;
    }

    protected void unbindJobsSvc(S7damJobsService s7damJobsService) {
        if (this.jobsSvc == s7damJobsService) {
            this.jobsSvc = null;
        }
    }
}

