/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.set.impl;

import com.adobe.granite.asset.api.Asset;
import com.day.cq.dam.api.s7dam.set.ImageSet;
import com.day.cq.dam.api.s7dam.set.SwatchSet;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.dam.commons.util.S7SetHelper;
import com.day.cq.dam.s7dam.common.set.impl.SwatchSetImpl;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Property(name="service.description", value={"Scene7 Set Adapter Factory"})
public class SetAdapterFactory
implements AdapterFactory {
    private static final Logger log = LoggerFactory.getLogger(SetAdapterFactory.class);
    private static final Class<ImageSet> IMG_SET_CLASS = ImageSet.class;
    private static final Class<SwatchSet> SW_SET_CLASS = SwatchSet.class;
    @Property(name="adapters")
    public static final String[] ADAPTER_CLASSES = new String[]{IMG_SET_CLASS.getName(), SW_SET_CLASS.getName()};
    @Property(name="adaptables")
    public static final String[] ADAPTABLE_CLASSES = new String[]{Resource.class.getName()};

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (adaptable instanceof Resource) {
            return this.getAdapter((Resource)adaptable, type);
        }
        log.warn("Unable to handle adaptable {}", (Object)adaptable.getClass().getName());
        return null;
    }

    private <AdapterType> AdapterType getAdapter(Resource resource, Class<AdapterType> type) {
        if (resource != null) {
            Asset graniteAsset;
            if ((type == IMG_SET_CLASS || type == SW_SET_CLASS) && DamUtil.isAsset((Resource)resource) && (graniteAsset = (Asset)resource.adaptTo(Asset.class)) != null && S7SetHelper.isS7Set((Resource)resource)) {
                return (AdapterType)((Object)new SwatchSetImpl(graniteAsset));
            }
            log.debug("Unable to adapt resource of {} to type {}", (Object)resource.getResourceType(), (Object)type.getName());
            return null;
        }
        log.debug("Unable to adapt null resource to type {}", (Object)type.getName());
        return null;
    }
}

