/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.set.impl;

import com.adobe.granite.asset.api.AssetException;
import com.adobe.granite.asset.api.AssetRelation;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.s7dam.set.SwatchSet;
import com.day.cq.dam.s7dam.common.utils.DamUtils;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwatchSetImpl
extends ResourceWrapper
implements SwatchSet {
    private Resource contentResource;
    private com.adobe.granite.asset.api.Asset graniteAsset;
    private final ResourceResolver resolver;
    private static final Logger log = LoggerFactory.getLogger(SwatchSetImpl.class);
    public static final String SWATCH_PROPERTY = "dam:s7Swatch";
    public static final String S7_SET_REL_NAME = "s7Set";

    protected SwatchSetImpl(com.adobe.granite.asset.api.Asset graniteAsset) {
        this(graniteAsset, null);
    }

    protected SwatchSetImpl(com.adobe.granite.asset.api.Asset graniteAsset, String type) {
        super((Resource)graniteAsset);
        this.graniteAsset = graniteAsset;
        this.resolver = graniteAsset.getResourceResolver();
        this.contentResource = this.resolver.getResource((Resource)graniteAsset, "jcr:content");
    }

    public boolean remove(Asset asset) {
        try {
            this.graniteAsset.removeRelation(S7_SET_REL_NAME, asset.getPath());
            this.setLastModified();
            return true;
        }
        catch (AssetException e) {
            log.error("can not remove asset from the set", (Throwable)e);
            return false;
        }
    }

    public Iterator<Asset> getImages() {
        final Iterator members = this.graniteAsset.listRelated(S7_SET_REL_NAME);
        return new Iterator<Asset>(){

            @Override
            public boolean hasNext() {
                return members.hasNext();
            }

            @Override
            public Asset next() {
                return (Asset)((com.adobe.granite.asset.api.Asset)members.next()).adaptTo(Asset.class);
            }

            @Override
            public void remove() {
                members.remove();
            }
        };
    }

    public boolean contains(Asset asset) {
        Iterator members = this.graniteAsset.listRelated(S7_SET_REL_NAME);
        while (members.hasNext()) {
            if (!((com.adobe.granite.asset.api.Asset)members.next()).getPath().equals(asset.getPath())) continue;
            return true;
        }
        return false;
    }

    public void orderBefore(Asset srcAsset, Asset destAsset) {
        try {
            if (srcAsset == null) {
                throw new IllegalArgumentException("Source Asset can not be null");
            }
            String destAssetPath = null;
            if (destAsset != null) {
                destAssetPath = destAsset.getPath();
            }
            this.graniteAsset.orderRelationBefore(S7_SET_REL_NAME, srcAsset.getPath(), destAssetPath);
            this.setLastModified();
        }
        catch (IllegalArgumentException e) {
            log.error("can not order set", (Throwable)e);
            throw e;
        }
    }

    public String getType() {
        ValueMap vm = (ValueMap)this.contentResource.adaptTo(ValueMap.class);
        return (String)vm.get("dam:s7damType", (Object)"");
    }

    public boolean add(Asset asset, Asset swatch) {
        if (DamUtils.isImage(asset)) {
            HashMap<String, String> props = null;
            if (swatch != null) {
                props = new HashMap<String, String>();
                props.put(SWATCH_PROPERTY, swatch.getPath());
            }
            this.graniteAsset.addRelation(S7_SET_REL_NAME, asset.getPath(), props);
            this.setLastModified();
            return true;
        }
        throw new IllegalArgumentException("illegal mime type " + asset.getMimeType() + " only image mime types can be added to image set");
    }

    private void setLastModified() {
        ModifiableValueMap contentProps = (ModifiableValueMap)this.contentResource.adaptTo(ModifiableValueMap.class);
        contentProps.put((Object)"jcr:lastModifiedBy", (Object)this.resolver.getUserID());
        contentProps.put((Object)"jcr:lastModified", (Object)Calendar.getInstance());
    }

    public Asset getSwatch(Asset asset) {
        Iterator relations = this.graniteAsset.listRelations(S7_SET_REL_NAME);
        while (relations.hasNext()) {
            Resource resource;
            String swatchPath;
            ModifiableValueMap mvm;
            AssetRelation relation = (AssetRelation)relations.next();
            com.adobe.granite.asset.api.Asset relatedAsset = relation.getAsset();
            if (!relatedAsset.getPath().equals(asset.getPath()) || (mvm = relation.getProperties()) == null || !StringUtils.isNotBlank((String)(swatchPath = (String)mvm.get(SWATCH_PROPERTY, (Object)""))) || (resource = this.resolver.getResource(swatchPath)) == null) continue;
            return (Asset)resource.adaptTo(Asset.class);
        }
        return null;
    }

    public void setSwatch(Asset asset, Asset swatch) {
        Iterator relations = this.graniteAsset.listRelations(S7_SET_REL_NAME);
        while (relations.hasNext()) {
            ModifiableValueMap mvm;
            AssetRelation relation = (AssetRelation)relations.next();
            com.adobe.granite.asset.api.Asset relatedAsset = relation.getAsset();
            if (!relatedAsset.getPath().equals(asset.getPath()) || (mvm = relation.getProperties()) == null) continue;
            if (swatch != null) {
                mvm.put((Object)SWATCH_PROPERTY, (Object)swatch.getPath());
            } else {
                mvm.remove((Object)SWATCH_PROPERTY);
            }
            this.setLastModified();
            break;
        }
    }

    public boolean add(Asset asset) {
        return this.add(asset, null);
    }
}

