/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.common.utils;

import com.day.cq.dam.s7dam.common.utils.ThreadUtils;
import java.text.ParseException;
import java.util.Date;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class DOMUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DOMUtils.class);
    private static XPath XPATH = XPathFactory.newInstance().newXPath();

    private DOMUtils() {
    }

    public static String getNodeValue(Element element, String tagName) {
        String nodeValue = "";
        if (element != null && tagName != null && !"".equals(tagName)) {
            try {
                nodeValue = (String)XPATH.evaluate(tagName + "[1]/text()[1]", element, XPathConstants.STRING);
            }
            catch (XPathExpressionException e) {
                nodeValue = "";
            }
        }
        return nodeValue;
    }

    public static String getSubNodeValue(Element element, String nodeName, String subNodeName) {
        String subNodeValue = "";
        if (element != null && StringUtils.isNotEmpty((String)nodeName) && StringUtils.isNotEmpty((String)subNodeName)) {
            try {
                subNodeValue = (String)XPATH.evaluate(nodeName + "[1]/" + subNodeName + "[1]/text()[1]", element, XPathConstants.STRING);
            }
            catch (XPathExpressionException e) {
                subNodeValue = "";
            }
        }
        return subNodeValue;
    }

    public static Date getDateNodeValue(Element element, String tagName, String dateFormat) {
        String nodeValue = DOMUtils.getNodeValue(element, tagName);
        Date dateNodeValue = null;
        if (StringUtils.isNotEmpty((String)nodeValue)) {
            try {
                dateNodeValue = ThreadUtils.parse(nodeValue, dateFormat);
            }
            catch (ParseException e) {
                LOG.error("Could not parse a valid date from following string: " + nodeValue, (Throwable)e);
            }
        }
        return dateNodeValue;
    }

    public static NodeList getChildNodes(Element element, String childPath) {
        NodeList childNodes = null;
        if (element != null && StringUtils.isNotEmpty((String)childPath)) {
            try {
                childNodes = (NodeList)XPATH.evaluate(childPath, element, XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                childNodes = null;
            }
        }
        return childNodes;
    }
}

