/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.hosted.config.impl;

import com.day.cq.dam.api.s7dam.config.S7damConfigHosted;
import com.day.cq.dam.api.s7dam.config.S7damConfigResolver;
import com.day.cq.dam.s7dam.common.config.S7damConfigService;
import com.day.cq.dam.s7dam.common.model.S7damFolderUploadOptions;
import com.day.cq.dam.s7dam.common.presets.S7damImagePresetsService;
import com.day.cq.dam.s7dam.hosted.ips.S7damService;
import com.day.cq.dam.scene7.api.Scene7EndpointsManager;
import java.net.URL;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.PersistableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.jcr.resource.JcrResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE)
@Service
public class S7damConfigServiceImpl
implements S7damConfigService {
    private static final Logger log = LoggerFactory.getLogger(S7damConfigServiceImpl.class);
    @Reference
    private S7damImagePresetsService s7damImagePresetsService;
    @Reference
    private S7damConfigResolver s7damConfigResolver;
    @Reference
    private S7damService s7damService;
    @Reference
    private Scene7EndpointsManager scene7EndpointsManager;

    @Override
    public void initialize(Resource resource, ResourceResolver rr) throws RepositoryException, PersistenceException {
        Resource syspropResource;
        if (resource == null) {
            return;
        }
        if (!resource.getPath().endsWith("jcr:content")) {
            return;
        }
        Resource configResourceJcrContent = resource;
        PersistableValueMap properties = (PersistableValueMap)configResourceJcrContent.adaptTo(PersistableValueMap.class);
        if (properties.get((Object)"companyHandle") == null) {
            return;
        }
        String s7ConfigPath = ResourceUtil.getParent((String)configResourceJcrContent.getPath());
        S7damConfigHosted s7Config = this.s7damConfigResolver.getS7damConfigHosted(s7ConfigPath);
        if (s7Config == null || !s7Config.isValid()) {
            return;
        }
        Session session = (Session)rr.adaptTo(Session.class);
        String publishServer = this.s7damService.getPublishServer(s7Config);
        String flashTemplatesServer = this.s7damService.getFlashTemplatesServer(s7Config);
        String fxgServer = this.s7damService.getFxgServer(s7Config);
        String targetPath = s7Config.getTargetPath();
        if (targetPath != null) {
            try {
                if (targetPath.endsWith("/")) {
                    targetPath = targetPath.substring(0, targetPath.length() - 1);
                }
                Node s7AssetsFolder = JcrResourceUtil.createPath((String)targetPath, (String)"sling:OrderedFolder", (String)"sling:OrderedFolder", (Session)session, (boolean)true);
                s7AssetsFolder.setProperty("dam:s7damCloudConfigPath", s7ConfigPath);
            }
            catch (RepositoryException e) {
                log.error("Unable to create folder " + targetPath + " for target path", (Throwable)e);
            }
        }
        if (publishServer != null && !publishServer.equals(properties.get("publishServer", String.class))) {
            properties.put((Object)"publishServer", (Object)publishServer);
            log.debug("Caching publish server URL {} for the Scene7 configuration from {}", (Object)publishServer, (Object)s7ConfigPath);
        }
        if (flashTemplatesServer != null && !flashTemplatesServer.equals(properties.get("flashTemplatesServer", String.class))) {
            properties.put((Object)"flashTemplatesServer", (Object)flashTemplatesServer);
            log.debug("Caching flash templates server URL {} for the Scene7 configuration from {}", (Object)flashTemplatesServer, (Object)s7ConfigPath);
        }
        if (fxgServer != null && !fxgServer.equals(properties.get("fxgServer", String.class))) {
            properties.put((Object)"fxgServer", (Object)fxgServer);
            log.debug("Caching FXG server URL {} for the Scene7 configuration from {}", (Object)fxgServer, (Object)s7ConfigPath);
        }
        String HOSTED_WF_MODEL_ID = "/etc/workflow/models/dam/update_asset_s7dam_hosted/jcr:content/model";
        if (!properties.containsKey((Object)"uploadAssetModelID")) {
            properties.put((Object)"uploadAssetModelID", (Object)"/etc/workflow/models/dam/update_asset_s7dam_hosted/jcr:content/model");
        }
        if (configResourceJcrContent.getChild("/etc/cloudservices/s7dam/defaultUploadOptions") == null) {
            S7damFolderUploadOptions uploadOpts = new S7damFolderUploadOptions(configResourceJcrContent.getResourceResolver());
            uploadOpts.createDefaultUploadOptionsNode();
        }
        if (!properties.containsKey((Object)"viewersdkserver")) {
            URL sdkURL = this.scene7EndpointsManager.getViewerSdkServer(s7Config.getRegion());
            if (sdkURL != null) {
                properties.put((Object)"viewersdkserver", (Object)sdkURL.toString());
            } else {
                log.error("Viewer SDK server is not available for region: " + s7Config.getRegion());
            }
        }
        properties.save();
        log.info("Detected Scene7 configuration changes. Caching settings.");
        Resource configResource = configResourceJcrContent.getParent();
        if (!this.s7damImagePresetsService.presetsExist(configResource)) {
            this.s7damImagePresetsService.updateImagePresets(configResource);
        }
        if (configResourceJcrContent.getChild("/etc/cloudservices/s7dam/defaultUploadOptions") == null) {
            S7damFolderUploadOptions uploadOpts = new S7damFolderUploadOptions(configResourceJcrContent.getResourceResolver());
            uploadOpts.createDefaultUploadOptionsNode();
        }
        if ((syspropResource = configResourceJcrContent.getChild("systemProperties")) == null) {
            Node configResourceJcrNode = (Node)configResourceJcrContent.adaptTo(Node.class);
            configResourceJcrNode.addNode("systemProperties", "nt:unstructured");
            syspropResource = configResourceJcrContent.getChild("systemProperties");
            PersistableValueMap systemPropMap = (PersistableValueMap)syspropResource.adaptTo(PersistableValueMap.class);
            Map<String, String> sysprops = this.s7damService.getSystemProperties(s7Config);
            systemPropMap.putAll(sysprops);
            systemPropMap.save();
            configResourceJcrNode.setProperty("previewimageserver", sysprops.get("IpsImageServerUrl"));
        }
        session.save();
    }

    protected void bindS7damImagePresetsService(S7damImagePresetsService s7damImagePresetsService) {
        this.s7damImagePresetsService = s7damImagePresetsService;
    }

    protected void unbindS7damImagePresetsService(S7damImagePresetsService s7damImagePresetsService) {
        if (this.s7damImagePresetsService == s7damImagePresetsService) {
            this.s7damImagePresetsService = null;
        }
    }

    protected void bindS7damConfigResolver(S7damConfigResolver s7damConfigResolver) {
        this.s7damConfigResolver = s7damConfigResolver;
    }

    protected void unbindS7damConfigResolver(S7damConfigResolver s7damConfigResolver) {
        if (this.s7damConfigResolver == s7damConfigResolver) {
            this.s7damConfigResolver = null;
        }
    }

    protected void bindS7damService(S7damService s7damService) {
        this.s7damService = s7damService;
    }

    protected void unbindS7damService(S7damService s7damService) {
        if (this.s7damService == s7damService) {
            this.s7damService = null;
        }
    }

    protected void bindScene7EndpointsManager(Scene7EndpointsManager scene7EndpointsManager) {
        this.scene7EndpointsManager = scene7EndpointsManager;
    }

    protected void unbindScene7EndpointsManager(Scene7EndpointsManager scene7EndpointsManager) {
        if (this.scene7EndpointsManager == scene7EndpointsManager) {
            this.scene7EndpointsManager = null;
        }
    }
}

