/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.hosted.constants;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum S7damAssetType {
    IMAGE("Image"),
    VIDEO("Video"),
    TEMPLATE("Template"),
    PSD_TEMPLATE("PsdTemplate"),
    FLASH("Flash"),
    GENERIC("Generic"),
    MASTER_VIDEO("MasterVideo"),
    FXG("Fxg"),
    VIEWER_PRESET("ViewerPreset"),
    MBR_SET("MbrSet");

    private static final Logger LOG;
    private String type;

    private S7damAssetType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.type;
    }

    public static S7damAssetType toS7damAssetType(String type) {
        S7damAssetType[] assetTypes;
        S7damAssetType assetType = null;
        for (S7damAssetType validAssetType : assetTypes = S7damAssetType.values()) {
            if (!validAssetType.getValue().equals(type)) continue;
            assetType = validAssetType;
            break;
        }
        if (assetType == null) {
            LOG.warn("Invalid S7dam asset type '{}'! Using generic asset type!", (Object)type);
            assetType = GENERIC;
        }
        return assetType;
    }

    static {
        LOG = LoggerFactory.getLogger(S7damAssetType.class);
    }
}

