/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.hosted.ips.impl;

import com.adobe.granite.crypto.CryptoSupport;
import com.day.cq.dam.api.s7dam.config.S7damConfigHosted;
import com.day.cq.dam.api.s7dam.config.S7damConfigResolver;
import com.day.cq.dam.s7dam.common.model.S7damImagePreset;
import com.day.cq.dam.s7dam.common.utils.RequestUtils;
import com.day.cq.dam.s7dam.hosted.constants.S7damAssetType;
import com.day.cq.dam.s7dam.hosted.constants.S7damJobType;
import com.day.cq.dam.s7dam.hosted.ips.S7damAPIClient;
import com.day.cq.dam.s7dam.hosted.model.MetadataCondition;
import com.day.cq.dam.s7dam.hosted.model.S7damAsset;
import com.day.cq.dam.scene7.api.Scene7EndpointsManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@Component
@Service
public class S7damAPIClientImpl
implements S7damAPIClient {
    private static final int HTTP_SOCKET_TIMEOUT_SECONDS = 10;
    @Reference
    private S7damConfigResolver s7ConfigResolver;
    @Reference
    private Scene7EndpointsManager scene7EndpointsManager;
    @Reference
    private CryptoSupport cryptoSupport;
    private static final Logger LOG = LoggerFactory.getLogger(S7damAPIClientImpl.class);

    private Document makeRequest(String operation, String payload, S7damConfigHosted s7Config) throws Exception {
        StringBuilder requestBodySB = new StringBuilder();
        String password = this.cryptoSupport.unprotect(s7Config.getPassword());
        requestBodySB.append("<SOAP-ENV:Envelope xmlns:SOAP-ENV='http://schemas.xmlsoap.org/soap/envelope/' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'><SOAP-ENV:Header><authHeader xmlns='http://www.scene7.com/IpsApi/xsd'><user><![CDATA[");
        requestBodySB.append(s7Config.getEmail());
        requestBodySB.append("]]></user><password><![CDATA[");
        requestBodySB.append(password);
        requestBodySB.append("]]></password><locale>en-US</locale><appName>Adobe.S7dam.CQ</appName><appVersion>5.6.1</appVersion><faultHttpStatusCode>200</faultHttpStatusCode></authHeader></SOAP-ENV:Header><SOAP-ENV:Body><");
        requestBodySB.append(operation);
        requestBodySB.append("Param xmlns='http://www.scene7.com/IpsApi/xsd/");
        requestBodySB.append(this.scene7EndpointsManager.getAPIVersion(s7Config.getRegion()));
        requestBodySB.append("'>");
        if (payload != null) {
            requestBodySB.append(payload);
        }
        requestBodySB.append("</");
        requestBodySB.append(operation);
        requestBodySB.append("Param></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        String requestBody = requestBodySB.toString();
        String uri = this.scene7EndpointsManager.getAPIServer(s7Config.getRegion()) + "/scene7/services/IpsApiService";
        HttpClient client = this.newHttpClient();
        PostMethod request = new PostMethod(uri);
        request.addRequestHeader("SOAPAction", operation);
        LOG.debug("Connecting to {}", (Object)uri);
        LOG.debug("Request Body: {}", (Object)requestBody);
        String responseBody = this.getResponseBody(requestBody, client, request);
        LOG.debug("Response Body: {}", (Object)responseBody);
        Document document = RequestUtils.getResponseDOM(IOUtils.toInputStream((String)responseBody, (String)"UTF-8"));
        return document;
    }

    protected String getResponseBody(String requestBody, HttpClient client, PostMethod request) throws IOException, HttpException {
        StringRequestEntity entity = new StringRequestEntity(requestBody, "text/xml", "UTF-8");
        request.setRequestEntity((RequestEntity)entity);
        client.executeMethod((HttpMethod)request);
        return IOUtils.toString((InputStream)request.getResponseBodyAsStream(), (String)"UTF-8");
    }

    @Override
    public Document deleteAsset(String assetHandle, S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            StringBuilder payloadSB = new StringBuilder("<companyHandle>");
            payloadSB.append(s7Config.getCompanyHandle());
            payloadSB.append("</companyHandle><assetHandle>");
            payloadSB.append(assetHandle);
            payloadSB.append("</assetHandle>");
            try {
                document = this.makeRequest("deleteAsset", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to delete asset " + assetHandle, (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document deleteFolder(String folderHandle, S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            StringBuilder payloadSB = new StringBuilder();
            payloadSB.append("<companyHandle>").append(s7Config.getCompanyHandle()).append("</companyHandle>");
            payloadSB.append("<folderHandle>").append(folderHandle).append("</folderHandle>");
            try {
                document = this.makeRequest("deleteFolder", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to delete folder " + folderHandle + " from S7dam", (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document getActiveJobs(String jobHandle, String originalName, S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            StringBuilder payloadSB = new StringBuilder("<companyHandle>");
            payloadSB.append(s7Config.getCompanyHandle());
            payloadSB.append("</companyHandle>");
            if (!this.isEmptyString(jobHandle)) {
                payloadSB.append("<jobHandle>").append(jobHandle).append("</jobHandle>");
            } else if (!this.isEmptyString(originalName)) {
                payloadSB.append("<originalName>").append(originalName).append("</originalName>");
            }
            try {
                document = this.makeRequest("getActiveJobs", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to obtain the active jobs", (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document getScheduledJobs(Map<String, Object> settings, S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            StringBuilder payloadSB = new StringBuilder("<companyHandle>");
            payloadSB.append(s7Config.getCompanyHandle());
            payloadSB.append("</companyHandle>");
            String jobHandle = ObjectUtils.toString((Object)settings.get(S7damJobType.JOB_JOBHANDLE.getValue()));
            String originalName = ObjectUtils.toString((Object)settings.get(S7damJobType.JOB_ORIGNAME.getValue()));
            if (!this.isEmptyString(jobHandle)) {
                payloadSB.append("<jobHandle>").append(jobHandle).append("</jobHandle>");
            } else if (!this.isEmptyString(originalName)) {
                payloadSB.append("<originalName>").append(originalName).append("</originalName>");
            }
            try {
                document = this.makeRequest("getScheduledJobs", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to obtain the scheduled jobs", (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document getHistoricalJobs(Map<String, Object> settings, S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            String numRows;
            String endDate;
            String sortBy;
            StringBuilder payloadSB = new StringBuilder("<companyHandle>");
            payloadSB.append(s7Config.getCompanyHandle());
            payloadSB.append("</companyHandle>");
            String userHandle = ObjectUtils.toString((Object)settings.get(S7damJobType.JOB_GET_OWNER.getValue()));
            if (this.isEmptyString(userHandle) || !userHandle.equals("all")) {
                userHandle = s7Config.getUserHandle();
                payloadSB.append("<userHandle>").append(userHandle).append("</userHandle>");
            }
            if (!this.isEmptyString(sortBy = ObjectUtils.toString((Object)settings.get(S7damJobType.JOB_GET_SORTBY.getValue()))) && S7damJobType.toS7damJobType(sortBy) != null) {
                payloadSB.append("<sortBy>").append(sortBy).append("</sortBy>");
            } else {
                payloadSB.append("<sortBy>").append(S7damJobType.JOB_GET_SORTBY_STARTDATE.getValue()).append("</sortBy>");
            }
            String sortDirection = ObjectUtils.toString((Object)settings.get(S7damJobType.JOB_GET_SORTDIRECTION.getValue()));
            if (!this.isEmptyString(sortDirection) && S7damJobType.toS7damJobType(sortBy) != null) {
                payloadSB.append("<sortDirection>").append(sortDirection).append("</sortDirection>");
            } else {
                payloadSB.append("<sortDirection>").append(S7damJobType.JOB_GET_SORTDIRECTION_DESCENDING.getValue()).append("</sortDirection>");
            }
            String startDate = ObjectUtils.toString((Object)settings.get(S7damJobType.JOB_GET_STARTDATE.getValue()));
            if (!this.isEmptyString(startDate)) {
                payloadSB.append("<startDate>").append(startDate).append("</startDate>");
            }
            if (!this.isEmptyString(endDate = ObjectUtils.toString((Object)settings.get(S7damJobType.JOB_GET_ENDDATE.getValue())))) {
                payloadSB.append("<endDate>").append(endDate).append("</endDate>");
            }
            if (!this.isEmptyString(numRows = ObjectUtils.toString((Object)settings.get(S7damJobType.JOB_GET_NUMROWS.getValue())))) {
                payloadSB.append("<numRows>").append(numRows).append("</numRows>");
            }
            try {
                document = this.makeRequest("getJobLogs", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to obtain the job logs", (Throwable)e);
            }
        }
        return document;
    }

    private boolean isEmptyString(String str) {
        return str == null || str.equals("");
    }

    @Override
    public Document getAssets(String[] assetHandles, String[] responseFields, String[] excludeFields, S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            StringBuilder payloadSB = new StringBuilder("<companyHandle>");
            payloadSB.append(s7Config.getCompanyHandle());
            payloadSB.append("</companyHandle><assetHandleArray>");
            for (String assetHandle : assetHandles) {
                payloadSB.append("<items>").append(assetHandle).append("</items>");
            }
            payloadSB.append("</assetHandleArray>");
            if (responseFields != null) {
                payloadSB.append("<responseFieldArray>");
                for (String responseField : responseFields) {
                    payloadSB.append("<items>").append(responseField).append("</items>");
                }
                payloadSB.append("</responseFieldArray>");
            }
            if (excludeFields != null) {
                payloadSB.append("<excludeFieldArray>");
                for (String excludeField : excludeFields) {
                    payloadSB.append("<items>").append(excludeField).append("</items>");
                }
                payloadSB.append("</excludeFieldArray>");
            } else {
                payloadSB.append("<excludeFieldArray><items>assetArray/items/permissions</items></excludeFieldArray>");
            }
            try {
                document = this.makeRequest("getAssets", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to obtain assets", (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document getAssociatedAssets(String assetHandle, String[] responseFields, String[] excludeFields, S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            StringBuilder payloadSB = new StringBuilder("<companyHandle>");
            payloadSB.append(s7Config.getCompanyHandle());
            payloadSB.append("</companyHandle><assetHandle>");
            payloadSB.append(assetHandle);
            payloadSB.append("</assetHandle>");
            if (responseFields != null) {
                payloadSB.append("<responseFieldArray>");
                for (String responseField : responseFields) {
                    payloadSB.append("<items>").append(responseField).append("</items>");
                }
                payloadSB.append("</responseFieldArray>");
            }
            if (excludeFields != null) {
                payloadSB.append("<excludeFieldArray>");
                for (String excludeField : excludeFields) {
                    payloadSB.append("<items>").append(excludeField).append("</items>");
                }
                payloadSB.append("</excludeFieldArray>");
            }
            try {
                document = this.makeRequest("getAssociatedAssets", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to get associated assets for " + assetHandle, (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document getCompanyMembership(String userHandle, String email, String password, String region) {
        Document document = null;
        S7damConfigHosted s7Config = this.s7ConfigResolver.getS7damConfigHosted(email, password, region);
        if (s7Config != null) {
            StringBuilder payloadSB = new StringBuilder("<userHandle>");
            payloadSB.append(userHandle);
            payloadSB.append("</userHandle>");
            try {
                document = this.makeRequest("getCompanyMembership", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to obtain company memberhsip for user handle " + userHandle, (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document getFolderTree(String folderPath, int depth, String[] responseFields, String[] excludeFields, S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            StringBuilder payloadSB = new StringBuilder("<companyHandle>");
            payloadSB.append(s7Config.getCompanyHandle());
            payloadSB.append("</companyHandle>");
            if (folderPath != null) {
                payloadSB.append("<folderPath>").append(folderPath).append("</folderPath>");
            }
            payloadSB.append("<depth>");
            payloadSB.append(depth);
            payloadSB.append("</depth>");
            if (responseFields != null) {
                payloadSB.append("<responseFieldArray>");
                for (String responseField : responseFields) {
                    payloadSB.append("<items>").append(responseField).append("</items>");
                }
                payloadSB.append("</responseFieldArray>");
            }
            if (excludeFields != null) {
                payloadSB.append("<excludeFieldArray>");
                for (String excludeField : excludeFields) {
                    payloadSB.append("<items>").append(excludeField).append("</items>");
                }
                payloadSB.append("</excludeFieldArray>");
            }
            try {
                document = this.makeRequest("getFolderTree", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to obtain the folder tree for folder path " + folderPath, (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document getJobLogDetails(Map<String, Object> settings, S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            StringBuilder payloadSB = new StringBuilder("<companyHandle>");
            payloadSB.append(s7Config.getCompanyHandle());
            payloadSB.append("</companyHandle>");
            String jobHandle = ObjectUtils.toString((Object)settings.get(S7damJobType.JOB_JOBHANDLE.getValue()));
            String originalName = ObjectUtils.toString((Object)settings.get(S7damJobType.JOB_ORIGNAME.getValue()));
            if (!this.isEmptyString(jobHandle)) {
                payloadSB.append("<jobHandle>").append(jobHandle).append("</jobHandle>");
            } else if (!this.isEmptyString(originalName)) {
                payloadSB.append("<originalName>").append(originalName).append("</originalName>");
            }
            try {
                document = this.makeRequest("getJobLogDetails", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to get job log details for " + jobHandle, (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document getJobLogDetails(String jobHandle, String originalName, S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            StringBuilder payloadSB = new StringBuilder("<companyHandle>");
            payloadSB.append(s7Config.getCompanyHandle());
            payloadSB.append("</companyHandle>");
            if (jobHandle != null) {
                payloadSB.append("<jobHandle>").append(jobHandle).append("</jobHandle>");
            } else if (originalName != null) {
                payloadSB.append("<originalName>").append(originalName).append("</originalName>");
            }
            try {
                document = this.makeRequest("getJobLogDetails", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to get job log details for " + jobHandle, (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document getPropertySets(String appSettingsTypeHandle, S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            StringBuilder payloadSB = new StringBuilder("<typeHandle>");
            payloadSB.append(appSettingsTypeHandle);
            payloadSB.append("</typeHandle><primaryOwnerHandle>");
            payloadSB.append(s7Config.getCompanyHandle());
            payloadSB.append("</primaryOwnerHandle>");
            try {
                document = this.makeRequest("getPropertySets", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to obtain the property sets", (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document getPropertySetTypes(S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            try {
                document = this.makeRequest("getPropertySetTypes", null, s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to obtain the property set types", (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document getUserInfo(String email, String password, String region) {
        Document document = null;
        S7damConfigHosted s7Config = this.s7ConfigResolver.getS7damConfigHosted(email, password, region);
        if (s7Config != null) {
            StringBuilder payloadSB = new StringBuilder("<email>");
            payloadSB.append(email);
            payloadSB.append("</email>");
            try {
                document = this.makeRequest("getUserInfo", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to obtain user info for " + email, (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document searchAssets(String folder, Boolean includeSubfolders, Boolean published, String[] assetTypes, String[] assetSubTypes, String[] responseFields, String[] excludeFields, int recordsPerPage, int resultsPage, S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            StringBuilder payloadSB = new StringBuilder("<companyHandle>");
            payloadSB.append(s7Config.getCompanyHandle());
            payloadSB.append("</companyHandle>");
            if (folder != null) {
                payloadSB.append("<folder>").append(folder).append("</folder>");
            }
            if (includeSubfolders != null) {
                payloadSB.append("<includeSubfolders>").append(includeSubfolders.toString()).append("</includeSubfolders>");
            }
            if (published != null) {
                payloadSB.append("<publishState>");
                if (published.booleanValue()) {
                    payloadSB.append("MarkedForPublish");
                } else {
                    payloadSB.append("NotMarkedForPublish");
                }
                payloadSB.append("</publishState>");
            }
            payloadSB.append("<trashState>NotInTrash</trashState>");
            if (assetTypes != null) {
                payloadSB.append("<assetTypeArray>");
                for (String assetType : assetTypes) {
                    payloadSB.append("<items>").append(assetType).append("</items>");
                }
                payloadSB.append("</assetTypeArray>");
            }
            if (assetSubTypes != null) {
                payloadSB.append("<assetSubTypeArray>");
                for (String assetSubType : assetSubTypes) {
                    payloadSB.append("<items>").append(assetSubType).append("</items>");
                }
                payloadSB.append("</assetSubTypeArray>");
            }
            payloadSB.append("<excludeByproducts>false</excludeByproducts><recordsPerPage>").append(recordsPerPage);
            payloadSB.append("</recordsPerPage><resultsPage>").append(resultsPage);
            payloadSB.append("</resultsPage><sortBy>Name</sortBy><sortDirection>Ascending</sortDirection>");
            if (responseFields != null) {
                payloadSB.append("<responseFieldArray>");
                for (String responseField : responseFields) {
                    payloadSB.append("<items>").append(responseField).append("</items>");
                }
                payloadSB.append("</responseFieldArray>");
            }
            if (excludeFields != null) {
                payloadSB.append("<excludeFieldArray>");
                for (String excludeField : excludeFields) {
                    payloadSB.append("<items>").append(excludeField).append("</items>");
                }
                payloadSB.append("</excludeFieldArray>");
            }
            try {
                document = this.makeRequest("searchAssets", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to retreieve assets from search operation", (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document searchAssetsByMetadata(String folder, Boolean includeSubfolders, String[] assetTypes, String[] assetSubTypes, Boolean published, MetadataCondition[] conditions, S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            StringBuilder payloadSB = new StringBuilder("<companyHandle>");
            payloadSB.append(s7Config.getCompanyHandle());
            payloadSB.append("</companyHandle><filters>");
            if (folder != null) {
                payloadSB.append("<folder>").append(folder).append("</folder>");
            }
            if (includeSubfolders != null) {
                payloadSB.append("<includeSubfolders>").append(includeSubfolders.toString()).append("</includeSubfolders>");
            }
            if (assetTypes != null) {
                payloadSB.append("<assetTypeArray>");
                for (String assetType : assetTypes) {
                    payloadSB.append("<items>").append(assetType).append("</items>");
                }
                payloadSB.append("</assetTypeArray>");
            }
            if (assetSubTypes != null) {
                payloadSB.append("<assetSubTypeArray>");
                for (String assetSubType : assetSubTypes) {
                    payloadSB.append("<items>").append(assetSubType).append("</items>");
                }
                payloadSB.append("</assetSubTypeArray>");
            }
            if (published != null) {
                payloadSB.append("<publishState>");
                if (published.booleanValue()) {
                    payloadSB.append("MarkedForPublish");
                } else {
                    payloadSB.append("NotMarkedForPublish");
                }
            }
            payloadSB.append("</publishState><trashState>NotInTrash</trashState></filters>");
            if (conditions != null) {
                payloadSB.append("<metadataConditionArray>");
                for (MetadataCondition condition : conditions) {
                    payloadSB.append("<items><fieldHandle>").append(condition.fieldHandle).append("</fieldHandle>");
                    payloadSB.append("<op>").append(condition.op).append("</op>");
                    payloadSB.append("<value>").append(condition.value).append("</value></items>");
                }
                payloadSB.append("</metadataConditionArray>");
            }
            payloadSB.append("<recordsPerPage>2000</recordsPerPage><resultsPage>1</resultsPage>");
            try {
                document = this.makeRequest("searchAssetsByMetadata", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to perform assets search by metadata", (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document submitJob(String jobName, S7damJobType jobType, S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            StringBuilder payloadSB = new StringBuilder("<companyHandle>");
            payloadSB.append(s7Config.getCompanyHandle());
            payloadSB.append("</companyHandle><jobName>");
            payloadSB.append(jobName);
            payloadSB.append("</jobName>");
            switch (jobType) {
                case IMAGE_SERVING_PUBLISH_JOB: {
                    payloadSB.append("<imageServingPublishJob><publishType>Incremental</publishType><emailSetting>Error</emailSetting></imageServingPublishJob>");
                    break;
                }
            }
            try {
                document = this.makeRequest("submitJob", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to submit job " + jobName, (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document submitJob(Map<String, Object> settings, S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            String execSchedule;
            StringBuilder payloadSB = new StringBuilder("<companyHandle>");
            payloadSB.append(s7Config.getCompanyHandle());
            payloadSB.append("</companyHandle><userHandle>");
            String userHandle = ObjectUtils.toString((Object)settings.get(S7damJobType.JOB_USERHANDLE.getValue()));
            userHandle = this.isEmptyString(userHandle) ? s7Config.getUserHandle() : userHandle;
            payloadSB.append(userHandle);
            payloadSB.append("</userHandle><jobName>");
            payloadSB.append(settings.get(S7damJobType.JOB_JOBNAME.getValue()));
            payloadSB.append("</jobName>");
            String execTime = ObjectUtils.toString((Object)settings.get(S7damJobType.JOB_EXECTIME.getValue()));
            if (!this.isEmptyString(execTime)) {
                payloadSB.append("<execTime>").append(execTime).append("</execTime>");
            }
            if (!this.isEmptyString(execSchedule = ObjectUtils.toString((Object)settings.get(S7damJobType.JOB_EXECSCHEDULE.getValue())))) {
                payloadSB.append("<execSchedule>").append(execSchedule).append("</execSchedule>");
            }
            String description = ObjectUtils.toString((Object)settings.get(S7damJobType.JOB_DESCRIPTION.getValue()));
            payloadSB.append("<description>").append(description).append("</description>");
            String jobTypeStr = ObjectUtils.toString((Object)settings.get(S7damJobType.JOB_GET_TYPE.getValue()));
            S7damJobType jobType = S7damJobType.toS7damJobType(jobTypeStr);
            switch (jobType) {
                case EXPORT_JOB: {
                    payloadSB.append(this.setInputExportJob(settings));
                    break;
                }
                case IMAGE_SERVING_PUBLISH_JOB: {
                    payloadSB.append("<imageServingPublishJob><publishType>Incremental</publishType><emailSetting>Error</emailSetting></imageServingPublishJob>");
                    break;
                }
            }
            try {
                document = this.makeRequest("submitJob", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to submit job " + jobTypeStr, (Throwable)e);
            }
        }
        return document;
    }

    private String setInputExportJob(Map<String, Object> settings) {
        String macro;
        String inputJob = "<exportJob>";
        String[] assetHandleArr = (String[])settings.get(S7damJobType.JOB_EXPORT_ASSETHANDLEARRAY.getValue());
        if (assetHandleArr != null) {
            inputJob = inputJob + "<assetHandleArray>";
            for (int i = 0; i < assetHandleArr.length; ++i) {
                inputJob = inputJob + "<items>" + assetHandleArr[i] + "</items>";
            }
            inputJob = inputJob + "</assetHandleArray>";
        } else {
            LOG.error("Unable to submit export job : export assetHandles is null.");
        }
        inputJob = inputJob + "<fmt>" + settings.get(S7damJobType.JOB_EXPORT_FMT.getValue()) + "</fmt>";
        String isModifier = ObjectUtils.toString((Object)settings.get(S7damJobType.JOB_EXPORT_ISMODIFIER.getValue()));
        if (!this.isEmptyString(isModifier)) {
            inputJob = inputJob + "<is_modifier>" + isModifier + "</is_modifier>";
        }
        if (!this.isEmptyString(macro = ObjectUtils.toString((Object)settings.get(S7damJobType.JOB_EXPORT_MACRO.getValue())))) {
            inputJob = inputJob + "<macro>" + macro + "</macro>";
        }
        inputJob = inputJob + "<emailSetting>" + settings.get(S7damJobType.SUBMIT_JOB_EMAILSETTING.getValue()) + "</emailSetting>";
        inputJob = inputJob + "</exportJob>";
        return inputJob;
    }

    @Override
    public Document getSystemProperties(S7damConfigHosted s7Config) {
        Document document = null;
        String url = null;
        if (s7Config != null) {
            try {
                String spsServer = this.scene7EndpointsManager.getSPSServer(s7Config.getRegion()).toString();
                StringBuilder urlSB = new StringBuilder(spsServer);
                if (!spsServer.endsWith("/")) {
                    urlSB.append("/");
                }
                urlSB.append("IpsWebServlets/GetSystemProperties");
                url = urlSB.toString();
                HttpClient httpClient = this.newHttpClient();
                GetMethod request = new GetMethod(url);
                LOG.debug("Attempting to retrieve S7dam SPS system properties from {}", (Object)url);
                httpClient.executeMethod((HttpMethod)request);
                int statusCode = request.getStatusCode();
                if (statusCode == 200) {
                    String responseBody = IOUtils.toString((InputStream)request.getResponseBodyAsStream(), (String)"UTF-8");
                    LOG.debug("Response Body: {}", (Object)responseBody);
                    document = RequestUtils.getResponseDOM(IOUtils.toInputStream((String)responseBody, (String)"UTF-8"));
                } else {
                    LOG.error("Error retrieving system properties from " + url + "; HTTP Status code " + statusCode);
                }
            }
            catch (Exception e) {
                LOG.error("Unable to retrieve system properties from " + url, (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public InputStream getOriginalFile(String assetHandle, S7damConfigHosted s7Config) {
        InputStream is = null;
        try {
            if (assetHandle == null) {
                throw new NullPointerException("Null asset handle!");
            }
            if (s7Config == null) {
                throw new NullPointerException("Null S7dam configuration!");
            }
            URL ipsServerURL = this.scene7EndpointsManager.getIPSServer(s7Config.getRegion());
            StringBuilder urlSB = new StringBuilder(ipsServerURL.toString());
            if (urlSB.lastIndexOf("/") != urlSB.length()) {
                urlSB.append("/");
            }
            urlSB.append("scene7/GetFile?assetHandle=").append(URLEncoder.encode(assetHandle, "UTF-8"));
            HttpClient httpClient = this.newHttpClient();
            int ipsServerPort = ipsServerURL.getPort() == -1 ? 80 : ipsServerURL.getPort();
            String password = this.cryptoSupport.unprotect(s7Config.getPassword());
            httpClient.getState().setCredentials(new AuthScope(ipsServerURL.getHost(), ipsServerPort), (Credentials)new UsernamePasswordCredentials(s7Config.getEmail(), password));
            String url = urlSB.toString();
            GetMethod request = new GetMethod(url);
            LOG.debug("Attempting to retrieve file from {}", (Object)url);
            httpClient.executeMethod((HttpMethod)request);
            int statusCode = request.getStatusCode();
            if (statusCode == 200) {
                is = request.getResponseBodyAsStream();
            } else {
                LOG.error("HTTP Response code " + statusCode + "; requested file: " + url);
            }
        }
        catch (Exception e) {
            LOG.error("Error retrieving asset file from S7dam", (Throwable)e);
        }
        return is;
    }

    @Override
    public InputStream getIPSFile(S7damAsset asset, S7damConfigHosted s7Config) {
        InputStream is = null;
        try {
            if (asset == null) {
                throw new NullPointerException("Null asset!");
            }
            if (s7Config == null) {
                throw new NullPointerException("Null S7dam configuration!");
            }
            String ipsEndpoint = this.scene7EndpointsManager.getIPSServer(s7Config.getRegion()).toString();
            if (!ipsEndpoint.endsWith("/")) {
                ipsEndpoint = ipsEndpoint + "/";
            }
            StringBuilder frSB = new StringBuilder(ipsEndpoint);
            frSB.append("is/image/").append(URLEncoder.encode(s7Config.getBasePath(), "UTF-8"));
            String fileReference = RequestUtils.buildURL(frSB.toString(), URLEncoder.encode(FilenameUtils.removeExtension((String)asset.getName()), "UTF-8"), null);
            HttpClient httpClient = this.newHttpClient();
            String authURL = ipsEndpoint + "scene7/XML/VatLogin.jsp?skiplist=1";
            GetMethod request = new GetMethod(authURL);
            httpClient.executeMethod((HttpMethod)request);
            int statusCode = request.getStatusCode();
            if (statusCode != 200) {
                LOG.error("Cannot bypass S7dam IPS authentication: HTTP Response code {} on accessing {}", (Object)statusCode, (Object)authURL);
            }
            request = new GetMethod(fileReference + "?" + System.currentTimeMillis());
            LOG.debug("Attempting to get the IPS image from {}", (Object)fileReference);
            httpClient.executeMethod((HttpMethod)request);
            statusCode = request.getStatusCode();
            if (statusCode == 200) {
                is = request.getResponseBodyAsStream();
            } else {
                LOG.error("HTTP Response code {}; requested file={}", (Object)statusCode, (Object)fileReference);
            }
        }
        catch (Exception e) {
            LOG.error("Error retrieving asset IPS file from S7dam", (Throwable)e);
        }
        return is;
    }

    @Override
    public InputStream getThumbnailForAsset(S7damAsset s7damAsset, S7damConfigHosted s7Config) {
        InputStream is = null;
        try {
            int statusCode;
            GetMethod request;
            if (s7damAsset == null) {
                throw new NullPointerException("Null asset!");
            }
            if (s7Config == null) {
                throw new NullPointerException("Null S7dam configuration!");
            }
            String ipsEndpoint = this.scene7EndpointsManager.getIPSServer(s7Config.getRegion()).toString();
            if (!ipsEndpoint.endsWith("/")) {
                ipsEndpoint = ipsEndpoint + "/";
            }
            String server = S7damAssetType.FLASH.equals((Object)s7damAsset.getAssetType()) ? s7Config.getFlashTemplatesServer() : ipsEndpoint;
            StringBuilder urlSB = new StringBuilder(server);
            if (!server.endsWith("/")) {
                urlSB.append("/");
            }
            if (!S7damAssetType.FLASH.equals((Object)s7damAsset.getAssetType())) {
                urlSB.append("is/image/");
            }
            urlSB.append(s7Config.get("s7RootPath")).append(URLEncoder.encode(s7damAsset.getName(), "UTF-8"));
            if (S7damAssetType.FLASH.equals((Object)s7damAsset.getAssetType())) {
                urlSB.append("?fmt=jpg");
            }
            HttpClient httpClient = this.newHttpClient();
            if (!S7damAssetType.FLASH.equals((Object)s7damAsset.getAssetType())) {
                String authURL = ipsEndpoint + "s7dam/XML/VatLogin.jsp?skiplist=1";
                request = new GetMethod(authURL);
                httpClient.executeMethod((HttpMethod)request);
                statusCode = request.getStatusCode();
                if (statusCode != 200) {
                    LOG.error("Cannot bypass S7dam IPS authentication: HTTP Response code {} on accessing {}", (Object)statusCode, (Object)authURL);
                }
            }
            String url = urlSB.toString();
            request = new GetMethod(url);
            LOG.debug("Attempting to retrieve file from {}", (Object)url);
            httpClient.executeMethod((HttpMethod)request);
            statusCode = request.getStatusCode();
            if (statusCode == 200) {
                is = request.getResponseBodyAsStream();
            } else {
                LOG.error("HTTP Response code " + statusCode + "; requested file: " + url);
            }
        }
        catch (Exception e) {
            LOG.error("Error retrieving thumbnail file from S7dam", (Throwable)e);
        }
        return is;
    }

    @Override
    public Document getImagePresets(S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            StringBuilder payloadSB = new StringBuilder("<companyHandle>");
            payloadSB.append(s7Config.getCompanyHandle());
            payloadSB.append("</companyHandle>");
            try {
                document = this.makeRequest("getImageFormats", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to obtain the image formats", (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document renameFolder(String folderHandle, String newName, S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            StringBuilder payloadSB = new StringBuilder("<companyHandle>");
            payloadSB.append(s7Config.getCompanyHandle());
            payloadSB.append("</companyHandle><folderHandle>");
            payloadSB.append(folderHandle);
            payloadSB.append("</folderHandle><folderName>");
            payloadSB.append(newName);
            payloadSB.append("</folderName>");
            try {
                document = this.makeRequest("renameFolder", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable rename scene7 folder", (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document createFolder(String path, S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            StringBuilder payloadSB = new StringBuilder("<companyHandle>");
            payloadSB.append(s7Config.getCompanyHandle());
            payloadSB.append("</companyHandle><folderPath>");
            payloadSB.append(path);
            payloadSB.append("</folderPath>");
            try {
                document = this.makeRequest("createFolder", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable create scene7 folder", (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document renameAssetFilename(String assetHandle, String newName, Boolean validateName, S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            StringBuilder payloadSB = new StringBuilder("<companyHandle>");
            payloadSB.append(s7Config.getCompanyHandle());
            payloadSB.append("</companyHandle><assetHandle>");
            payloadSB.append(assetHandle);
            payloadSB.append("</assetHandle><newName>");
            payloadSB.append(newName);
            payloadSB.append("</newName><validateName>");
            payloadSB.append(validateName.toString());
            payloadSB.append("</validateName>");
            try {
                document = this.makeRequest("renameAsset", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to rename the scene7 asset file", (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document moveAssets(Map<String, String> assetMap, S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            StringBuilder payloadSB = new StringBuilder("<companyHandle>");
            payloadSB.append(s7Config.getCompanyHandle());
            payloadSB.append("</companyHandle><assetMoveArray>");
            for (Map.Entry<String, String> item : assetMap.entrySet()) {
                String assetHandle = item.getKey();
                String folderHandle = item.getValue();
                payloadSB.append("<items><assetHandle>");
                payloadSB.append(assetHandle);
                payloadSB.append("</assetHandle><folderHandle>");
                payloadSB.append(folderHandle);
                payloadSB.append("</folderHandle></items>");
            }
            payloadSB.append("</assetMoveArray>");
            try {
                document = this.makeRequest("moveAssets", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to moveAssets within scene7", (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document deleteImagePreset(String presetHandle, S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            StringBuilder payloadSB = new StringBuilder("<companyHandle>");
            payloadSB.append(s7Config.getCompanyHandle());
            payloadSB.append("</companyHandle>");
            payloadSB.append("<imageFormatHandle>");
            payloadSB.append(presetHandle);
            payloadSB.append("</imageFormatHandle>");
            try {
                document = this.makeRequest("deleteImageFormat", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("Unable to delete preset within scene7", (Throwable)e);
            }
        }
        return document;
    }

    @Override
    public Document saveImagePreset(S7damImagePreset newPreset, S7damConfigHosted s7Config) {
        Document document = null;
        if (s7Config != null) {
            String modifierString = "";
            String[] arr = newPreset.getUrlModifier().split("&");
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    modifierString = modifierString + "&amp;";
                }
                modifierString = modifierString + arr[i];
            }
            StringBuilder payloadSB = new StringBuilder("<companyHandle>");
            payloadSB.append(s7Config.getCompanyHandle());
            payloadSB.append("</companyHandle>");
            payloadSB.append("<name>" + newPreset.getName() + "</name>");
            payloadSB.append("<urlModifier>" + modifierString + "</urlModifier>");
            try {
                document = this.makeRequest("saveImageFormat", payloadSB.toString(), s7Config);
            }
            catch (Exception e) {
                LOG.error("unable to save preset within scene7", (Throwable)e);
            }
        }
        return document;
    }

    private HttpClient newHttpClient() {
        HttpClientParams httpClientParams = new HttpClientParams();
        httpClientParams.setSoTimeout(10000);
        return new HttpClient(httpClientParams);
    }

    protected void bindS7ConfigResolver(S7damConfigResolver s7damConfigResolver) {
        this.s7ConfigResolver = s7damConfigResolver;
    }

    protected void unbindS7ConfigResolver(S7damConfigResolver s7damConfigResolver) {
        if (this.s7ConfigResolver == s7damConfigResolver) {
            this.s7ConfigResolver = null;
        }
    }

    protected void bindScene7EndpointsManager(Scene7EndpointsManager scene7EndpointsManager) {
        this.scene7EndpointsManager = scene7EndpointsManager;
    }

    protected void unbindScene7EndpointsManager(Scene7EndpointsManager scene7EndpointsManager) {
        if (this.scene7EndpointsManager == scene7EndpointsManager) {
            this.scene7EndpointsManager = null;
        }
    }

    protected void bindCryptoSupport(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    protected void unbindCryptoSupport(CryptoSupport cryptoSupport) {
        if (this.cryptoSupport == cryptoSupport) {
            this.cryptoSupport = null;
        }
    }
}

