/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.hosted.ips.impl;

import com.day.cq.dam.api.s7dam.config.S7damConfigHosted;
import com.day.cq.dam.s7dam.common.model.S7damImagePreset;
import com.day.cq.dam.s7dam.common.presets.impl.S7damImagePresetImpl;
import com.day.cq.dam.s7dam.common.utils.DOMUtils;
import com.day.cq.dam.s7dam.hosted.ips.S7damAPIClient;
import com.day.cq.dam.s7dam.hosted.ips.S7damService;
import com.day.cq.dam.s7dam.hosted.jobs.model.S7damUploadJobDetail;
import com.day.cq.dam.s7dam.hosted.jobs.model.S7damUploadJobDetailImpl;
import com.day.cq.dam.s7dam.hosted.model.MetadataCondition;
import com.day.cq.dam.s7dam.hosted.model.S7damAsset;
import com.day.cq.dam.s7dam.hosted.model.S7damAssetFactory;
import com.day.cq.dam.s7dam.hosted.model.S7damFolder;
import com.day.cq.dam.s7dam.hosted.model.S7damFolderFactory;
import com.day.cq.dam.s7dam.hosted.model.S7damPropertySet;
import com.day.cq.dam.s7dam.hosted.model.S7damPropertySetImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component
@Service
public class S7damServiceImpl
implements S7damService {
    private static final Logger LOG = LoggerFactory.getLogger(S7damServiceImpl.class);
    @Reference
    private S7damAPIClient s7damAPIClient;

    @Override
    public String getApplicationPropertyHandle(S7damConfigHosted s7Config) {
        Document document = this.s7damAPIClient.getPropertySetTypes(s7Config);
        if (document != null) {
            NodeList list = document.getElementsByTagName("items");
            for (int i = 0; i < list.getLength(); ++i) {
                NodeList typeHandleNodes;
                NodeList namesNodes = ((Element)list.item(i)).getElementsByTagName("name");
                if (namesNodes.getLength() <= 0 || !"Adobe.SPS.ApplicationSetting".equals(namesNodes.item(0).getFirstChild().getNodeValue()) || (typeHandleNodes = ((Element)list.item(i)).getElementsByTagName("typeHandle")).getLength() <= 0 || typeHandleNodes.item(0).getFirstChild() == null) continue;
                return typeHandleNodes.item(0).getFirstChild().getNodeValue();
            }
        } else {
            LOG.error("getApplicationPropertyHandle, unexpected data format");
        }
        return null;
    }

    @Override
    public String getVideoEncoderPresetTypeHandle(S7damConfigHosted s7Config) {
        Document document = this.s7damAPIClient.getPropertySetTypes(s7Config);
        if (document != null) {
            NodeList list = document.getElementsByTagName("items");
            for (int i = 0; i < list.getLength(); ++i) {
                NodeList typeHandleNodes;
                NodeList namesNodes = ((Element)list.item(i)).getElementsByTagName("name");
                if (namesNodes.getLength() <= 0 || !"Adobe.IPS.VideoEncoderPreset".equals(namesNodes.item(0).getFirstChild().getNodeValue()) || (typeHandleNodes = ((Element)list.item(i)).getElementsByTagName("typeHandle")).getLength() <= 0 || typeHandleNodes.item(0).getFirstChild() == null) continue;
                return typeHandleNodes.item(0).getFirstChild().getNodeValue();
            }
        } else {
            LOG.error("getVideoEncoderPresetTypeHandle, unexpected data format");
        }
        return null;
    }

    @Override
    public List<S7damPropertySet> getPropertySets(String handle, S7damConfigHosted s7Config) {
        ArrayList<S7damPropertySet> propertySets = new ArrayList<S7damPropertySet>();
        try {
            Document document = this.s7damAPIClient.getPropertySets(handle, s7Config);
            if (document != null) {
                NodeList setArray = document.getElementsByTagName("setArray");
                if (setArray != null) {
                    Element setArrayElement = (Element)setArray.item(0);
                    NodeList setArrayItems = setArrayElement.getElementsByTagName("items");
                    if (setArrayItems != null) {
                        for (int i = 0; i < setArrayItems.getLength(); ++i) {
                            Element propertySet = (Element)setArrayItems.item(i);
                            String setHandle = DOMUtils.getNodeValue(propertySet, "setHandle");
                            if (StringUtils.isEmpty((String)setHandle)) continue;
                            String typeHandle = DOMUtils.getNodeValue(propertySet, "typeHandle");
                            NodeList propertyArray = propertySet.getElementsByTagName("propertyArray");
                            if (propertyArray != null) {
                                Element propertyArrayElement = (Element)propertyArray.item(0);
                                NodeList propertyArrayItems = propertyArrayElement.getElementsByTagName("items");
                                if (propertyArrayItems != null) {
                                    HashMap<String, String> properties = new HashMap<String, String>();
                                    for (int j = 0; j < propertyArrayItems.getLength(); ++j) {
                                        Element property = (Element)propertyArrayItems.item(j);
                                        String propertyName = DOMUtils.getNodeValue(property, "name");
                                        String propertyValue = DOMUtils.getNodeValue(property, "value");
                                        properties.put(propertyName, propertyValue);
                                    }
                                    S7damPropertySetImpl s7damPropertySet = new S7damPropertySetImpl(setHandle, typeHandle, properties);
                                    propertySets.add(s7damPropertySet);
                                    continue;
                                }
                                LOG.error("Cannot find any items in the propertyArray tag");
                                continue;
                            }
                            LOG.error("Cannot find a propertyArray in the response");
                        }
                    } else {
                        LOG.error("Cannot find any items in the setArray tag");
                    }
                } else {
                    LOG.error("Cannot find a settArray in the response");
                }
            } else {
                LOG.error("Received a null document");
            }
        }
        catch (Exception e) {
            LOG.error("Failed to retrieve property sets", (Throwable)e);
        }
        return propertySets;
    }

    @Override
    public String getUserHandle(String email, String password, String region) {
        try {
            Document document = this.s7damAPIClient.getUserInfo(email, password, region);
            if (document != null) {
                NodeList list = document.getElementsByTagName("userHandle");
                if (list.getLength() > 0 && list.item(0).getFirstChild() != null) {
                    return list.item(0).getFirstChild().getNodeValue();
                }
            } else {
                LOG.error("getUserHandle, unexpected data format");
            }
        }
        catch (Exception e) {
            LOG.error("getUserHandle failed: ", (Throwable)e);
        }
        return null;
    }

    @Override
    public String getCompanyMembership(String userHandle, String email, String password, String region) {
        try {
            Document document = this.s7damAPIClient.getCompanyMembership(userHandle, email, password, region);
            if (document != null) {
                NodeList list = document.getElementsByTagName("items");
                JSONArray companies = new JSONArray();
                for (int i = 0; i < list.getLength(); ++i) {
                    try {
                        JSONObject company = new JSONObject();
                        NodeList nodes = ((Element)list.item(i)).getElementsByTagName("companyHandle");
                        if (nodes.getLength() > 0 && nodes.item(0).getFirstChild() != null) {
                            company.put("handle", (Object)nodes.item(0).getFirstChild().getNodeValue());
                        }
                        if ((nodes = ((Element)list.item(i)).getElementsByTagName("name")).getLength() > 0 && nodes.item(0).getFirstChild() != null) {
                            company.put("name", (Object)nodes.item(0).getFirstChild().getNodeValue());
                        }
                        if ((nodes = ((Element)list.item(i)).getElementsByTagName("rootPath")).getLength() > 0 && nodes.item(0).getFirstChild() != null) {
                            company.put("rootPath", (Object)nodes.item(0).getFirstChild().getNodeValue());
                        }
                        companies.put((Object)company);
                        continue;
                    }
                    catch (JSONException e) {
                        LOG.error("error parsing company item", (Throwable)e);
                    }
                }
                return companies.toString();
            }
            LOG.error("getCompanyMembership, unexpected data format");
        }
        catch (Exception e) {
            LOG.error("getCompanyMembership failed: " + e.getMessage());
        }
        return "failed";
    }

    @Override
    public S7damFolder getFolderTree(String folderPath, int depth, String[] responseFields, String[] excludeFields, S7damConfigHosted s7Config) {
        S7damFolder s7RootFolder = null;
        try {
            Document document = this.s7damAPIClient.getFolderTree(folderPath, depth, responseFields, excludeFields, s7Config);
            S7damFolderFactory folderFactory = new S7damFolderFactory();
            s7RootFolder = folderFactory.parseS7damFolders(document);
        }
        catch (Exception e) {
            LOG.error("failed to get s7dam folder tree: " + e.getMessage());
        }
        return s7RootFolder;
    }

    @Override
    public String getFolderHandle(String cqFolderPath, S7damConfigHosted s7Config) {
        NodeList nodes;
        String ipsUploadFilePath = s7Config.getRootPath() + cqFolderPath.replaceAll("^/content/dam/", "");
        Document document = this.s7damAPIClient.getFolderTree(ipsUploadFilePath, 0, null, null, s7Config);
        if (document != null && (nodes = document.getElementsByTagName("folderHandle")).getLength() > 0) {
            return nodes.item(0).getFirstChild().getNodeValue();
        }
        return null;
    }

    @Override
    public String deleteFolder(String folderHandle, S7damConfigHosted s7Config) {
        try {
            this.s7damAPIClient.deleteFolder(folderHandle, s7Config);
            return "success";
        }
        catch (Exception e) {
            LOG.error("deleteFolder, failed to delete s7dam folder: " + e.getMessage());
            return "failure";
        }
    }

    @Override
    public List<S7damAsset> getAssets(String[] assetHandles, String[] responseFields, String[] excludeFields, S7damConfigHosted s7Config) {
        ArrayList<S7damAsset> assets = new ArrayList<S7damAsset>();
        try {
            Document document = this.s7damAPIClient.getAssets(assetHandles, responseFields, excludeFields, s7Config);
            if (document != null) {
                S7damAssetFactory assetFactory = new S7damAssetFactory();
                assets.addAll(assetFactory.parseAssets(document));
            } else {
                LOG.error("getAssets, unexpected data format");
            }
        }
        catch (Exception e) {
            LOG.error("getAssets, failed to get s7dam assets: " + e.getMessage());
        }
        return assets;
    }

    @Override
    public String deleteAsset(String assetHandle, S7damConfigHosted s7Config) {
        try {
            this.s7damAPIClient.deleteAsset(assetHandle, s7Config);
            return "success";
        }
        catch (Exception e) {
            LOG.error("deleteAssets, failed to delete s7dam asset: " + e.getMessage());
            return "failue";
        }
    }

    @Override
    public List<S7damAsset> searchAssets(String folder, Boolean includeSubfolders, Boolean published, String[] assetTypes, String[] assetSubTypes, String[] responseFields, String[] excludeFields, S7damConfigHosted s7Config) {
        String totalRowsString;
        ArrayList<S7damAsset> assets = new ArrayList<S7damAsset>();
        S7damAssetFactory assetFactory = new S7damAssetFactory();
        int resultsPage = 1;
        int recordsPerPage = 1000;
        if (assetTypes != null || assetSubTypes != null || responseFields != null) {
            recordsPerPage = 10000;
        }
        Document document = this.s7damAPIClient.searchAssets(folder, includeSubfolders, published, assetTypes, assetSubTypes, responseFields, excludeFields, recordsPerPage, resultsPage, s7Config);
        ++resultsPage;
        assets.addAll(assetFactory.parseAssets(document));
        try {
            totalRowsString = document.getElementsByTagName("totalRows").item(0).getFirstChild().getNodeValue();
        }
        catch (NullPointerException e) {
            totalRowsString = Integer.toString(recordsPerPage);
        }
        Integer totalRows = recordsPerPage;
        try {
            totalRows = new Integer(totalRowsString);
        }
        catch (NumberFormatException e) {
            LOG.warn("Unable to parse totalRows node ({}) to int; using a predetermined value of {}", (Object)totalRowsString, (Object)totalRows);
            totalRows = recordsPerPage;
        }
        int pages = totalRows / recordsPerPage;
        if (totalRows % recordsPerPage > 0) {
            ++pages;
        }
        while (resultsPage <= pages) {
            document = this.s7damAPIClient.searchAssets(folder, includeSubfolders, published, assetTypes, assetSubTypes, responseFields, excludeFields, recordsPerPage, resultsPage, s7Config);
            assets.addAll(assetFactory.parseAssets(document));
            ++resultsPage;
        }
        return assets;
    }

    @Override
    public List<S7damAsset> searchAssetsByMetadata(String folder, Boolean includeSubfolders, String[] assetTypes, String[] assetSubTypes, Boolean published, MetadataCondition[] conditions, S7damConfigHosted s7Config) {
        Document document = this.s7damAPIClient.searchAssetsByMetadata(folder, includeSubfolders, assetTypes, assetSubTypes, published, conditions, s7Config);
        List<S7damAsset> s7damAssets = new ArrayList<S7damAsset>();
        if (document != null) {
            S7damAssetFactory s7af = new S7damAssetFactory();
            s7damAssets = s7af.parseAssets(document);
        } else {
            LOG.error("searchAssets, unexpected data format");
        }
        return s7damAssets;
    }

    @Override
    public boolean isJobActiveByJobHandle(String jobHandle, S7damConfigHosted s7Config) {
        Document document = this.s7damAPIClient.getActiveJobs(jobHandle, null, s7Config);
        return this.internalIsJobActive(document);
    }

    @Override
    public boolean isJobActiveByOriginalName(String originalName, S7damConfigHosted s7Config) {
        Document document = this.s7damAPIClient.getActiveJobs(null, originalName, s7Config);
        return this.internalIsJobActive(document);
    }

    @Override
    public List<String> getJobLogDetails(String jobHandle, S7damConfigHosted s7Config) {
        ArrayList<String> assetHandles = new ArrayList<String>();
        Document document = this.s7damAPIClient.getJobLogDetails(jobHandle, null, s7Config);
        if (document != null) {
            NodeList list = document.getElementsByTagName("assetHandle");
            for (int i = 0; i < list.getLength(); ++i) {
                Node assetHandleNode = list.item(i);
                assetHandles.add(assetHandleNode.getFirstChild().getNodeValue());
            }
        } else {
            LOG.error("getJobLogDetails, unexpected data format");
        }
        return assetHandles;
    }

    @Override
    public List<S7damUploadJobDetail> getMultiFileJobLogDetails(String jobHandle, S7damConfigHosted s7Config) {
        ArrayList<S7damUploadJobDetail> jobDetailList = new ArrayList<S7damUploadJobDetail>();
        Document document = this.s7damAPIClient.getJobLogDetails(jobHandle, null, s7Config);
        NodeList detailArrayNode = document.getElementsByTagName("detailArray");
        if (detailArrayNode.getLength() > 0 && detailArrayNode.item(0).getFirstChild() != null) {
            NodeList nodeLst = ((Element)detailArrayNode.item(0)).getElementsByTagName("items");
            if (nodeLst.getLength() > 0) {
                LOG.debug("items length " + nodeLst.getLength());
            }
            for (int s = 0; s < nodeLst.getLength(); ++s) {
                Node fstNode = nodeLst.item(s);
                if (fstNode.getNodeType() != 1 || !this.isSuccessElement((Element)fstNode) || !this.hasAssetHandleElement((Element)fstNode)) continue;
                jobDetailList.add(new S7damUploadJobDetailImpl((Element)fstNode));
            }
        } else {
            LOG.error("getJobLogDetailsItemElements, unexpected data format");
        }
        return jobDetailList;
    }

    @Override
    public String getPublishServer(S7damConfigHosted s7Config) {
        String appSettingsTypeHandle = this.getApplicationPropertyHandle(s7Config);
        if (appSettingsTypeHandle == null) {
            return null;
        }
        Document document = this.s7damAPIClient.getPropertySets(appSettingsTypeHandle, s7Config);
        if (document != null) {
            NodeList list = document.getElementsByTagName("items");
            for (int i = 0; i < list.getLength(); ++i) {
                NodeList valueNodes;
                NodeList namesNodes = ((Element)list.item(i)).getElementsByTagName("name");
                if (namesNodes.getLength() <= 0 || !"application_server_prefix_published".equals(namesNodes.item(0).getFirstChild().getNodeValue()) || (valueNodes = ((Element)list.item(i)).getElementsByTagName("value")).getLength() <= 0 || valueNodes.item(0).getFirstChild() == null) continue;
                return valueNodes.item(0).getFirstChild().getNodeValue();
            }
        } else {
            LOG.error("getPublishServer, unexpected data format");
        }
        return null;
    }

    private boolean isSuccessElement(Element el) {
        NodeList nodes = el.getElementsByTagName("logType");
        if (nodes.getLength() > 0 && nodes.item(0).getFirstChild() != null) {
            String logTypeValue = nodes.item(0).getFirstChild().getNodeValue();
            LOG.debug("logType: " + logTypeValue);
            if ("FileUpdated".equals(logTypeValue) || "UploadSuccess".equals(logTypeValue) || "UploadWarning".equals(logTypeValue)) {
                return true;
            }
        }
        return false;
    }

    private boolean hasAssetHandleElement(Element el) {
        NodeList nodes = el.getElementsByTagName("assetHandle");
        return nodes.getLength() > 0;
    }

    private boolean internalIsJobActive(Document document) {
        return document != null && document.getElementsByTagName("items").getLength() > 0;
    }

    @Override
    public String getFlashTemplatesServer(S7damConfigHosted s7Config) {
        String appSettingsTypeHandle = this.getApplicationPropertyHandle(s7Config);
        if (appSettingsTypeHandle == null) {
            return null;
        }
        Document document = this.s7damAPIClient.getPropertySets(appSettingsTypeHandle, s7Config);
        if (document != null) {
            NodeList list = document.getElementsByTagName("items");
            for (int i = 0; i < list.getLength(); ++i) {
                NodeList valueNodes;
                NodeList namesNodes = ((Element)list.item(i)).getElementsByTagName("name");
                if (namesNodes.getLength() <= 0 || !"application_server_xfl".equals(namesNodes.item(0).getFirstChild().getNodeValue()) || (valueNodes = ((Element)list.item(i)).getElementsByTagName("value")).getLength() <= 0 || valueNodes.item(0).getFirstChild() == null) continue;
                return valueNodes.item(0).getFirstChild().getNodeValue();
            }
        } else {
            LOG.error("getDynamicBannersServer, unexpected data format");
        }
        return null;
    }

    @Override
    public S7damAsset getAssociatedAssets(S7damAsset asset, S7damConfigHosted s7Config) {
        Document document;
        S7damAssetFactory assetFactory = new S7damAssetFactory();
        if (asset != null && (document = this.s7damAPIClient.getAssociatedAssets(asset.getAssetHandle(), null, null, s7Config)) != null) {
            asset = assetFactory.parseSubAssets(asset, document);
        }
        return asset;
    }

    @Override
    public String getFxgServer(S7damConfigHosted s7Config) {
        String fxgServer = null;
        Document document = this.s7damAPIClient.getSystemProperties(s7Config);
        if (document != null) {
            NodeList systemProperties = document.getElementsByTagName("systemProperty");
            for (int i = 0; i < systemProperties.getLength(); ++i) {
                Node systemProperty = systemProperties.item(i);
                String propertyName = DOMUtils.getNodeValue((Element)systemProperty, "name");
                if (!"FxgRenderRootUrl".equals(propertyName)) continue;
                fxgServer = DOMUtils.getNodeValue((Element)systemProperty, "value");
            }
        }
        return fxgServer;
    }

    @Override
    public List<S7damImagePreset> getImagePresets(S7damConfigHosted s7Config) {
        ArrayList<S7damImagePreset> list = new ArrayList<S7damImagePreset>();
        Document document = this.s7damAPIClient.getImagePresets(s7Config);
        if (document != null) {
            NodeList nl = document.getElementsByTagName("imageFormatArray");
            if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null) {
                NodeList nodeLst = ((Element)nl.item(0)).getElementsByTagName("items");
                for (int s = 0; s < nodeLst.getLength(); ++s) {
                    String name = null;
                    String handle = null;
                    String urlModifier = null;
                    NodeList itemNodes = ((Element)nodeLst.item(s)).getElementsByTagName("name");
                    if (itemNodes.getLength() > 0 && itemNodes.item(0).getFirstChild() != null) {
                        name = itemNodes.item(0).getFirstChild().getNodeValue();
                    }
                    if ((itemNodes = ((Element)nodeLst.item(s)).getElementsByTagName("imageFormatHandle")).getLength() > 0 && itemNodes.item(0).getFirstChild() != null) {
                        handle = itemNodes.item(0).getFirstChild().getNodeValue();
                    }
                    if ((itemNodes = ((Element)nodeLst.item(s)).getElementsByTagName("urlModifier")).getLength() > 0 && itemNodes.item(0).getFirstChild() != null) {
                        urlModifier = itemNodes.item(0).getFirstChild().getNodeValue();
                    }
                    list.add(new S7damImagePresetImpl(name, handle, urlModifier, null));
                }
            } else {
                LOG.error("getImagePresets, unexpected data format");
            }
        }
        return list;
    }

    @Override
    public String createFolder(String cqFolderPath, S7damConfigHosted s7Config) {
        try {
            String ipsUploadFilePath = s7Config.getRootPath() + cqFolderPath.replaceAll("^/content/dam/", "");
            Document document = this.s7damAPIClient.createFolder(ipsUploadFilePath, s7Config);
            return document.getElementsByTagName("folderHandle").item(0).getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            LOG.error("createFolder, failed to create s7dam folder: " + e.getMessage());
            return null;
        }
    }

    @Override
    public String renameFolder(String folderHandle, String newName, S7damConfigHosted s7Config) {
        try {
            this.s7damAPIClient.renameFolder(folderHandle, newName, s7Config);
            return "success";
        }
        catch (Exception e) {
            LOG.error("renameFolder, failed to rename s7dam folder: " + e.getMessage());
            return "failure";
        }
    }

    @Override
    public String renameAssetFilename(String assetHandle, String newName, S7damConfigHosted s7Config) {
        Boolean validateName = true;
        try {
            this.s7damAPIClient.renameAssetFilename(assetHandle, newName, validateName, s7Config);
            return "success";
        }
        catch (Exception e) {
            LOG.error("renameFolder, failed to Rename Assets: " + e.getMessage());
            return "failure";
        }
    }

    @Override
    public String moveAssets(Map<String, String> assetHandleMap, S7damConfigHosted s7Config) {
        try {
            this.s7damAPIClient.moveAssets(assetHandleMap, s7Config);
            return "success";
        }
        catch (Exception e) {
            LOG.error("moveAssets, failed to delete s7dam folder: " + e.getMessage());
            return "failure";
        }
    }

    @Override
    public S7damAsset getS7damAsset(String assetHandle, S7damConfigHosted s7Config) {
        try {
            List<S7damAsset> assets = this.getAssets(new String[]{assetHandle}, null, null, s7Config);
            if (assets.size() > 0) {
                S7damAsset s7damAsset = assets.get(0);
                if (s7damAsset.isPublished()) {
                    LOG.debug("image is available at /is/" + s7damAsset.getAssetTypeStr().toLowerCase() + "/" + s7damAsset.getName());
                    return s7damAsset;
                }
                LOG.debug("image is not yet published");
            }
        }
        catch (Exception e) {
            LOG.error("getAssetPublishPath, failed to get s7dam assets: " + e.getMessage());
        }
        return null;
    }

    @Override
    public Map<String, String> getSystemProperties(S7damConfigHosted s7Config) {
        HashMap<String, String> ret = new HashMap<String, String>();
        Document document = this.s7damAPIClient.getSystemProperties(s7Config);
        if (document != null) {
            NodeList systemProperties = document.getElementsByTagName("systemProperty");
            for (int i = 0; i < systemProperties.getLength(); ++i) {
                Node systemProperty = systemProperties.item(i);
                ret.put(DOMUtils.getNodeValue((Element)systemProperty, "name"), DOMUtils.getNodeValue((Element)systemProperty, "value"));
            }
        }
        return ret;
    }

    protected void bindS7damAPIClient(S7damAPIClient s7damAPIClient) {
        this.s7damAPIClient = s7damAPIClient;
    }

    protected void unbindS7damAPIClient(S7damAPIClient s7damAPIClient) {
        if (this.s7damAPIClient == s7damAPIClient) {
            this.s7damAPIClient = null;
        }
    }
}

