/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.hosted.jobs.impl;

import com.day.cq.dam.api.s7dam.config.S7damConfig;
import com.day.cq.dam.api.s7dam.config.S7damConfigResolver;
import com.day.cq.dam.api.s7dam.jobs.S7damExportService;
import com.day.cq.dam.s7dam.common.jobs.S7damJobsService;
import com.day.cq.dam.s7dam.hosted.constants.S7damJobType;
import com.day.cq.dam.s7dam.hosted.jobs.model.S7damJob;
import com.day.cq.dam.s7dam.hosted.jobs.model.S7damSubmitExportJobSettings;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE)
@Service
public class S7damExportServiceImpl
implements S7damExportService {
    private static final Logger LOG = LoggerFactory.getLogger(S7damExportServiceImpl.class);
    @Reference
    private S7damJobsService jobsService;
    @Reference
    private S7damConfigResolver s7configResolver;
    public static final Logger log = LoggerFactory.getLogger(S7damExportServiceImpl.class);

    public String export(Resource configResource, Set<String> assets, String imagePreset, String exportJobName) {
        S7damConfig s7Config = this.s7configResolver.getS7damConfig(null);
        String assetHandles = "";
        Node assetNode = null;
        Iterator<String> it = assets.iterator();
        while (it.hasNext()) {
            try {
                String asset = it.next();
                assetNode = (Node)configResource.getResourceResolver().getResource(asset + "/" + "jcr:content").adaptTo(Node.class);
                if (!assetNode.hasProperty("dam:s7damID")) continue;
                if (!assetHandles.equals("")) {
                    assetHandles = assetHandles + ",";
                }
                assetHandles = assetHandles + assetNode.getProperty("dam:s7damID").getString();
            }
            catch (RepositoryException e) {
                LOG.error("get asset handle: unable to get the asset handle from JCR {}", (Throwable)e);
            }
        }
        String jcrForJobsStatus = null;
        if (!assetHandles.equals("")) {
            S7damSubmitExportJobSettings settings = this.getS7damExportJobSettings(exportJobName, assetHandles.split(","), imagePreset);
            S7damJob job = null;
            job = this.jobsService.submitJob(S7damJobType.EXPORT_JOB.getValue(), settings, configResource, s7Config);
            for (Map.Entry<Object, Object> entry : job.getJobProperties().entrySet()) {
                String key = entry.getKey().toString();
                if (!key.equals(S7damJobType.JOB_JCR_NODE.getValue())) continue;
                jcrForJobsStatus = entry.getValue().toString();
                break;
            }
        }
        return jcrForJobsStatus;
    }

    public String pollToGetExportUrl(String jcrPath, Resource configResource) {
        String url = null;
        if (!jcrPath.endsWith("hosted/")) {
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            long delay = 1000L;
            try {
                Poller poller = new Poller(jcrPath, configResource);
                ScheduledFuture<String> future = executor.schedule(poller, delay, TimeUnit.MILLISECONDS);
                while (true) {
                    try {
                        while ((url = (String)future.get()).indexOf("http://") == -1) {
                            future = executor.schedule(poller, delay, TimeUnit.MILLISECONDS);
                        }
                        future = null;
                        executor.shutdown();
                        LOG.info("Polling job status from ({}) finished.", (Object)jcrPath);
                        return url;
                    }
                    catch (Exception e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                LOG.error("Polling was failed.", (Throwable)e);
            }
        }
        return url;
    }

    public boolean downloadAndExtractFiles(String fileLocation, List<String> fileNames, String imagePreset, ZipOutputStream zo) {
        boolean success = true;
        try {
            URL url = new URL(fileLocation);
            URLConnection con = url.openConnection();
            DataInputStream dis = new DataInputStream(con.getInputStream());
            byte[] fileData = new byte[con.getContentLength()];
            for (int x = 0; x < fileData.length; ++x) {
                fileData[x] = dis.readByte();
            }
            dis.close();
            ByteArrayInputStream is = new ByteArrayInputStream(fileData);
            ZipInputStream zipInputStream = new ZipInputStream(is);
            log.info(zipInputStream.toString());
            log.info("extracting zipfile contents from: [" + url + "]");
            ZipEntry origZipEntry = zipInputStream.getNextEntry();
            ZipEntry newZipEntry = null;
            while (origZipEntry != null) {
                if (!fileNames.contains(origZipEntry.getName())) {
                    log.error("The IPS asset doesn't match the DAM asset for downloading.");
                    return false;
                }
                newZipEntry = new ZipEntry(origZipEntry.getName() + "/cq5dam.dynamicmedia." + imagePreset + ".jpg");
                S7damExportServiceImpl.copyStream(zipInputStream, zo, newZipEntry);
                origZipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (MalformedURLException m) {
            log.error(m.toString());
            success = false;
        }
        catch (IOException io) {
            log.error(io.toString());
            success = false;
        }
        return success;
    }

    public void removeJobStatusNode(Resource configResource, String nodeNm) {
        try {
            ResourceResolver rr = configResource.getResourceResolver();
            Node targetNode = (Node)rr.getResource(nodeNm).adaptTo(Node.class);
            targetNode.remove();
            targetNode.getSession().save();
        }
        catch (RepositoryException e) {
            log.error("removeStatus: unable to remove jobs process status node {}", (Throwable)e);
        }
    }

    private static void copyStream(ZipInputStream in, ZipOutputStream out, ZipEntry entry) throws IOException {
        try {
            byte[] buffer = new byte[4096];
            int n = 0;
            out.putNextEntry(entry);
            while (-1 != (n = in.read(buffer))) {
                out.write(buffer, 0, n);
            }
        }
        catch (Exception e) {
            log.error(e.toString());
        }
    }

    private S7damSubmitExportJobSettings getS7damExportJobSettings(String jobName, String[] assetHandles, String imagePreset) {
        S7damSubmitExportJobSettings settings = new S7damSubmitExportJobSettings();
        settings.setJobName(jobName + "_" + new Date().toString().replaceAll(" ", "-"));
        settings.setMacro(imagePreset);
        settings.setAssetHandles(assetHandles);
        settings.setFmt(S7damJobType.JOB_EXPORT_FMT_CONVERT.getValue());
        settings.setEmailSetting(S7damJobType.SUBMIT_JOB_EMAILSETTING_JOBCOMPLETION.getValue());
        return settings;
    }

    protected void bindJobsService(S7damJobsService s7damJobsService) {
        this.jobsService = s7damJobsService;
    }

    protected void unbindJobsService(S7damJobsService s7damJobsService) {
        if (this.jobsService == s7damJobsService) {
            this.jobsService = null;
        }
    }

    protected void bindS7configResolver(S7damConfigResolver s7damConfigResolver) {
        this.s7configResolver = s7damConfigResolver;
    }

    protected void unbindS7configResolver(S7damConfigResolver s7damConfigResolver) {
        if (this.s7configResolver == s7damConfigResolver) {
            this.s7configResolver = null;
        }
    }

    private class Poller
    implements Callable<String> {
        private String path = null;
        private ResourceResolver rr = null;

        Poller(String jcrPath, Resource configResource) {
            this.path = jcrPath;
            this.rr = configResource.getResourceResolver();
        }

        @Override
        public String call() throws Exception {
            String status = null;
            try {
                Node jcrContent = (Node)this.rr.getResource(this.path).adaptTo(Node.class);
                String nodeNm = "status";
                status = jcrContent.getProperty(nodeNm).getString();
            }
            catch (RepositoryException e) {
                LOG.error("get jobs status: unable to get the job status from JCR {}", (Throwable)e);
            }
            log.debug("Polling job status.", status);
            return status;
        }
    }
}

