/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.hosted.jobs.impl;

import com.day.cq.dam.api.s7dam.config.S7damConfig;
import com.day.cq.dam.api.s7dam.config.S7damConfigHosted;
import com.day.cq.dam.s7dam.hosted.jobs.impl.S7damJobsServiceImpl;
import com.day.cq.dam.s7dam.hosted.jobs.model.S7damJob;
import com.day.cq.dam.s7dam.hosted.jobs.model.S7damJobSettings;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S7damJobsPoller {
    private static final Logger LOG = LoggerFactory.getLogger(S7damJobsPoller.class);
    private static final long delay = 3000L;
    private String jobEvtType;
    private String jobhandle;
    private String origNm;
    private S7damJobSettings jobSettings;
    private Resource configResource;
    private S7damConfigHosted config;

    public boolean processPollingService(String s7JobEvtType, String jobHandle, String origName, S7damJobSettings s7JobSettings, Resource configResource, S7damConfigHosted s7Config) {
        this.jobEvtType = s7JobEvtType;
        this.jobhandle = jobHandle != null ? jobHandle : "";
        this.origNm = origName != null ? origName : "";
        this.config = s7Config;
        this.configResource = configResource;
        this.jobSettings = s7JobSettings;
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        try {
            Poller poller = new Poller();
            ScheduledFuture<Boolean> future = executor.schedule(poller, 3000L, TimeUnit.MILLISECONDS);
            while (true) {
                try {
                    boolean done;
                    while (!(done = ((Boolean)future.get()).booleanValue())) {
                        future = executor.schedule(poller, 3000L, TimeUnit.MILLISECONDS);
                    }
                    future = null;
                    executor.shutdown();
                    LOG.info("Polling job ({}) finished.", (Object)this.jobEvtType);
                    return true;
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LOG.error("Polling was failed.", (Throwable)e);
            return false;
        }
    }

    private class Poller
    implements Callable<Boolean> {
        private int count = 0;

        private Poller() {
        }

        @Override
        public Boolean call() throws Exception {
            S7damJobsServiceImpl jobsSvc = new S7damJobsServiceImpl();
            List<S7damJob> jobs = jobsSvc.getJobs(S7damJobsPoller.this.jobEvtType, S7damJobsPoller.this.jobSettings, S7damJobsPoller.this.configResource, (S7damConfig)S7damJobsPoller.this.config);
            boolean statusChanged = jobsSvc.isJobStatusChanged(S7damJobsPoller.this.jobhandle, S7damJobsPoller.this.origNm, S7damJobsPoller.this.jobEvtType, jobs, S7damJobsPoller.this.configResource, (S7damConfig)S7damJobsPoller.this.config);
            LOG.debug("Polling job {0} {1} times.", (Object)(S7damJobsPoller.this.jobEvtType + statusChanged), (Object)this.count++);
            return statusChanged;
        }
    }
}

