/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.hosted.jobs.impl;

import com.day.cq.dam.api.s7dam.config.S7damConfig;
import com.day.cq.dam.api.s7dam.config.S7damConfigHosted;
import com.day.cq.dam.s7dam.common.jobs.S7damJobsService;
import com.day.cq.dam.s7dam.common.utils.DOMUtils;
import com.day.cq.dam.s7dam.hosted.constants.S7damJobType;
import com.day.cq.dam.s7dam.hosted.ips.S7damAPIClient;
import com.day.cq.dam.s7dam.hosted.jobs.impl.S7damJobsPoller;
import com.day.cq.dam.s7dam.hosted.jobs.model.S7damGetJobSettings;
import com.day.cq.dam.s7dam.hosted.jobs.model.S7damJob;
import com.day.cq.dam.s7dam.hosted.jobs.model.S7damJobSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.ObjectUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.JcrResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(policy=ConfigurationPolicy.REQUIRE)
@Service(value={S7damJobsService.class})
public class S7damJobsServiceImpl
implements S7damJobsService {
    private static final Logger LOG = LoggerFactory.getLogger(S7damJobsService.class);
    private static final String S7_JCR_CONTENT_PATH = "jcr:content";
    private static final String S7_JOBS_PATH = "jobs";
    private static final String S7_HOSTED_PATH = "hosted";
    private static final String S7_JOBS_PROP_NAME_STATUS = "status";
    private static final String S7_JOBS_PROP_INTERMEDIATENODETYPE = "nt:unstructured";
    private static final String S7_JOBS_PROP_NODETYPE = "nt:unstructured";
    @Reference
    private S7damAPIClient s7damAPIClient;

    @Override
    public List<S7damJob> getJobs(String jobReportType, S7damJobSettings settings, Resource configResource, S7damConfig s7Config) {
        List<S7damJob> jobs = new ArrayList<S7damJob>();
        try {
            if (s7Config != null && s7Config.isHosted()) {
                S7damConfigHosted s7ConfigHosted = (S7damConfigHosted)s7Config;
                if (jobReportType != null && jobReportType.length() > 0) {
                    Document doc = null;
                    Map<String, Object> jobSettings = settings.getJobSettings();
                    String jobHandleFlt = ObjectUtils.toString((Object)jobSettings.get(S7damJobType.JOB_JOBHANDLE.getValue()));
                    String origNameFlt = ObjectUtils.toString((Object)jobSettings.get(S7damJobType.JOB_ORIGNAME.getValue()));
                    String type = ObjectUtils.toString((Object)jobSettings.get(S7damJobType.JOB_GET_TYPE.getValue()));
                    if (jobReportType.equalsIgnoreCase(ObjectUtils.toString((Object)S7damJobType.JOB_HISTORICAL.getValue()))) {
                        doc = this.s7damAPIClient.getHistoricalJobs(jobSettings, s7ConfigHosted);
                    } else if (jobReportType.equalsIgnoreCase(S7damJobType.JOB_SCHEDULED.getValue().toString())) {
                        doc = this.s7damAPIClient.getScheduledJobs(jobSettings, s7ConfigHosted);
                    } else if (jobReportType.equalsIgnoreCase(S7damJobType.JOB_ACTIVE.getValue().toString())) {
                        doc = this.s7damAPIClient.getActiveJobs(ObjectUtils.toString((Object)jobSettings.get(S7damJobType.JOB_JOBHANDLE.getValue())), ObjectUtils.toString((Object)jobSettings.get(S7damJobType.JOB_ORIGNAME.getValue())), s7ConfigHosted);
                    } else if (jobReportType.equalsIgnoreCase(ObjectUtils.toString((Object)S7damJobType.JOB_DETAILS.getValue()))) {
                        doc = this.s7damAPIClient.getJobLogDetails(jobSettings, s7ConfigHosted);
                    }
                    jobs = this.parseJobs(doc, type, jobHandleFlt, origNameFlt);
                } else {
                    LOG.warn("getJobs, failed because the url request doesn't have parameter for the job log type.");
                }
            } else {
                LOG.warn("getJobs, failed on get s7 config.");
            }
        }
        catch (Exception e) {
            LOG.error("getJobs, failed on '" + jobReportType + "'" + e.getMessage());
        }
        return jobs;
    }

    private List<S7damJob> parseJobs(Document document, String typeFilter, String jobHandleFilter, String origNameFilter) {
        ArrayList<S7damJob> jobList = new ArrayList<S7damJob>();
        if (document != null) {
            NodeList jobItems = document.getElementsByTagName("items");
            LOG.debug("Found {} jobs!", (Object)jobItems.getLength());
            for (int i = 0; i < jobItems.getLength(); ++i) {
                Element itemJobElement = (Element)jobItems.item(i);
                S7damJob job = null;
                String jobType = itemJobElement.getParentNode().getNodeName();
                if (jobType.equals(S7damJobType.JOB_GET_RESULT_JOBLOGARRAY.getValue()) || jobType.equals(S7damJobType.JOB_GET_RESULT_JOBARRAY.getValue())) {
                    String orignm;
                    String jobHandle;
                    String logType;
                    if (typeFilter != null && (logType = DOMUtils.getNodeValue(itemJobElement, S7damJobType.JOB_GET_RESULT_LOGTYPE.getValue())).toLowerCase().indexOf(typeFilter) == -1 || jobHandleFilter != null && !jobHandleFilter.equals("") && !(jobHandle = DOMUtils.getNodeValue(itemJobElement, S7damJobType.JOB_JOBHANDLE.getValue())).equals(jobHandleFilter) || origNameFilter != null && !origNameFilter.equals("") && !(orignm = DOMUtils.getNodeValue(itemJobElement, S7damJobType.JOB_ORIGNAME.getValue())).equals(origNameFilter)) continue;
                    job = new S7damJob(this.parseJob(jobItems.item(i)));
                }
                if (job == null) continue;
                jobList.add(job);
            }
            LOG.debug("Successfully parsed {} S7damAssets.", (Object)jobList.size());
        } else {
            LOG.error("jobsObject, unexpected data format");
        }
        return jobList;
    }

    private Map<Object, Object> parseJob(Node jobNode) {
        HashMap<Object, Object> jobPropMap = new HashMap<Object, Object>();
        ArrayList<Map<Object, Object>> jobPropList = new ArrayList<Map<Object, Object>>();
        if (jobNode.hasChildNodes()) {
            NodeList childNodes = jobNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String nodeNm = childNodes.item(i).getNodeName();
                if (childNodes.item(i).getFirstChild() != null) {
                    if (childNodes.item(i).getFirstChild().getNodeName().equals("#text")) {
                        jobPropMap.put(nodeNm, childNodes.item(i).getFirstChild().getNodeValue());
                        continue;
                    }
                    Map<Object, Object> jobSubPropMap = this.parseJob(childNodes.item(i));
                    if (nodeNm.equals("items")) {
                        jobPropList.add(jobSubPropMap);
                        continue;
                    }
                    if (this.hasItemsAsSubLayers(nodeNm)) {
                        jobPropMap.putAll(jobSubPropMap);
                        continue;
                    }
                    jobPropMap.put(nodeNm, jobSubPropMap);
                    continue;
                }
                jobPropMap.put(nodeNm, childNodes.item(i).getNodeValue());
            }
            if (jobPropList.size() > 0) {
                jobPropMap.put(childNodes.item(0).getParentNode().getNodeName(), jobPropList);
            }
        }
        return jobPropMap;
    }

    private boolean hasItemsAsSubLayers(String nmSpace) {
        return nmSpace.equals(S7damJobType.JOB_GET_RESULT_AUXARRAY.getValue()) || nmSpace.equals(S7damJobType.JOB_GET_RESULT_DETAILARRAY.getValue()) || nmSpace.equals(S7damJobType.JOB_GET_RESULT_TASKPROGRESSARRAY.getValue()) || nmSpace.equals(S7damJobType.JOB_GET_RESULT_TASKITEMPROGRESSARRAY.getValue());
    }

    @Override
    public S7damJob submitJob(String submitJobType, S7damJobSettings settings, Resource configResource, S7damConfig s7Config) {
        S7damJob s7damJob = null;
        try {
            if (s7Config != null && s7Config.isHosted()) {
                S7damConfigHosted s7ConfigHosted = (S7damConfigHosted)s7Config;
                if (submitJobType != null && submitJobType.length() > 0) {
                    Map<String, Object> jobSettings = settings.getJobSettings();
                    if (submitJobType.equalsIgnoreCase(S7damJobType.EXPORT_JOB.getValue())) {
                        Document doc = this.s7damAPIClient.submitJob(jobSettings, s7ConfigHosted);
                        s7damJob = this.getSubmitResult(doc, s7Config);
                        String jobHandle = s7damJob.getJobHandle();
                        String origNm = (String)settings.getJobSettings().get(S7damJobType.JOB_JOBNAME.getValue());
                        String updateMsg = "start processing...";
                        this.updateJCRJobStatus(jobHandle, S7_JOBS_PROP_NAME_STATUS, updateMsg, configResource, s7Config);
                        if (this.startPollingThread(S7damJobType.JOB_SCHEDULED.getValue().toString(), jobHandle, origNm, configResource, s7ConfigHosted)) {
                            if (this.startPollingThread(S7damJobType.JOB_ACTIVE.getValue().toString(), jobHandle, origNm, configResource, s7ConfigHosted)) {
                                S7damJobSettings s7damJobSettings = this.getJobSettingsByNm(origNm);
                                List<S7damJob> jobs = this.getJobs(S7damJobType.JOB_DETAILS.getValue().toString(), s7damJobSettings, configResource, (S7damConfig)s7ConfigHosted);
                                String exportUrl = this.getExportDownloadURL(jobs);
                                LOG.info(exportUrl);
                                this.updateJCRJobStatus(jobHandle, S7_JOBS_PROP_NAME_STATUS, exportUrl, configResource, s7Config);
                            } else {
                                LOG.warn("submitJob, failed on get s7 config.");
                            }
                        } else {
                            LOG.error("Get export job download url failed.");
                        }
                    }
                }
            } else {
                LOG.warn("submitJob, failed on get s7 config.");
            }
        }
        catch (Exception e) {
            LOG.error("submitJob, failed on " + submitJobType + e.getMessage());
        }
        return s7damJob;
    }

    private S7damJob getSubmitResult(Document document, S7damConfig s7Config) {
        Element ele = (Element)document.getElementsByTagName(S7damJobType.SUBMIT_JOBRETURN.getValue()).item(0);
        String jobHandle = DOMUtils.getNodeValue(ele, S7damJobType.JOB_JOBHANDLE.getValue());
        HashMap<Object, Object> jobPropMap = new HashMap<Object, Object>();
        jobPropMap.put(S7damJobType.JOB_JOBHANDLE.getValue(), jobHandle);
        String jobNodePath = s7Config.getCloudConfigPath() + "/" + S7_JCR_CONTENT_PATH + "/" + S7_JOBS_PATH + "/" + S7_HOSTED_PATH + "/" + jobHandle.replace("|", "").replace(" ", "").replace(":", "");
        jobPropMap.put(S7damJobType.JOB_JCR_NODE.getValue(), jobNodePath);
        S7damJob s7damJob = new S7damJob(jobPropMap);
        return s7damJob;
    }

    public String getExportDownloadURL(List<S7damJob> jobs) {
        String exportUrl = "";
        for (int i = 0; i < jobs.size(); ++i) {
            for (Map.Entry<Object, Object> entry : jobs.get(i).getJobProperties().entrySet()) {
                List detailsList;
                String key = entry.getKey().toString();
                if (!key.equals(S7damJobType.JOB_GET_RESULT_DETAILARRAY.getValue()) || (detailsList = (List)entry.getValue()) == null || detailsList.size() == 0) continue;
                for (int j = 0; j < detailsList.size(); ++j) {
                    Map detail = (Map)detailsList.get(j);
                    if (detail == null || detail.size() == 0) continue;
                    Boolean isDone = false;
                    for (Map.Entry detailEntry : detail.entrySet()) {
                        String val;
                        int idx;
                        if (detailEntry.getKey().toString().equals(S7damJobType.JOB_GET_RESULT_LOGTYPE.getValue()) && detailEntry.getValue().toString().equals(S7damJobType.JOB_GET_RESULT_ZIPFILEEXPORTJOBDONE.getValue())) {
                            isDone = true;
                            if (!exportUrl.equals("")) {
                                return exportUrl;
                            }
                        }
                        if (!detailEntry.getKey().toString().equals(S7damJobType.JOB_GET_RESULT_LOGMESSAGE.getValue()) || (idx = (val = detailEntry.getValue().toString()).indexOf("http://")) == -1) continue;
                        exportUrl = val.substring(idx, val.length()).split(" ")[0];
                        if (!isDone.booleanValue()) continue;
                        return exportUrl;
                    }
                }
            }
        }
        return exportUrl;
    }

    public boolean startPollingThread(String s7JobEvtType, String jobHandle, String origName, Resource configResource, S7damConfigHosted s7Config) {
        String key = (jobHandle == null ? "" : jobHandle) + (origName == null ? "" : origName);
        if (!key.equals("")) {
            S7damJobSettings jobSettings = this.getJobSettingsByNm(origName);
            S7damJobsPoller poolingSvc = new S7damJobsPoller();
            return poolingSvc.processPollingService(s7JobEvtType, jobHandle, origName, jobSettings, configResource, s7Config);
        }
        LOG.error("Cannot poll jobs, there is no jobHandle or orignalName.");
        return false;
    }

    @Override
    public boolean isJobStatusChanged(String jobHandle, String origName, String s7JobEvtType, List<S7damJob> jobs, Resource configResource, S7damConfig s7Config) {
        for (int i = 0; i < jobs.size(); ++i) {
            for (Map.Entry<Object, Object> entry : jobs.get(i).getJobProperties().entrySet()) {
                if ((!entry.getKey().toString().equals((Object)S7damJobType.JOB_JOBHANDLE) || !entry.getValue().toString().contains(jobHandle)) && (!entry.getKey().toString().equals((Object)S7damJobType.JOB_ORIGNAME) || !entry.getValue().toString().equals(origName))) continue;
                String statusDesc = "";
                switch (S7damJobType.toS7damJobType(s7JobEvtType)) {
                    case JOB_SCHEDULED: {
                        statusDesc = "The job is scheduled to be processed immediately.";
                        break;
                    }
                    case JOB_ACTIVE: {
                        statusDesc = "The job is actived to be processed immediately.";
                        break;
                    }
                }
                this.updateJCRJobStatus(jobHandle, S7_JOBS_PROP_NAME_STATUS, statusDesc, configResource, s7Config);
                return false;
            }
        }
        return true;
    }

    private void updateJCRJobStatus(String jobHandle, String jcrPropNm, String jcrPropValue, Resource configResource, S7damConfig s7Config) {
        ResourceResolver rr = configResource.getResourceResolver();
        Session session = (Session)rr.adaptTo(Session.class);
        try {
            String jobsJcrPath = s7Config.getCloudConfigPath() + "/" + S7_JCR_CONTENT_PATH + "/" + S7_JOBS_PATH;
            javax.jcr.Node targetNode = this.validateNode(jobsJcrPath, rr, session);
            jobsJcrPath = jobsJcrPath + "/" + S7_HOSTED_PATH;
            targetNode = this.validateNode(jobsJcrPath, rr, session);
            jobsJcrPath = jobsJcrPath + "/" + jobHandle.replace("|", "").replace(" ", "").replace(":", "");
            targetNode = this.validateNode(jobsJcrPath, rr, session);
            targetNode.setProperty(jcrPropNm, jcrPropValue);
            targetNode.getSession().save();
        }
        catch (RepositoryException e) {
            LOG.error("updateStatus: unable to update jobs process status {}", (Throwable)e);
        }
    }

    private javax.jcr.Node validateNode(String nodeNm, ResourceResolver rr, Session session) {
        javax.jcr.Node node = null;
        Resource resource = rr.getResource(nodeNm);
        try {
            node = resource == null ? JcrResourceUtil.createPath((String)nodeNm, (String)"nt:unstructured", (String)"nt:unstructured", (Session)session, (boolean)true) : (javax.jcr.Node)rr.getResource(nodeNm).adaptTo(javax.jcr.Node.class);
        }
        catch (RepositoryException e) {
            LOG.error("updateStatus: unable to update jobs process status {}", (Throwable)e);
        }
        return node;
    }

    public S7damJobSettings getJobSettingsByNm(String origName) {
        S7damGetJobSettings settings = new S7damGetJobSettings();
        if (origName != null) {
            settings.setOrigName(origName);
        }
        return settings;
    }

    protected void bindS7damAPIClient(S7damAPIClient s7damAPIClient) {
        this.s7damAPIClient = s7damAPIClient;
    }

    protected void unbindS7damAPIClient(S7damAPIClient s7damAPIClient) {
        if (this.s7damAPIClient == s7damAPIClient) {
            this.s7damAPIClient = null;
        }
    }
}

