/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.hosted.model;

import com.day.cq.dam.s7dam.common.utils.DOMUtils;
import com.day.cq.dam.s7dam.hosted.constants.S7damAssetType;
import com.day.cq.dam.s7dam.hosted.model.S7damAsset;
import com.day.cq.dam.s7dam.hosted.model.S7damAssetImpl;
import com.day.cq.dam.s7dam.hosted.model.S7damAssetUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class S7damAssetFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(S7damAssetFactory.class);
    private static final String TRASH_STATE = "InTrash";

    public List<S7damAsset> parseAssets(Document document) {
        ArrayList<S7damAsset> assetList = new ArrayList<S7damAsset>();
        LOGGER.debug("Creating S7damAsset List from Document object...");
        if (document != null) {
            NodeList assetItems = document.getElementsByTagName("items");
            LOGGER.debug("Found {} assets!", (Object)assetItems.getLength());
            for (int i = 0; i < assetItems.getLength(); ++i) {
                S7damAsset asset;
                Element itemAssetElement = (Element)assetItems.item(i);
                String assetHandle = DOMUtils.getNodeValue(itemAssetElement, "assetHandle");
                if (StringUtils.isEmpty((String)assetHandle) || (asset = this.parseAsset(itemAssetElement)) == null) continue;
                assetList.add(asset);
            }
            LOGGER.debug("Successfully parsed {} S7damAssets.", (Object)assetList.size());
        }
        return assetList;
    }

    public S7damAsset parseAsset(Element element) {
        S7damAsset newS7damAsset = null;
        String trashState = DOMUtils.getNodeValue(element, "trashState");
        if (!TRASH_STATE.equalsIgnoreCase(trashState)) {
            String assetTypeString = DOMUtils.getNodeValue(element, "type");
            String subType = DOMUtils.getNodeValue(element, "subType");
            if (StringUtils.isNotEmpty((String)subType)) {
                assetTypeString = subType;
            }
            LOGGER.debug("Found {} asset type!", (Object)assetTypeString);
            S7damAssetType assetType = S7damAssetType.toS7damAssetType(assetTypeString);
            newS7damAsset = this.createAsset(element, assetType, assetTypeString);
            if (newS7damAsset == null) {
                LOGGER.error("Could not parse a S7damAsset from Item node content: {}", (Object)element.getTextContent());
            }
        }
        return newS7damAsset;
    }

    private S7damAsset createAsset(Element element, S7damAssetType assetType, String assetTypeString) {
        HashMap<Object, Object> s7damAssetPropertyMap = new HashMap<Object, Object>();
        Map<String, String> assetProperties = this.retrieveMetadataInformation(element);
        s7damAssetPropertyMap.put((Object)S7damAssetImpl.S7damAssetProperty.SCENE7_ASSET_TYPE, (Object)assetType);
        s7damAssetPropertyMap.put((Object)S7damAssetImpl.S7damAssetProperty.ASSET_TYPE_STRING, assetTypeString);
        s7damAssetPropertyMap.put((Object)S7damAssetImpl.S7damAssetProperty.NAME, DOMUtils.getNodeValue(element, "name"));
        s7damAssetPropertyMap.put((Object)S7damAssetImpl.S7damAssetProperty.ASSET_HANDLE, DOMUtils.getNodeValue(element, "assetHandle"));
        s7damAssetPropertyMap.put((Object)S7damAssetImpl.S7damAssetProperty.FILE_NAME, DOMUtils.getNodeValue(element, "fileName"));
        s7damAssetPropertyMap.put((Object)S7damAssetImpl.S7damAssetProperty.FOLDER, DOMUtils.getNodeValue(element, "folder"));
        s7damAssetPropertyMap.put((Object)S7damAssetImpl.S7damAssetProperty.FOLDER_HANDLE, DOMUtils.getNodeValue(element, "folderHandle"));
        s7damAssetPropertyMap.put((Object)S7damAssetImpl.S7damAssetProperty.CREATED_BY, DOMUtils.getNodeValue(element, "createUser"));
        s7damAssetPropertyMap.put((Object)S7damAssetImpl.S7damAssetProperty.MODIFIED_BY, DOMUtils.getNodeValue(element, "lastModifyUser"));
        s7damAssetPropertyMap.put((Object)S7damAssetImpl.S7damAssetProperty.CREATED_DATE, DOMUtils.getDateNodeValue(element, "created", "yyyy-MM-dd'T'HH:mm:ss.SSS"));
        s7damAssetPropertyMap.put((Object)S7damAssetImpl.S7damAssetProperty.MODIFIED_DATE, DOMUtils.getDateNodeValue(element, "lastModified", "yyyy-MM-dd'T'HH:mm:ss.SSS"));
        s7damAssetPropertyMap.put((Object)S7damAssetImpl.S7damAssetProperty.READY_TO_PUBLISH, DOMUtils.getNodeValue(element, "readyForPublish"));
        S7damAssetImpl asset = null;
        switch (assetType) {
            case FLASH: {
                LOGGER.debug("Found a Flash S7dam Asset");
                assetProperties.putAll(this.retrieveAssetInfo(element, "flashInfo"));
                break;
            }
            case TEMPLATE: {
                LOGGER.debug("Found a Template S7dam Asset");
                assetProperties.putAll(this.retrieveAssetInfo(element, "templateInfo"));
                break;
            }
            case IMAGE: {
                LOGGER.debug("Found an Image S7dam Asset");
                Map<String, String> imageAssetInfo = this.retrieveAssetInfo(element, "imageInfo");
                assetProperties.putAll(imageAssetInfo);
                s7damAssetPropertyMap.put((Object)S7damAssetImpl.S7damAssetProperty.WIDTH, S7damAssetUtils.parseLong(assetProperties.get("width")));
                s7damAssetPropertyMap.put((Object)S7damAssetImpl.S7damAssetProperty.HEIGHT, S7damAssetUtils.parseLong(assetProperties.get("height")));
                break;
            }
            case VIEWER_PRESET: {
                LOGGER.debug("Found Viewer Preset S7dam Asset");
                assetProperties.putAll(this.retrieveAssetInfo(element, "viewerPresetInfo"));
                Map<String, String> viewerPresetConfigurationSettings = this.retrieveViewerPresetInformation(element);
                s7damAssetPropertyMap.put((Object)S7damAssetImpl.S7damAssetProperty.VIEWER_PRESET_CONFIGURATION_SETTINGS, viewerPresetConfigurationSettings);
                break;
            }
            case VIDEO: {
                LOGGER.debug("Found a Video S7dam Asset");
                Map<String, String> videoAssetInfo = this.retrieveAssetInfo(element, "videoInfo");
                assetProperties.putAll(videoAssetInfo);
                s7damAssetPropertyMap.put((Object)S7damAssetImpl.S7damAssetProperty.WIDTH, S7damAssetUtils.parseLong(assetProperties.get("Video Width")));
                s7damAssetPropertyMap.put((Object)S7damAssetImpl.S7damAssetProperty.HEIGHT, S7damAssetUtils.parseLong(assetProperties.get("Video Height")));
                Map<String, String> attributeInfoMap = this.retrieveAttributeInformation((Element)element.getParentNode());
                s7damAssetPropertyMap.put((Object)S7damAssetImpl.S7damAssetProperty.VIDEO_ENCODING_PRESET_ID, attributeInfoMap.get("encoding.preset.id"));
                break;
            }
            case MASTER_VIDEO: {
                LOGGER.debug("Found a Master Video S7dam Asset");
                Map<String, String> masterVideoAssetInfo = this.retrieveAssetInfo(element, "masterVideoInfo");
                assetProperties.putAll(masterVideoAssetInfo);
                s7damAssetPropertyMap.put((Object)S7damAssetImpl.S7damAssetProperty.WIDTH, S7damAssetUtils.parseLong(assetProperties.get("Video Width")));
                s7damAssetPropertyMap.put((Object)S7damAssetImpl.S7damAssetProperty.HEIGHT, S7damAssetUtils.parseLong(assetProperties.get("Video Height")));
                break;
            }
        }
        s7damAssetPropertyMap.put((Object)S7damAssetImpl.S7damAssetProperty.ASSET_PROPERTIES, assetProperties);
        LOGGER.debug("Creating a S7dam Asset [assetTypeString={}]", (Object)assetTypeString);
        asset = new S7damAssetImpl(s7damAssetPropertyMap);
        return asset;
    }

    public S7damAsset parseSubAssets(S7damAsset asset, Document associatedAssetsDocument) {
        NodeList getAssociatedAssetsRootNodes;
        Element associatedAssetsRootElement = null;
        if (associatedAssetsDocument != null && (getAssociatedAssetsRootNodes = associatedAssetsDocument.getElementsByTagName("getAssociatedAssetsReturn")).getLength() > 0) {
            associatedAssetsRootElement = (Element)getAssociatedAssetsRootNodes.item(0);
        }
        if (asset != null && associatedAssetsRootElement != null) {
            NodeList memberArrayNodes = DOMUtils.getChildNodes(associatedAssetsRootElement, "memberArray/items");
            NodeList generatedArrayNodes = DOMUtils.getChildNodes(associatedAssetsRootElement, "generatedArray/items/generated");
            List<S7damAsset> subAssets = this.parseAssetsFromNodes(memberArrayNodes);
            subAssets.addAll(this.parseAssetsFromNodes(generatedArrayNodes));
            for (S7damAsset subAsset : subAssets) {
                asset.addSubAsset(subAsset);
            }
            NodeList originatorNodes = associatedAssetsDocument.getElementsByTagName("originator");
            if (originatorNodes.getLength() > 0) {
                Element originatorElement = (Element)originatorNodes.item(0);
                S7damAsset originatorAsset = this.parseAsset(originatorElement);
                asset.updateOriginatorAsset(originatorAsset);
            }
            LOGGER.debug("Sub-asset parsing report: found total {} sub-assets and generator[assetHandle={}] for assetHandle={}!", new Object[]{asset.getSubAssets().size(), asset.getOriginatorAsset() != null ? asset.getOriginatorAsset().getAssetHandle() : "none", asset.getAssetHandle()});
        }
        return asset;
    }

    private List<S7damAsset> parseAssetsFromNodes(NodeList nodes) {
        ArrayList<S7damAsset> assets = new ArrayList<S7damAsset>();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element nodeElement = (Element)nodes.item(i);
                S7damAsset parsedAsset = this.parseAsset(nodeElement);
                if (parsedAsset == null) continue;
                assets.add(parsedAsset);
            }
        }
        return assets;
    }

    private Map<String, String> retrieveViewerPresetInformation(Element element) {
        HashMap<String, String> configurationSettings = new HashMap<String, String>();
        if (element != null) {
            Element configSettingArray = (Element)element.getElementsByTagName("configSettingArray").item(0);
            configurationSettings.putAll(this.parseNameValueItems(configSettingArray));
        }
        return configurationSettings;
    }

    private Map<String, String> retrieveMetadataInformation(Element element) {
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        if (element != null) {
            Element metadataInformation = (Element)element.getElementsByTagName("metadataArray").item(0);
            metadataMap.putAll(this.parseNameValueItems(metadataInformation));
        }
        return metadataMap;
    }

    private Map<String, String> retrieveAttributeInformation(Element element) {
        HashMap<String, String> attributeArrayMap = new HashMap<String, String>();
        if (element != null) {
            Element metadataInformation = (Element)element.getElementsByTagName("attributeArray").item(0);
            attributeArrayMap.putAll(this.parseNameValueItems(metadataInformation));
        }
        return attributeArrayMap;
    }

    private Map<String, String> parseNameValueItems(Element nameValueItemsRoot) {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        if (nameValueItemsRoot != null) {
            NodeList configSettingsItems = nameValueItemsRoot.getElementsByTagName("items");
            for (int i = 0; i < configSettingsItems.getLength(); ++i) {
                Element configSettingElement = (Element)configSettingsItems.item(i);
                String name = DOMUtils.getNodeValue(configSettingElement, "name");
                String value = DOMUtils.getNodeValue(configSettingElement, "value");
                if (StringUtils.isEmpty((String)value)) {
                    value = DOMUtils.getNodeValue(configSettingElement, "handle");
                }
                valuesMap.put(name, value);
            }
        }
        return valuesMap;
    }

    private Map<String, String> retrieveAssetInfo(Element element, String assetInfoTag) {
        Element assetInfoRoot;
        HashMap<String, String> assetInfo = new HashMap<String, String>();
        if (element != null && StringUtils.isNotEmpty((String)assetInfoTag) && (assetInfoRoot = (Element)element.getElementsByTagName(assetInfoTag).item(0)) != null) {
            NodeList infoList = assetInfoRoot.getChildNodes();
            for (int i = 0; i < infoList.getLength(); ++i) {
                Node infoNode = infoList.item(i);
                if (infoNode.getNodeType() == 3) continue;
                Element infoElement = (Element)infoNode;
                String key = infoElement.getTagName();
                String value = DOMUtils.getNodeValue(assetInfoRoot, key);
                assetInfo.put(key, value);
            }
        }
        return assetInfo;
    }
}

