/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.hosted.model;

import com.day.cq.dam.s7dam.hosted.constants.S7damAssetType;
import com.day.cq.dam.s7dam.hosted.model.S7damAsset;
import com.day.cq.dam.s7dam.hosted.model.S7damAssetUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class S7damAssetImpl
implements S7damAsset {
    private static final long serialVersionUID = 5536087022446822682L;
    private Map<Object, Object> assetAttributes;

    public S7damAssetImpl(Map<Object, Object> assetAttributes) {
        this.assetAttributes = assetAttributes != null ? assetAttributes : new HashMap<Object, Object>();
        this.assetAttributes.put((Object)S7damAssetProperty.SUB_ASSETS, new ArrayList());
    }

    public S7damAssetImpl(S7damAsset s7damAsset, Map<Object, Object> overrideProperties) {
        Map<Object, Object> originalPropertyMap = this.getPropertiesMap(s7damAsset);
        if (overrideProperties != null) {
            originalPropertyMap.putAll(overrideProperties);
        }
        this.assetAttributes = originalPropertyMap;
    }

    @Override
    public S7damAssetType getAssetType() {
        return this.getProperty(this.assetAttributes, (Object)S7damAssetProperty.SCENE7_ASSET_TYPE, S7damAssetType.class);
    }

    @Override
    public String getAssetTypeStr() {
        return this.getProperty(this.assetAttributes, (Object)S7damAssetProperty.ASSET_TYPE_STRING, String.class);
    }

    @Override
    public String getName() {
        return this.getProperty(this.assetAttributes, (Object)S7damAssetProperty.NAME, String.class);
    }

    @Override
    public String getAssetHandle() {
        return this.getProperty(this.assetAttributes, (Object)S7damAssetProperty.ASSET_HANDLE, String.class);
    }

    @Override
    public String getFileName() {
        return this.getProperty(this.assetAttributes, (Object)S7damAssetProperty.FILE_NAME, String.class);
    }

    @Override
    public String getFolder() {
        return this.getProperty(this.assetAttributes, (Object)S7damAssetProperty.FOLDER, String.class);
    }

    @Override
    public String getFolderHandle() {
        return this.getProperty(this.assetAttributes, (Object)S7damAssetProperty.FOLDER_HANDLE, String.class);
    }

    @Override
    public String getCreatedBy() {
        return this.getProperty(this.assetAttributes, (Object)S7damAssetProperty.CREATED_BY, String.class);
    }

    @Override
    public String getModifiedBy() {
        return this.getProperty(this.assetAttributes, (Object)S7damAssetProperty.MODIFIED_BY, String.class);
    }

    @Override
    public Date getCreatedDate() {
        return this.getProperty(this.assetAttributes, (Object)S7damAssetProperty.CREATED_DATE, Date.class);
    }

    @Override
    public Date getModifiedDate() {
        return this.getProperty(this.assetAttributes, (Object)S7damAssetProperty.MODIFIED_DATE, Date.class);
    }

    @Override
    public String getOriginalFile() {
        return this.getAssetProperties().get("originalFile");
    }

    @Override
    public String getOriginalPath() {
        return this.getAssetProperties().get("originalPath");
    }

    @Override
    public List<S7damAsset> getSubAssets() {
        List subAssets = this.getProperty(this.assetAttributes, (Object)S7damAssetProperty.SUB_ASSETS, List.class);
        if (subAssets != null) {
            subAssets = Collections.unmodifiableList(subAssets);
        }
        return subAssets;
    }

    @Override
    public S7damAsset getOriginatorAsset() {
        return this.getProperty(this.assetAttributes, (Object)S7damAssetProperty.ORIGINATOR, S7damAsset.class);
    }

    @Override
    public void updateOriginatorAsset(S7damAsset originator) {
        this.assetAttributes.put((Object)S7damAssetProperty.ORIGINATOR, originator);
    }

    @Override
    public void addSubAsset(S7damAsset subAsset) {
        List subAssets = this.getProperty(this.assetAttributes, (Object)S7damAssetProperty.SUB_ASSETS, List.class);
        if (subAssets != null) {
            subAssets.add(subAsset);
        }
    }

    @Override
    public Long getWidth() {
        return (Long)this.assetAttributes.get((Object)S7damAssetProperty.WIDTH);
    }

    @Override
    public Long getHeight() {
        return (Long)this.assetAttributes.get((Object)S7damAssetProperty.HEIGHT);
    }

    @Override
    public String getUrlModifier() {
        return this.getAssetProperties().get("urlModifier");
    }

    @Override
    public Map<String, String> getViewerPresetConfigurationSettings() {
        return this.getProperty(this.assetAttributes, (Object)S7damAssetProperty.VIEWER_PRESET_CONFIGURATION_SETTINGS, Map.class);
    }

    @Override
    public String getViewerPresetType() {
        return this.getAssetProperties().get("type");
    }

    @Override
    public String getRootFolder() {
        int idx;
        String folder = this.getProperty(this.assetAttributes, (Object)S7damAssetProperty.FOLDER, String.class);
        if (folder != null && (idx = folder.indexOf("/")) > -1) {
            String root = folder.substring(0, idx + 1);
            if (!root.endsWith("/")) {
                root = root + "/";
            }
            return root;
        }
        return "";
    }

    @Override
    public boolean isPublished() {
        return Boolean.parseBoolean(this.getProperty(this.assetAttributes, (Object)S7damAssetProperty.READY_TO_PUBLISH, String.class));
    }

    @Override
    public Integer getFileSize() {
        return S7damAssetUtils.parseInt(this.getAssetProperties().get("fileSize"));
    }

    @Override
    public String getVideoEncodingPresetId() {
        return this.getProperty(this.assetAttributes, (Object)S7damAssetProperty.VIDEO_ENCODING_PRESET_ID, String.class);
    }

    private <T> T getProperty(Map<?, ?> map, Object key, Class<T> convertTo) {
        Object propValue = map.get(key);
        T convertedPropValue = null;
        if (propValue != null && convertTo.isAssignableFrom(propValue.getClass())) {
            convertedPropValue = convertTo.cast(propValue);
        }
        return convertedPropValue;
    }

    private Map<Object, Object> getPropertiesMap(S7damAsset s7damAsset) {
        HashMap<Object, Object> propertiesMap = new HashMap<Object, Object>();
        propertiesMap.put((Object)S7damAssetProperty.ASSET_TYPE_STRING, s7damAsset.getAssetTypeStr());
        propertiesMap.put((Object)S7damAssetProperty.SCENE7_ASSET_TYPE, (Object)s7damAsset.getAssetType());
        propertiesMap.put((Object)S7damAssetProperty.ASSET_HANDLE, s7damAsset.getAssetHandle());
        propertiesMap.put((Object)S7damAssetProperty.NAME, s7damAsset.getName());
        propertiesMap.put((Object)S7damAssetProperty.FILE_NAME, s7damAsset.getFileName());
        propertiesMap.put((Object)S7damAssetProperty.FOLDER, s7damAsset.getFolder());
        propertiesMap.put((Object)S7damAssetProperty.FOLDER_HANDLE, s7damAsset.getFolderHandle());
        propertiesMap.put((Object)S7damAssetProperty.CREATED_BY, s7damAsset.getCreatedBy());
        propertiesMap.put((Object)S7damAssetProperty.MODIFIED_BY, s7damAsset.getModifiedBy());
        propertiesMap.put((Object)S7damAssetProperty.VIDEO_ENCODING_PRESET_ID, s7damAsset.getVideoEncodingPresetId());
        propertiesMap.put((Object)S7damAssetProperty.CREATED_DATE, s7damAsset.getCreatedDate());
        propertiesMap.put((Object)S7damAssetProperty.MODIFIED_DATE, s7damAsset.getModifiedDate());
        propertiesMap.put((Object)S7damAssetProperty.ORIGINAL_FILE, s7damAsset.getOriginalFile());
        propertiesMap.put((Object)S7damAssetProperty.ORIGINAL_PATH, s7damAsset.getOriginalPath());
        propertiesMap.put((Object)S7damAssetProperty.WIDTH, s7damAsset.getWidth());
        propertiesMap.put((Object)S7damAssetProperty.HEIGHT, s7damAsset.getHeight());
        propertiesMap.put((Object)S7damAssetProperty.URL_MODIFIER, s7damAsset.getUrlModifier());
        propertiesMap.put((Object)S7damAssetProperty.READY_TO_PUBLISH, s7damAsset.isPublished());
        propertiesMap.put((Object)S7damAssetProperty.FILE_SIZE, s7damAsset.getFileSize());
        propertiesMap.put((Object)S7damAssetProperty.VIEWER_PRESET_TYPE, s7damAsset.getViewerPresetType());
        propertiesMap.put((Object)S7damAssetProperty.VIEWER_PRESET_CONFIGURATION_SETTINGS, s7damAsset.getViewerPresetConfigurationSettings());
        propertiesMap.put((Object)S7damAssetProperty.SUB_ASSETS, s7damAsset.getSubAssets());
        propertiesMap.put((Object)S7damAssetProperty.ORIGINATOR, s7damAsset.getOriginatorAsset());
        propertiesMap.put((Object)S7damAssetProperty.ASSET_PROPERTIES, s7damAsset.getAssetProperties());
        return propertiesMap;
    }

    @Override
    public Map<String, String> getAssetProperties() {
        return (Map)this.assetAttributes.get((Object)S7damAssetProperty.ASSET_PROPERTIES);
    }

    public static enum S7damAssetProperty {
        ASSET_TYPE_STRING,
        SCENE7_ASSET_TYPE,
        ASSET_HANDLE,
        NAME,
        FILE_NAME,
        FOLDER,
        FOLDER_HANDLE,
        CREATED_BY,
        MODIFIED_BY,
        VIDEO_ENCODING_PRESET_ID,
        CREATED_DATE,
        MODIFIED_DATE,
        ORIGINAL_FILE,
        ORIGINAL_PATH,
        WIDTH,
        HEIGHT,
        URL_MODIFIER,
        READY_TO_PUBLISH,
        FILE_SIZE,
        VIEWER_PRESET_TYPE,
        VIEWER_PRESET_CONFIGURATION_SETTINGS,
        SUB_ASSETS,
        ORIGINATOR,
        ASSET_PROPERTIES;

    }
}

