/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.hosted.model;

import com.day.cq.dam.s7dam.hosted.model.S7damFolderAssets;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class S7damAssetUtils {
    private static final Logger LOG = LoggerFactory.getLogger(S7damAssetUtils.class);

    private S7damAssetUtils() {
    }

    public static String getAbsoluteTargetPath(String rootPath, String targetPath, String s7damAssetFolderPath) {
        String path = null;
        if (rootPath != null && s7damAssetFolderPath != null && targetPath != null) {
            String adjRootPath = rootPath;
            String adjTargetPath = targetPath;
            if (!rootPath.endsWith("/")) {
                adjRootPath = rootPath + "/";
            }
            if (!targetPath.endsWith("/")) {
                adjTargetPath = targetPath + "/";
            }
            StringBuilder pathSB = new StringBuilder(adjTargetPath);
            pathSB.append(s7damAssetFolderPath.replaceFirst(adjRootPath, ""));
            path = pathSB.toString();
        }
        return path;
    }

    public static Integer parseInt(String string) {
        Integer value = null;
        try {
            value = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    public static Long parseLong(String string) {
        Long value = null;
        try {
            value = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    public static String getExtensionForFileReference(String fileReference) {
        String file;
        int index = fileReference.lastIndexOf("/");
        String extension = null;
        if (index != -1 && "".equals(extension = FilenameUtils.getExtension((String)(file = fileReference.substring(index + 1))))) {
            extension = null;
        }
        return extension;
    }

    public static List<S7damFolderAssets> getFolderAssetsList(Node parentNode, Boolean includeSubFolders) {
        ArrayList<S7damFolderAssets> folderAssetsList = new ArrayList<S7damFolderAssets>();
        S7damFolderAssets folderAssets = new S7damFolderAssets(parentNode);
        folderAssetsList.add(folderAssets);
        try {
            folderAssets.getAssets().addAll(S7damAssetUtils.addFolderAssets(parentNode));
            if (includeSubFolders.booleanValue()) {
                NodeIterator childNodes = parentNode.getNodes();
                while (childNodes.hasNext()) {
                    Node node = (Node)childNodes.next();
                    if (!S7damAssetUtils.isFolderNode(node)) continue;
                    folderAssetsList.addAll(S7damAssetUtils.getFolderAssetsList(node, includeSubFolders));
                }
            }
        }
        catch (RepositoryException e) {
            LOG.error("addSubFolderAssets failed with ", (Object)e.getMessage());
        }
        return folderAssetsList;
    }

    private static List<String> addFolderAssets(Node parentNode) {
        ArrayList<String> assetPaths = new ArrayList<String>();
        try {
            NodeIterator childNodes = parentNode.getNodes();
            while (childNodes.hasNext()) {
                Node node = (Node)childNodes.next();
                if (!S7damAssetUtils.isAssetNode(node)) continue;
                assetPaths.add(node.getPath());
            }
        }
        catch (RepositoryException e) {
            LOG.error("addFolderAssets failed with ", (Object)e.getMessage());
        }
        return assetPaths;
    }

    public static Node getOrAddNode(Node node, String name, String nodeType) throws RepositoryException {
        if (node.hasNode(name)) {
            return node.getNode(name);
        }
        return node.addNode(name, nodeType);
    }

    public static boolean isAssetNode(Node node) throws RepositoryException {
        return node.isNodeType("dam:Asset");
    }

    public static boolean isFolderNode(Node node) throws RepositoryException {
        return node.isNodeType("nt:folder");
    }
}

