/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.hosted.model;

import com.day.cq.dam.s7dam.common.utils.DOMUtils;
import com.day.cq.dam.s7dam.hosted.model.S7damFolder;
import com.day.cq.dam.s7dam.hosted.model.S7damFolderImpl;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class S7damFolderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(S7damFolderFactory.class);

    public S7damFolder parseS7damFolders(Document document) {
        S7damFolder s7RootFolder = null;
        if (document != null) {
            NodeList list = document.getElementsByTagName("folders");
            if (list.getLength() > 0) {
                Node rootFoldersNode = list.item(0);
                s7RootFolder = this.parseS7damFolderStructure((Element)rootFoldersNode);
            }
        } else {
            LOG.error("Unexpected data format while parsing the S7dam folders!");
        }
        return s7RootFolder;
    }

    private S7damFolder parseS7damFolderStructure(Element rootElement) {
        String folderHandle = DOMUtils.getNodeValue(rootElement, "folderHandle");
        String path = DOMUtils.getNodeValue(rootElement, "path");
        Date lastModifiedDate = DOMUtils.getDateNodeValue(rootElement, "childLastModified", "yyyy-MM-dd'T'HH:mm:ss.SSS");
        S7damFolderImpl s7Folder = new S7damFolderImpl(folderHandle, path, lastModifiedDate);
        NodeList subFolders = DOMUtils.getChildNodes(rootElement, "subfolderArray/items");
        if (subFolders != null) {
            for (int i = 0; i < subFolders.getLength(); ++i) {
                Element subFolderElement = (Element)subFolders.item(i);
                S7damFolder subFolder = this.parseS7damFolderStructure(subFolderElement);
                s7Folder.addSubFolder(subFolder);
            }
        }
        return s7Folder;
    }
}

