/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.hosted.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.s7dam.config.S7damConfig;
import com.day.cq.dam.api.s7dam.config.S7damConfigResolver;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.dam.s7dam.hosted.sync.S7damUploadService;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Property(name="process.label", value={"S7dam Upload"})
public class S7damUploadProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger LOG = LoggerFactory.getLogger(S7damUploadProcess.class);
    @Reference
    private S7damUploadService s7damUploadService;
    @Reference
    private S7damConfigResolver s7ConfigResolver;

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData) throws WorkflowException {
        block7: {
            Session session = workflowSession.getSession();
            Resource payloadResource = this.getResourceFromPayload(workItem, session);
            if (payloadResource != null) {
                MetaDataMap workflowMetaDataMap = workItem.getWorkflow().getWorkflowData().getMetaDataMap();
                ResourceResolver resolver = this.getResourceResolver(session);
                String payloadResourcePath = payloadResource.getPath();
                try {
                    session.save();
                    String[] args = this.buildArguments(workflowMetaDataMap);
                    List argsValues = this.getValuesFromArgs(Arguments.PAGE_CC_PATH.argumentName, args);
                    S7damConfig s7Config = argsValues.size() == 1 ? this.s7ConfigResolver.getS7damConfig((String)argsValues.get(0)) : this.s7ConfigResolver.getS7damConfig(null);
                    if (s7Config != null) {
                        try {
                            this.upload(payloadResource, s7Config.getCloudConfigPath(), resolver);
                        }
                        catch (Exception e) {
                            LOG.error("Cannot check S7dam Polling Importer marker status for asset " + payloadResourcePath, (Throwable)e);
                        }
                        break block7;
                    }
                    LOG.warn("Not uploading file to S7dam scene7 config is not defined");
                }
                catch (Exception e) {
                    LOG.error("Error during asset lock / unlock for " + payloadResourcePath, (Throwable)e);
                }
            } else {
                LOG.error("Failed to obtain a valid DAM asset from upload workflow payload!");
            }
        }
    }

    private Resource getResourceFromPayload(WorkItem workItem, Session session) {
        Resource payloadResource = null;
        try {
            Asset damAsset = this.getAssetFromPayload(workItem, session);
            if (damAsset != null) {
                payloadResource = (Resource)damAsset.adaptTo(Resource.class);
            } else {
                Node nodeResource = this.getNodeFromPayload(workItem, session);
                ResourceResolver rr = this.getResourceResolver(session);
                payloadResource = rr.getResource(nodeResource.getPath());
            }
        }
        catch (Exception e) {
            LOG.error("Could not get the resource from the payload!", (Throwable)e);
        }
        return payloadResource;
    }

    private boolean isFolder(Resource resource) {
        boolean isResourceFolder = false;
        if (resource != null) {
            isResourceFolder = "sling:OrderedFolder".equals(resource.getResourceType());
        }
        return isResourceFolder;
    }

    private void upload(Resource resource, String configPath, ResourceResolver resolver) {
        if (DamUtil.isAsset((Resource)resource)) {
            this.s7damUploadService.uploadFile(resource.getPath(), configPath, resolver);
        } else if (this.isFolder(resource)) {
            this.s7damUploadService.uploadFolder(resource.getPath(), configPath, resolver);
        }
    }

    private String[] buildArguments(MetaDataMap metaData) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (Arguments argument : Arguments.values()) {
            String argumentValue = (String)metaData.get(argument.argumentName, String.class);
            if (!StringUtils.isNotBlank((String)argumentValue)) continue;
            arguments.add(argument.getArgumentPrefix() + argumentValue);
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    protected void bindS7damUploadService(S7damUploadService s7damUploadService) {
        this.s7damUploadService = s7damUploadService;
    }

    protected void unbindS7damUploadService(S7damUploadService s7damUploadService) {
        if (this.s7damUploadService == s7damUploadService) {
            this.s7damUploadService = null;
        }
    }

    protected void bindS7ConfigResolver(S7damConfigResolver s7damConfigResolver) {
        this.s7ConfigResolver = s7damConfigResolver;
    }

    protected void unbindS7ConfigResolver(S7damConfigResolver s7damConfigResolver) {
        if (this.s7ConfigResolver == s7damConfigResolver) {
            this.s7ConfigResolver = null;
        }
    }

    public static enum Arguments {
        PAGE_CC_PATH("pageCloudConfigPath"),
        IS_INTERACTIVE_UPLOAD_ARGUMENT("isInteractiveUpload");

        private String argumentName;

        private Arguments(String argumentName) {
            this.argumentName = argumentName;
        }

        public String getArgumentPrefix() {
            return this.argumentName + ":";
        }
    }
}

