/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.hosted.servlets;

import com.day.cq.dam.s7dam.hosted.ips.S7damService;
import com.day.cq.i18n.I18n;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"dam/components/s7dam/s7damPage"}), @Property(name="sling.servlet.selectors", value={"companies"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.methods", value={"POST"})})
public class S7damServlet
extends SlingAllMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(S7damServlet.class);
    private static final String PARAMETER_EMAIL = "email";
    private static final String PARAMETER_PASSWORD = "password";
    private static final String PARAMETER_REGION = "region";
    @Reference
    private S7damService s7damService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        I18n i18n = new I18n((HttpServletRequest)request);
        String email = request.getParameter(PARAMETER_EMAIL);
        String password = request.getParameter(PARAMETER_PASSWORD);
        String region = request.getParameter(PARAMETER_REGION);
        JSONObject jsonResponse = new JSONObject();
        try {
            if (StringUtils.isNotEmpty((String)email) && StringUtils.isNotEmpty((String)password) && StringUtils.isNotEmpty((String)region)) {
                String userHandle = this.s7damService.getUserHandle(email, password, region);
                if (userHandle != null) {
                    String companies = this.s7damService.getCompanyMembership(userHandle, email, password, region);
                    if (companies.startsWith("failed")) {
                        jsonResponse.put("error", (Object)i18n.get("Getting company list from S7dam failed."));
                        LOG.error("Getting company list from S7dam failed.");
                    } else {
                        jsonResponse.put("userHandle", (Object)userHandle);
                        JSONArray companiesArray = new JSONArray(companies);
                        jsonResponse.put("companies", (Object)companiesArray);
                    }
                } else {
                    jsonResponse.put("error", (Object)i18n.get("Login to S7dam failed. Please check the error log for more details."));
                    LOG.error("Login to S7dam failed.");
                }
            } else {
                jsonResponse.put("error", (Object)i18n.get("Please input all needed data in order to create an S7dam connection."));
                LOG.error("Not all S7dam connection parameters were supplied.");
            }
        }
        catch (JSONException e) {
            LOG.error("Error creating JSON response", (Throwable)e);
        }
        finally {
            out.write(jsonResponse.toString());
        }
    }

    protected void bindS7damService(S7damService s7damService) {
        this.s7damService = s7damService;
    }

    protected void unbindS7damService(S7damService s7damService) {
        if (this.s7damService == s7damService) {
            this.s7damService = null;
        }
    }
}

