/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.hosted.sync;

import com.day.cq.dam.api.s7dam.config.S7damConfigHosted;
import com.day.cq.dam.s7dam.hosted.ips.S7damService;
import com.day.cq.dam.s7dam.hosted.sync.S7damPublisher;
import com.day.cq.dam.scene7.api.Scene7EndpointsManager;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S7damPublishingJob
implements Runnable {
    private static final int MAX_POLLING_ATTEMPTS = 120;
    private static final String IMAGE_SERVING_PUBLISH_JOB = "imageServingPublishJob";
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private S7damConfigHosted s7Config;
    private String path;
    private long timestamp;
    private long publishStartTimestamp;
    private String name;
    private S7damPublisher publisher;
    private State state;
    private Map<String, String> statusPublishQueryMap;
    private ResourceResolver resolver;
    private QueryBuilder queryBuilder;
    private S7damService s7damService;
    private Scene7EndpointsManager scene7EndpointsManager;
    private boolean shouldRepublish;
    private String s7damJobName;
    private int attempts;

    public S7damPublishingJob(S7damPublisher publisher, S7damConfigHosted s7Config, String path, Map<String, String> statusPublishQueryMap, ResourceResolver resolver, QueryBuilder queryBuilder, S7damService s7damService, Scene7EndpointsManager scene7EndpointsManager) {
        this.publisher = publisher;
        this.path = path;
        this.timestamp = System.currentTimeMillis();
        this.statusPublishQueryMap = statusPublishQueryMap;
        this.resolver = resolver;
        this.queryBuilder = queryBuilder;
        this.s7Config = s7Config;
        this.s7damService = s7damService;
        this.scene7EndpointsManager = scene7EndpointsManager;
        this.shouldRepublish = false;
        this.attempts = 0;
        this.name = "s7dam publishing job " + this.s7Config.getEmail() + " " + this.timestamp;
    }

    public void updateTimestamp() {
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public void run() {
        try {
            if (this.state == State.QUEUED) {
                if (this.publisher.isPublishJobActive(IMAGE_SERVING_PUBLISH_JOB, this.s7Config)) {
                    return;
                }
                this.state = State.PUBLISHING;
                this.shouldRepublish = false;
                this.LOG.debug("Do image publish for email '" + this.s7Config.getEmail() + "' and company '" + this.s7Config.getCompanyHandle() + "' to '" + this.scene7EndpointsManager.getAPIServer(this.s7Config.getRegion()) + "'");
                this.s7damJobName = this.publisher.startPublishJob(this.path, this.s7Config);
                if (this.s7damJobName == null) {
                    this.LOG.warn("starting Publish Job failed");
                    this.state = State.FAILED;
                    this.updatePublishStatus(this.statusPublishQueryMap, this.resolver, this.publishStartTimestamp, "UploadFailed");
                    this.publisher.removeJob(this.name);
                } else {
                    this.publishStartTimestamp = System.currentTimeMillis();
                }
            } else if (this.state == State.PUBLISHING && this.s7damJobName != null) {
                ++this.attempts;
                if (!this.s7damService.isJobActiveByOriginalName(this.s7damJobName, this.s7Config)) {
                    Boolean publishSucceeded = this.publisher.isPublishJobSuccessByOrignalName(this.s7damJobName, this.s7Config);
                    String publishState = publishSucceeded != false ? "PublishComplete" : "UploadFailed";
                    this.updatePublishStatus(this.statusPublishQueryMap, this.resolver, this.publishStartTimestamp, publishState);
                    if (this.shouldRepublish) {
                        this.state = State.QUEUED;
                        this.attempts = 0;
                    } else {
                        this.state = State.PUBLISHED;
                        this.publisher.removeJob(this.name);
                    }
                } else if (this.attempts > 120) {
                    this.LOG.warn("publish job failed to finish successful for handle " + this.s7damJobName);
                    this.state = State.FAILED;
                    this.publisher.removeJob(this.name);
                }
            }
        }
        catch (Exception e) {
            this.LOG.error("Error while publishing", (Throwable)e);
        }
    }

    protected void updatePublishStatus(Map<String, String> statusQueryMap, ResourceResolver rr, long pubTime, String pubState) {
        try {
            if (statusQueryMap.isEmpty() || rr == null || !"PublishStart".equals(pubState) && !"PublishComplete".equals(pubState)) {
                return;
            }
            HashMap<String, String> map = new HashMap<String, String>(statusQueryMap);
            map.put("path", "/content/dam");
            map.put("daterange.property", "dam:s7damUploadTimeStamp");
            map.put("daterange.upperBound", Long.toString(pubTime));
            map.put("3_property", "dam:s7damFileStatus");
            map.put("3_property.value", "PublishQueued");
            Session session = (Session)rr.adaptTo(Session.class);
            Query query = this.queryBuilder.createQuery(PredicateGroup.create(map), session);
            query.setHitsPerPage(0L);
            query.setStart(0L);
            SearchResult result = query.getResult();
            this.LOG.debug("asset publish pending matches ", (Object)result.getTotalMatches());
            for (Hit hit : result.getHits()) {
                String foundPath = "";
                try {
                    foundPath = hit.getPath();
                    Node jcrContent = (Node)rr.getResource(foundPath).adaptTo(Node.class);
                    jcrContent.setProperty("dam:s7damFileStatus", pubState);
                    jcrContent.getSession().save();
                    this.LOG.debug("Publish S7dam file status to " + pubState + " for path " + foundPath);
                }
                catch (Exception e) {
                    this.LOG.error("Exception when updating state to " + pubState + " s7 file status to path " + foundPath, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.LOG.error("update Publish Status failed ", (Object)e.getMessage());
        }
    }

    public boolean equals(S7damPublishingJob other) {
        return other.s7Config.getCompanyHandle().equals(this.s7Config.getCompanyHandle()) && other.scene7EndpointsManager.getAPIServer(other.s7Config.getRegion()).equals(this.scene7EndpointsManager.getAPIServer(this.s7Config.getRegion()));
    }

    public String getName() {
        return this.name;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setShouldRepublish(boolean shouldRepublish) {
        this.LOG.debug("Publish job setShouldRepublish ", (Object)shouldRepublish);
        this.shouldRepublish = shouldRepublish;
    }

    public static enum State {
        QUEUED,
        PUBLISHING,
        PUBLISHED,
        FAILED;

    }
}

