/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.hosted.sync.impl;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.s7dam.config.S7damConfig;
import com.day.cq.dam.api.s7dam.config.S7damConfigHosted;
import com.day.cq.dam.s7dam.common.sync.S7damAssetSyncService;
import com.day.cq.dam.s7dam.hosted.ips.S7damService;
import com.day.cq.dam.s7dam.hosted.model.S7damAssetUtils;
import com.day.cq.dam.s7dam.hosted.model.S7damFolderAssets;
import com.day.cq.dam.s7dam.hosted.sync.S7damFileMetadataService;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE)
@Service(value={S7damAssetSyncService.class})
public class S7damAssetSyncServiceImpl
implements S7damAssetSyncService {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    @Reference
    private S7damService s7damService;
    @Reference
    private S7damFileMetadataService s7damFileMetadataService;
    @Reference(policy=ReferencePolicy.STATIC)
    private ResourceResolverFactory resolverFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String moveFolder(String dstPath, String srcPath, S7damConfig s7Config) {
        ResourceResolver resolver = this.getAdminResourceResolver();
        if (!s7Config.isOnPrem() || resolver == null) {
            this.LOG.error("improper cloud configuration");
            return "failed";
        }
        S7damConfigHosted s7damConfigHosted = (S7damConfigHosted)s7Config;
        String dstPathParent = StringUtils.substringBeforeLast((String)dstPath, (String)"/");
        String srcPathParent = StringUtils.substringBeforeLast((String)srcPath, (String)"/");
        String result = "success";
        try {
            String folderHandle = this.s7damService.getFolderHandle(srcPath, s7damConfigHosted);
            if (dstPathParent.equals(srcPathParent)) {
                result = this.s7damService.renameFolder(folderHandle, StringUtils.substringAfterLast((String)dstPath, (String)"/"), s7damConfigHosted);
            } else if ("success".equals(this.moveFolder(dstPath, s7damConfigHosted, resolver))) {
                this.deleteFolder(srcPath, s7Config);
            } else {
                result = "failed";
            }
        }
        catch (Exception e) {
            this.LOG.error("Unable to move folder for path (" + dstPath + ")", (Throwable)e);
            result = "failed";
        }
        finally {
            if (resolver != null && resolver.isLive()) {
                resolver.close();
            }
        }
        return result;
    }

    private String moveFolder(String dstPath, S7damConfigHosted s7Config, ResourceResolver resolver) {
        String result = "success";
        int maxBatchMoveItems = 500;
        Node folderNode = (Node)resolver.getResource(dstPath).adaptTo(Node.class);
        List<S7damFolderAssets> folderAssetsList = S7damAssetUtils.getFolderAssetsList(folderNode, true);
        try {
            for (S7damFolderAssets folder : folderAssetsList) {
                HashMap<String, String> batchMoveHandleMap = new HashMap<String, String>();
                String dstPathFolderHandle = this.getFolderHandle(folder.getFolderNode().getPath(), s7Config);
                if (dstPathFolderHandle == null) {
                    this.LOG.error("Skipping folder during batch move operation : cannot create scene7 folder for " + folder.getFolderNode().getPath());
                    continue;
                }
                for (String path : folder.getAssets()) {
                    String assetHandle = null;
                    Node jcrContent = (Node)resolver.getResource(path + "/" + "jcr:content").adaptTo(Node.class);
                    if (jcrContent.hasProperty("dam:s7damID")) {
                        assetHandle = jcrContent.getProperty("dam:s7damID").getString();
                    }
                    if (assetHandle != null) {
                        batchMoveHandleMap.put(assetHandle, dstPathFolderHandle);
                        if (batchMoveHandleMap.size() != 500) continue;
                        String batchMoveStatus = this.s7damService.moveAssets(batchMoveHandleMap, s7Config);
                        if ("failed".equals(batchMoveStatus)) {
                            this.LOG.warn("unable to batch move some folders eg. ", (Object)folder.getFolderNode().getPath());
                        }
                        batchMoveHandleMap.clear();
                        continue;
                    }
                    this.LOG.error("Skipping asset in batch move operation : asset does not exist on S7 for " + path);
                }
                if (batchMoveHandleMap.size() <= 0) continue;
                this.s7damService.moveAssets(batchMoveHandleMap, s7Config);
            }
        }
        catch (Exception e) {
            this.LOG.error("Error in moveFolder" + e.getMessage());
            result = "failed";
        }
        return result;
    }

    @Override
    public String deleteFolder(String srcPath, S7damConfig s7Config) {
        if (!s7Config.isOnPrem()) {
            this.LOG.error("improper cloud configuration");
            return "failed";
        }
        S7damConfigHosted s7damConfigHosted = (S7damConfigHosted)s7Config;
        try {
            String folderHandle = this.s7damService.getFolderHandle(srcPath, s7damConfigHosted);
            return this.deleteFolderByHandle(folderHandle, s7damConfigHosted);
        }
        catch (Exception e) {
            this.LOG.error("error processing deleteFolder: " + e.getMessage());
            return "failed";
        }
    }

    private String deleteFolderByHandle(String folderHandle, S7damConfigHosted s7damConfig) {
        try {
            if (s7damConfig != null && folderHandle != null) {
                return this.s7damService.deleteFolder(folderHandle, s7damConfig);
            }
        }
        catch (Exception e) {
            this.LOG.error("error processing deleteFolderByHandle: " + e.getMessage());
        }
        return "failed";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String moveFile(String dstPath, String srcPath, S7damConfig s7Config) {
        String dstPathParent = StringUtils.substringBeforeLast((String)dstPath, (String)"/");
        String srcPathParent = StringUtils.substringBeforeLast((String)srcPath, (String)"/");
        String srcAssetName = StringUtils.substringAfterLast((String)srcPath, (String)"/");
        String dstAssetName = StringUtils.substringAfterLast((String)dstPath, (String)"/");
        ResourceResolver resolver = this.getAdminResourceResolver();
        if (!s7Config.isOnPrem() || resolver == null) {
            this.LOG.error("improper cloud configuration");
            return "failed";
        }
        S7damConfigHosted s7damConfigHosted = (S7damConfigHosted)s7Config;
        try {
            String assetHandle = null;
            Node jcrContent = (Node)resolver.getResource(dstPath + "/" + "jcr:content").adaptTo(Node.class);
            if (jcrContent.hasProperty("dam:s7damID")) {
                assetHandle = jcrContent.getProperty("dam:s7damID").getString();
            }
            if (assetHandle != null) {
                if (dstPathParent.equals(srcPathParent)) {
                    Asset damAsset = (Asset)resolver.getResource(dstPath).adaptTo(Asset.class);
                    String status = this.s7damService.renameAssetFilename(assetHandle, StringUtils.substringAfterLast((String)dstPath, (String)"/"), s7damConfigHosted);
                    if ("success".equals(status)) {
                        this.s7damFileMetadataService.setAssetMetadataOnSync(damAsset, this.s7damService.getS7damAsset(assetHandle, s7damConfigHosted), s7damConfigHosted, "PublishComplete");
                    }
                    String string = status;
                    return string;
                }
                String dstPathFolderHandle = this.getFolderHandle(dstPathParent, s7damConfigHosted);
                if (dstPathFolderHandle != null) {
                    HashMap<String, String> moveAssetsHandleMap = new HashMap<String, String>();
                    moveAssetsHandleMap.put(assetHandle, dstPathFolderHandle);
                    String status = this.s7damService.moveAssets(moveAssetsHandleMap, s7damConfigHosted);
                    if ("success".equals(status) && !srcAssetName.equals(dstAssetName)) {
                        status = this.s7damService.renameAssetFilename(assetHandle, StringUtils.substringAfterLast((String)dstPath, (String)"/"), s7damConfigHosted);
                    }
                    String string = status;
                    return string;
                }
                this.LOG.warn("Unable to move s7dam managed asset - missing parent folder handle for :" + dstAssetName);
            } else {
                this.LOG.warn("Unable to move s7dam managed asset due to missing asset handle for :" + dstAssetName);
            }
        }
        catch (Exception e) {
            this.LOG.error("Error accessing S7 ref to metadata S7dam Asset ID" + e.getMessage());
        }
        finally {
            if (resolver != null && resolver.isLive()) {
                resolver.close();
            }
        }
        return "failed";
    }

    private synchronized String getFolderHandle(String path, S7damConfigHosted s7Config) {
        String folderHandle = this.s7damService.getFolderHandle(path, s7Config);
        try {
            if (folderHandle == null) {
                folderHandle = this.s7damService.createFolder(path, s7Config);
                this.wait(10000L);
            }
        }
        catch (InterruptedException e) {
            this.LOG.error("Error waiting on create folder" + e.getMessage());
        }
        return folderHandle;
    }

    @Override
    public String deleteFile(String srcPath, S7damConfig s7Config) {
        return "failed";
    }

    @Override
    public String updatePublishedAsset(String srcPath, S7damConfig s7Config) {
        return "failed";
    }

    @Override
    public String updateAsset(String srcPath, S7damConfig s7Config) {
        return "failed";
    }

    private ResourceResolver getAdminResourceResolver() {
        try {
            return this.resolverFactory.getAdministrativeResourceResolver(null);
        }
        catch (LoginException e) {
            this.LOG.error("Failed to obtain administrative ResourceResolver [{}]", (Object)e.getMessage());
            return null;
        }
    }

    protected void bindS7damService(S7damService s7damService) {
        this.s7damService = s7damService;
    }

    protected void unbindS7damService(S7damService s7damService) {
        if (this.s7damService == s7damService) {
            this.s7damService = null;
        }
    }

    protected void bindS7damFileMetadataService(S7damFileMetadataService s7damFileMetadataService) {
        this.s7damFileMetadataService = s7damFileMetadataService;
    }

    protected void unbindS7damFileMetadataService(S7damFileMetadataService s7damFileMetadataService) {
        if (this.s7damFileMetadataService == s7damFileMetadataService) {
            this.s7damFileMetadataService = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }
}

