/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.hosted.sync.impl;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.s7dam.config.S7damConfigHosted;
import com.day.cq.dam.s7dam.hosted.model.S7damAsset;
import com.day.cq.dam.s7dam.hosted.sync.S7damFileMetadataService;
import com.day.cq.dam.scene7.api.Scene7EndpointsManager;
import java.util.Calendar;
import javax.jcr.Node;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;

@Component
@Service
public class S7damFileMetadataServiceImpl
implements S7damFileMetadataService {
    @Reference
    private Scene7EndpointsManager scene7EndpointsManager;

    @Override
    public void setAssetMetadataProperty(Asset asset, String propertyName, Object propertyValue) throws Exception {
        Resource resource = (Resource)asset.adaptTo(Resource.class);
        Node node = (Node)resource.adaptTo(Node.class);
        if (node != null) {
            Node metadata = node.getNode("jcr:content");
            JcrUtil.setProperty((Node)metadata, (String)propertyName, (Object)propertyValue);
        }
    }

    @Override
    public void setAssetMetadataOnSync(Asset asset, S7damAsset s7damAsset, S7damConfigHosted s7Config, String status) throws Exception {
        this.setAssetMetadataProperty(asset, "dam:s7damID", s7damAsset.getAssetHandle());
        String publishedServer = s7Config.getPublishServer();
        if (!publishedServer.endsWith("/")) {
            publishedServer = publishedServer + "/";
        }
        this.setAssetMetadataProperty(asset, "dam:s7damName", s7damAsset.getName());
        this.setAssetMetadataProperty(asset, "dam:s7damType", s7damAsset.getAssetType().getValue());
        this.setAssetMetadataProperty(asset, "dam:s7damFile", s7damAsset.getRootFolder() + s7damAsset.getName());
        this.setAssetMetadataProperty(asset, "dam:s7damCompanyID", s7Config.getCompanyHandle());
        this.setAssetMetadataProperty(asset, "dam:s7damDomain", publishedServer);
        this.setAssetMetadataProperty(asset, "dam:s7damAPIServer", this.scene7EndpointsManager.getAPIServer(s7Config.getRegion()).toString());
        this.setAssetMetadataProperty(asset, "dam:s7damCloudConfigPath", s7Config.getCloudConfigPath());
        this.setAssetMetadataProperty(asset, "dam:s7damFileStatus", status);
        this.setAssetMetadataProperty(asset, "dam:s7damUploadTimeStamp", Calendar.getInstance());
        Long s7LastModifiedTimestamp = s7damAsset.getModifiedDate().getTime();
        this.setAssetMetadataProperty(asset, "dam:s7damLastModified", s7LastModifiedTimestamp);
    }

    protected void bindScene7EndpointsManager(Scene7EndpointsManager scene7EndpointsManager) {
        this.scene7EndpointsManager = scene7EndpointsManager;
    }

    protected void unbindScene7EndpointsManager(Scene7EndpointsManager scene7EndpointsManager) {
        if (this.scene7EndpointsManager == scene7EndpointsManager) {
            this.scene7EndpointsManager = null;
        }
    }
}

