/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.hosted.sync.impl;

import com.day.cq.dam.api.s7dam.config.S7damConfigHosted;
import com.day.cq.dam.s7dam.hosted.constants.S7damJobType;
import com.day.cq.dam.s7dam.hosted.ips.S7damAPIClient;
import com.day.cq.dam.s7dam.hosted.ips.S7damService;
import com.day.cq.dam.s7dam.hosted.sync.S7damPublisher;
import com.day.cq.dam.s7dam.hosted.sync.S7damPublishingJob;
import com.day.cq.dam.scene7.api.Scene7EndpointsManager;
import com.day.cq.search.QueryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Component
@Service
public class S7damPublisherServiceImpl
implements S7damPublisher {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int JOB_PERIOD = 20;
    List<S7damPublishingJob> jobQueue = new ArrayList<S7damPublishingJob>();
    private EventListenerList listeners = new EventListenerList();
    @Reference
    private Scheduler scheduler;
    @Reference(policy=ReferencePolicy.STATIC)
    private SlingRepository repository;
    @Reference(policy=ReferencePolicy.STATIC)
    private ResourceResolverFactory resolverFactory;
    @Reference
    private QueryBuilder queryBuilder;
    @Reference
    private S7damService s7damService;
    @Reference
    private S7damAPIClient s7damAPIClient;
    @Reference
    private Scene7EndpointsManager scene7EndpointsManager;
    private ResourceResolver resolver;

    @Activate
    protected void activate(ComponentContext context) throws Exception {
        this.resolver = this.resolverFactory.getResourceResolver(null);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) throws Exception {
        if (this.resolver != null && this.resolver.isLive()) {
            this.resolver.close();
            this.resolver = null;
        }
    }

    @Override
    public void addJob(S7damConfigHosted s7Config, String path, Map<String, String> statusPublishQueryMap) {
        S7damPublishingJob job = new S7damPublishingJob(this, s7Config, path, statusPublishQueryMap, this.resolver, this.queryBuilder, this.s7damService, this.scene7EndpointsManager);
        boolean shouldAdd = true;
        for (S7damPublishingJob tmp : this.jobQueue) {
            if (!job.equals(tmp)) continue;
            if (tmp.getState() == S7damPublishingJob.State.PUBLISHING) {
                tmp.setShouldRepublish(true);
            }
            shouldAdd = false;
            tmp.updateTimestamp();
            this.log.debug("existing job updated for " + s7Config.getEmail());
            return;
        }
        if (shouldAdd) {
            this.log.debug("new job added for email '" + s7Config.getEmail() + "', company '" + s7Config.getCompanyHandle() + "' to '" + this.scene7EndpointsManager.getAPIServer(s7Config.getRegion().toString()) + "'");
            this.jobQueue.add(job);
            job.setState(S7damPublishingJob.State.QUEUED);
            HashMap config = new HashMap();
            try {
                this.scheduler.addPeriodicJob(job.getName(), (Object)job, config, 20L, true);
            }
            catch (Exception e) {
                this.log.error("Error while adding s7dam publishing job", (Throwable)e);
            }
        }
    }

    @Override
    public void removeJob(String name) {
        this.scheduler.removeJob(name);
        S7damPublishingJob job = null;
        for (S7damPublishingJob tmp : this.jobQueue) {
            if (!tmp.getName().equals(name)) continue;
            job = tmp;
            break;
        }
        this.jobQueue.remove(job);
        this.fireEvent(new ChangeEvent(job));
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    @Override
    public boolean isPublishJobActive(String publishJobType, S7damConfigHosted s7Config) {
        Document document = this.s7damAPIClient.getActiveJobs(null, null, s7Config);
        if (document != null) {
            NodeList activeJobNodeslist = document.getElementsByTagName("items");
            for (int i = 0; i < activeJobNodeslist.getLength(); ++i) {
                NodeList nodes = ((Element)activeJobNodeslist.item(i)).getElementsByTagName(publishJobType);
                if (nodes.getLength() <= 0 || nodes.item(0).getFirstChild() == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String startPublishJob(String path, S7damConfigHosted s7Config) {
        try {
            NodeList list;
            Document document;
            String jobName = "CQ5_publish_job_" + System.currentTimeMillis();
            if (path != null) {
                String basePubName = path.replaceAll("^/content/dam/", "").split("/")[0];
                jobName = "CQ5_publish_job_" + basePubName + "_" + System.currentTimeMillis();
            }
            if ((document = this.s7damAPIClient.submitJob(jobName, S7damJobType.IMAGE_SERVING_PUBLISH_JOB, s7Config)) != null && (list = document.getElementsByTagName("jobHandle")).getLength() > 0 && list.item(0).getFirstChild() != null) {
                return jobName;
            }
        }
        catch (Exception e) {
            this.log.error("startPublishJob failed: " + e.getMessage());
        }
        return null;
    }

    @Override
    public boolean isPublishJobSuccessByOrignalName(String originalName, S7damConfigHosted s7Config) {
        NodeList jobDetailsNodeslist;
        NodeList nodes;
        Boolean jobSuccess = false;
        Document document = this.s7damAPIClient.getJobLogDetails(null, originalName, s7Config);
        if (document != null && (nodes = ((Element)(jobDetailsNodeslist = document.getElementsByTagName("items")).item(0)).getElementsByTagName("fatalError")).getLength() > 0 && nodes.item(0).getFirstChild().getNodeValue() != null) {
            jobSuccess = "false".equals(nodes.item(0).getFirstChild().getNodeValue());
        }
        return jobSuccess;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(ChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(ChangeListener.class, listener);
    }

    private void fireEvent(ChangeEvent event) {
        ChangeListener[] arr = (ChangeListener[])this.listeners.getListeners(ChangeListener.class);
        for (int i = 0; i < arr.length; ++i) {
            arr[i].stateChanged(event);
        }
    }

    public void addJob(String email, String password, String companyHandle, String path, String datacenterUrl, Map<String, String> publishStatusQueryMap) {
        throw new UnsupportedOperationException("Deprecated method. Please use the [addJob(S7damConfigHosted s7Config, String path, Map<String, String> statusPublishQueryMap)] method");
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }

    protected void bindS7damService(S7damService s7damService) {
        this.s7damService = s7damService;
    }

    protected void unbindS7damService(S7damService s7damService) {
        if (this.s7damService == s7damService) {
            this.s7damService = null;
        }
    }

    protected void bindS7damAPIClient(S7damAPIClient s7damAPIClient) {
        this.s7damAPIClient = s7damAPIClient;
    }

    protected void unbindS7damAPIClient(S7damAPIClient s7damAPIClient) {
        if (this.s7damAPIClient == s7damAPIClient) {
            this.s7damAPIClient = null;
        }
    }

    protected void bindScene7EndpointsManager(Scene7EndpointsManager scene7EndpointsManager) {
        this.scene7EndpointsManager = scene7EndpointsManager;
    }

    protected void unbindScene7EndpointsManager(Scene7EndpointsManager scene7EndpointsManager) {
        if (this.scene7EndpointsManager == scene7EndpointsManager) {
            this.scene7EndpointsManager = null;
        }
    }
}

